/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.ReplaceEmptyArrayToConstantFix;
import com.siyeh.ig.psiutils.ConstructionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryEmptyArrayUsageInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.for.zero.length.array.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryEmptyArrayUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.for.zero.length.array.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryEmptyArrayUsageInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceEmptyArrayToConstantFix((PsiClass)infos[0], (PsiField)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiType arrayType;
                PsiClass typeClass;
                PsiType type2;
                if (ConstructionUtils.isEmptyArrayInitializer((PsiExpression)expression2) && (type2 = expression2.getType()) instanceof PsiArrayType && (typeClass = PsiTypesUtil.getPsiClass((PsiType)(arrayType = ((PsiArrayType)type2).getComponentType()))) != null) {
                    for (PsiField field : typeClass.getFields()) {
                        PsiModifierList modifiers = field.getModifierList();
                        if (modifiers == null || typeClass.isEquivalentTo(PsiTreeUtil.findFirstParent((PsiElement)expression2, e -> e instanceof PsiClass)) || !modifiers.hasModifierProperty("final") || !modifiers.hasModifierProperty("public") || !ConstructionUtils.isEmptyArrayInitializer(field.getInitializer())) continue;
                        this.registerError((PsiElement)expression2, typeClass, field);
                        return;
                    }
                }
                super.visitNewExpression(expression2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/UnnecessaryEmptyArrayUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

