/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToArrayCallWithZeroLengthArrayArgumentInspection
extends BaseInspection {
    private static final CallMatcher COLLECTION_SIZE = CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0);
    private static final CallMatcher COLLECTION_TO_ARRAY = CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(1);
    private static final String PREFER_EMPTY_ARRAY_SETTING = "PreferEmptyArray";
    @NotNull
    public PreferEmptyArray myMode = PreferEmptyArray.ALWAYS;

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 5, true, false));
        panel.add(new JLabel("Prefer empty array:"));
        ButtonGroup group = new ButtonGroup();
        for (PreferEmptyArray mode : PreferEmptyArray.values()) {
            JRadioButton radioButton = new JRadioButton(mode.getMessage(), mode == this.myMode);
            radioButton.addActionListener(e -> {
                this.myMode = mode;
            });
            panel.add(radioButton);
            group.add(radioButton);
        }
        return panel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[1];
        return new ToArrayCallWithZeroLengthArrayArgumentFix(this.myMode.isEmptyPreferred(argument));
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("to.array.call.style.display.name", new Object[0]);
        if (string == null) {
            ToArrayCallWithZeroLengthArrayArgumentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element node) {
        Element element;
        if (node == null) {
            ToArrayCallWithZeroLengthArrayArgumentInspection.$$$reportNull$$$0(1);
        }
        if ((element = node.getChild(PREFER_EMPTY_ARRAY_SETTING)) != null) {
            this.myMode = PreferEmptyArray.from(element.getAttributeValue("value"));
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            ToArrayCallWithZeroLengthArrayArgumentInspection.$$$reportNull$$$0(2);
        }
        Element element = new Element(PREFER_EMPTY_ARRAY_SETTING);
        element.setAttribute("value", this.myMode.toString());
        node.addContent(element);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[1];
        String string = this.myMode.isEmptyPreferred(argument) ? InspectionGadgetsBundle.message("to.array.call.style.problem.descriptor.presized", argument.getText()) : InspectionGadgetsBundle.message("to.array.call.style.problem.descriptor.zero", argument.getText());
        if (string == null) {
            ToArrayCallWithZeroLengthArrayArgumentInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                boolean wrongArray;
                if (!COLLECTION_TO_ARRAY.test(call)) {
                    return;
                }
                PsiExpression argument = call.getArgumentList().getExpressions()[0];
                PsiType type2 = argument.getType();
                if (!(type2 instanceof PsiArrayType)) {
                    return;
                }
                if (type2.getArrayDimensions() != 1) {
                    return;
                }
                boolean bl = wrongArray = ToArrayCallWithZeroLengthArrayArgumentInspection.this.myMode.isEmptyPreferred(argument) ? ToArrayCallWithZeroLengthArrayArgumentInspection.isPresizedArray(argument, call.getMethodExpression().getQualifierExpression()) : ToArrayCallWithZeroLengthArrayArgumentInspection.isEmptyArray(argument);
                if (wrongArray) {
                    this.registerMethodCallError(call, call, argument);
                }
            }
        };
    }

    private static boolean isEmptyArray(@Nullable PsiExpression argument) {
        if (argument instanceof PsiReferenceExpression) {
            PsiElement element = ((PsiReferenceExpression)argument).resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            return CollectionUtils.isConstantEmptyArray((PsiField)element);
        }
        return ConstructionUtils.isEmptyArrayInitializer(argument);
    }

    @Contract(value="_, null -> false")
    private static boolean isPresizedArray(@Nullable PsiExpression argument, @Nullable PsiExpression qualifier) {
        if (qualifier == null) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)argument), PsiNewExpression.class);
        if (newExpression == null) {
            return false;
        }
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length != 1) {
            return false;
        }
        PsiMethodCallExpression maybeSizeCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)dimensions[0]), PsiMethodCallExpression.class);
        if (COLLECTION_SIZE.test(maybeSizeCall)) {
            PsiExpression sizeQualifier = maybeSizeCall.getMethodExpression().getQualifierExpression();
            return sizeQualifier != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sizeQualifier, (PsiElement)qualifier);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToArrayCallWithZeroLengthArrayArgumentFix
    extends InspectionGadgetsFix {
        private boolean myEmptyPreferred;

        public ToArrayCallWithZeroLengthArrayArgumentFix(boolean emptyPreferred) {
            this.myEmptyPreferred = emptyPreferred;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myEmptyPreferred ? InspectionGadgetsBundle.message("to.array.call.style.quickfix.make.zero", new Object[0]) : InspectionGadgetsBundle.message("to.array.call.style.quickfix.make.presized", new Object[0]);
            if (string == null) {
                ToArrayCallWithZeroLengthArrayArgumentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("to.array.call.style.quickfix.family.name", new Object[0]);
            if (string == null) {
                ToArrayCallWithZeroLengthArrayArgumentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (qualifier == null) {
                return;
            }
            String collectionText = qualifier.getText();
            PsiType type2 = argument.getType();
            if (type2 == null) {
                return;
            }
            PsiType componentType = type2.getDeepComponentType();
            String typeText = componentType.getCanonicalText();
            if (this.myEmptyPreferred || ExpressionUtils.isSimpleExpression(qualifier)) {
                CommentTracker ct = new CommentTracker();
                String sizeClause = this.myEmptyPreferred ? "0" : collectionText + ".size()";
                String replacementText = "new " + typeText + '[' + sizeClause + "]";
                ct.replaceAndRestoreComments((PsiElement)argument, replacementText);
                return;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return;
            }
            PsiDeclarationStatement declarationStatement = factory.createVariableDeclarationStatement("var", qualifierType, qualifier);
            PsiElement statementParent = statement.getParent();
            while (statementParent instanceof PsiLoopStatement || statementParent instanceof PsiIfStatement) {
                statement = (PsiStatement)statementParent;
                statementParent = statement.getParent();
            }
            String toArrayText = "var.toArray(new " + typeText + "[var.size()])";
            PsiMethodCallExpression newMethodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(toArrayText, (PsiElement)methodCallExpression);
            declarationStatement = (PsiDeclarationStatement)statementParent.addBefore((PsiElement)declarationStatement, (PsiElement)statement);
            newMethodCallExpression = (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)newMethodCallExpression);
            this.showRenameTemplate(declarationStatement, newMethodCallExpression, statementParent);
        }

        private void showRenameTemplate(PsiDeclarationStatement declarationStatement, PsiMethodCallExpression methodCallExpression, PsiElement context) {
            if (!this.isOnTheFly()) {
                return;
            }
            PsiVariable variable = (PsiVariable)declarationStatement.getDeclaredElements()[0];
            PsiReferenceExpression ref1 = (PsiReferenceExpression)methodCallExpression.getMethodExpression().getQualifierExpression();
            PsiNewExpression argument = (PsiNewExpression)methodCallExpression.getArgumentList().getExpressions()[0];
            PsiMethodCallExpression sizeExpression = (PsiMethodCallExpression)argument.getArrayDimensions()[0];
            PsiReferenceExpression ref2 = (PsiReferenceExpression)sizeExpression.getMethodExpression().getQualifierExpression();
            HighlightUtils.showRenameTemplate(context, (PsiNameIdentifierOwner)variable, new PsiReference[]{ref1, ref2});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection$ToArrayCallWithZeroLengthArrayArgumentFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static enum PreferEmptyArray {
        ALWAYS("Always"),
        BY_LEVEL("According to language level"),
        NEVER("Never (prefer pre-sized array)");

        private final String myMessage;

        private PreferEmptyArray(String message2) {
            this.myMessage = message2;
        }

        String getMessage() {
            return this.myMessage;
        }

        boolean isEmptyPreferred(PsiExpression expression2) {
            switch (this) {
                case ALWAYS: {
                    return true;
                }
                case NEVER: {
                    return false;
                }
            }
            return PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2);
        }

        @NotNull
        static PreferEmptyArray from(String name) {
            PreferEmptyArray preferEmptyArray = StreamEx.of((Object[])PreferEmptyArray.values()).filterBy(Enum::name, (Object)name).findFirst().orElse(ALWAYS);
            if (preferEmptyArray == null) {
                PreferEmptyArray.$$$reportNull$$$0(0);
            }
            return preferEmptyArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection$PreferEmptyArray", "from"));
        }
    }
}

