/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class UtilityClassUtil {
    private UtilityClassUtil() {
    }

    public static boolean hasPrivateEmptyOrNoConstructor(@NotNull PsiClass aClass) {
        PsiMethod[] constructors;
        if (aClass == null) {
            UtilityClassUtil.$$$reportNull$$$0(0);
        }
        if ((constructors = aClass.getConstructors()).length == 0) {
            return true;
        }
        if (constructors.length != 1) {
            return false;
        }
        PsiMethod constructor = constructors[0];
        return constructor.hasModifierProperty("private") && ControlFlowUtils.isEmptyCodeBlock(constructor.getBody());
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            UtilityClassUtil.$$$reportNull$$$0(1);
        }
        return UtilityClassUtil.isUtilityClass(aClass, true);
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass, boolean fullCheck) {
        if (aClass == null) {
            UtilityClassUtil.$$$reportNull$$$0(2);
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (fullCheck && extendsList != null && extendsList.getReferenceElements().length > 0) {
            return false;
        }
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList != null && implementsList.getReferenceElements().length > 0) {
            return false;
        }
        PsiMethod[] methods = aClass.getMethods();
        int staticMethodCount = UtilityClassUtil.countStaticMethods(methods);
        if (staticMethodCount < 0) {
            return false;
        }
        PsiField[] fields = aClass.getFields();
        if (!UtilityClassUtil.allFieldsStatic(fields)) {
            return false;
        }
        if (fullCheck) {
            for (ImplicitSubclassProvider subclassProvider : (ImplicitSubclassProvider[])ImplicitSubclassProvider.EP_NAME.getExtensions()) {
                if (!subclassProvider.isApplicableTo(aClass) || subclassProvider.getSubclassingInfo(aClass) == null) continue;
                return false;
            }
        }
        return !fullCheck || staticMethodCount != 0 || fields.length != 0;
    }

    private static boolean allFieldsStatic(PsiField[] fields) {
        for (PsiField field : fields) {
            if (field.hasModifierProperty("static")) continue;
            return false;
        }
        return true;
    }

    private static int countStaticMethods(PsiMethod[] methods) {
        int staticCount = 0;
        for (PsiMethod method : methods) {
            if (method.isConstructor()) continue;
            if (!method.hasModifierProperty("static")) {
                return -1;
            }
            if (method.hasModifierProperty("private")) continue;
            ++staticCount;
        }
        return staticCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "aClass";
        objectArray2[1] = "com/siyeh/ig/psiutils/UtilityClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPrivateEmptyOrNoConstructor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUtilityClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

