/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantFieldInitializationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnNull = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.display.name", new Object[0]);
        if (string == null) {
            RedundantFieldInitializationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantFieldInitializationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn on initialization to null", (InspectionProfileEntry)this, "onlyWarnOnNull");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantFieldInitializationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantFieldInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/RedundantFieldInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class RedundantFieldInitializationVisitor
    extends BaseInspectionVisitor {
        private RedundantFieldInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                RedundantFieldInitializationVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasInitializer() || field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return;
            }
            String text2 = initializer.getText();
            PsiType type2 = field.getType();
            if (PsiType.BOOLEAN.equals((Object)type2) ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !"false".equals(text2) : (type2 instanceof PsiPrimitiveType ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !ExpressionUtils.isZero(initializer) : !PsiType.NULL.equals((Object)initializer.getType()))) {
                return;
            }
            if (initializer instanceof PsiReferenceExpression || !PsiTreeUtil.findChildrenOfType((PsiElement)initializer, PsiReferenceExpression.class).isEmpty()) {
                return;
            }
            if (this.isAssignmentInInitializerOverwritten(field)) {
                return;
            }
            this.registerError((PsiElement)initializer, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private boolean isAssignmentInInitializerOverwritten(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            PsiClass aClass;
            if (field == null) {
                RedundantFieldInitializationVisitor.$$$reportNull$$$0(1);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return false;
            }
            boolean isStatic = field.hasModifierProperty("static");
            for (PsiClassInitializer classInitializer : initializers = aClass.getInitializers()) {
                if (classInitializer.hasModifierProperty("static") != isStatic || classInitializer.getTextOffset() >= field.getTextOffset() || !VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)classInitializer)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAssignmentInInitializerOverwritten";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RedundantFieldInitializationFix
    extends InspectionGadgetsFix {
        private RedundantFieldInitializationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.field.initialization.remove.quickfix", new Object[0]);
            if (string == null) {
                RedundantFieldInitializationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            descriptor.getPsiElement().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationFix", "getFamilyName"));
        }
    }
}

