/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnclearBinaryExpressionInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("UnclearExpression" == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(0);
        }
        return "UnclearExpression";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.display.name", new Object[0]);
        if (string == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnclearBinaryExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnclearBinaryExpressionVisitor();
    }

    public static boolean mightBeConfusingExpression(@Nullable PsiElement element) {
        return element instanceof PsiPolyadicExpression || element instanceof PsiConditionalExpression || element instanceof PsiInstanceOfExpression || element instanceof PsiAssignmentExpression || element instanceof PsiParenthesizedExpression;
    }

    @Contract(value="null, _ -> false")
    public static boolean isUnclearExpression(PsiExpression expression2, PsiElement parent) {
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression nestedAssignment;
            IElementType nestedTokenType;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (parent instanceof PsiVariable ? !tokenType.equals(JavaTokenType.EQ) : parent instanceof PsiAssignmentExpression && !tokenType.equals(nestedTokenType = (nestedAssignment = (PsiAssignmentExpression)parent).getOperationTokenType())) {
                return true;
            }
            return UnclearBinaryExpressionInspection.isUnclearExpression(assignmentExpression.getRExpression(), (PsiElement)assignmentExpression);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)expression2)) {
                return false;
            }
            return parent instanceof PsiConditionalExpression || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getCondition(), (PsiElement)conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getThenExpression(), (PsiElement)conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getElseExpression(), (PsiElement)conditionalExpression);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            if (parent instanceof PsiConditionalExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiInstanceOfExpression) {
                return true;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                PsiType type2 = operand2.getType();
                if (type2 == null || type2.equalsToText("java.lang.String")) {
                    return false;
                }
                if (!UnclearBinaryExpressionInspection.isUnclearExpression(operand2, (PsiElement)polyadicExpression)) continue;
                return true;
            }
        } else {
            if (expression2 instanceof PsiInstanceOfExpression) {
                if (parent instanceof PsiPolyadicExpression || parent instanceof PsiConditionalExpression) {
                    return true;
                }
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
                return UnclearBinaryExpressionInspection.isUnclearExpression(instanceOfExpression.getOperand(), (PsiElement)instanceOfExpression);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                PsiExpression nestedExpression = parenthesizedExpression.getExpression();
                return UnclearBinaryExpressionInspection.isUnclearExpression(nestedExpression, (PsiElement)parenthesizedExpression);
            }
        }
        return false;
    }

    public static void replaceElement(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)element;
        String newExpressionText = UnclearBinaryExpressionInspection.createReplacementText(expression2, new StringBuilder()).toString();
        PsiReplacementUtil.replaceExpression(expression2, newExpressionText);
    }

    private static StringBuilder createReplacementText(@Nullable PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            PsiElement parent = expression2.getParent();
            boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiInstanceOfExpression || parent instanceof PsiPolyadicExpression;
            UnclearBinaryExpressionInspection.appendText((PsiExpression)polyadicExpression, parentheses, out);
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            for (PsiElement child : expression2.getChildren()) {
                if (child instanceof PsiExpression) {
                    PsiExpression unwrappedExpression = (PsiExpression)child;
                    UnclearBinaryExpressionInspection.createReplacementText(unwrappedExpression, out);
                    continue;
                }
                out.append(child.getText());
            }
        } else if (expression2 instanceof PsiInstanceOfExpression) {
            PsiElement parent = expression2.getParent();
            boolean parentheses = parent instanceof PsiPolyadicExpression || parent instanceof PsiConditionalExpression;
            UnclearBinaryExpressionInspection.appendText(expression2, parentheses, out);
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiElement parent = expression2.getParent();
            boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiInstanceOfExpression;
            UnclearBinaryExpressionInspection.appendText(expression2, parentheses, out);
        } else if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            PsiElement parent = expression2.getParent();
            boolean parentheses = !UnclearBinaryExpressionInspection.isSimpleAssignment(assignmentExpression, parent);
            UnclearBinaryExpressionInspection.appendText((PsiExpression)assignmentExpression, parentheses, out);
        } else if (expression2 != null) {
            out.append(expression2.getText());
        }
        return out;
    }

    private static boolean isSimpleAssignment(PsiAssignmentExpression assignmentExpression, PsiElement parent) {
        IElementType parentTokenType;
        if (parent instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentAssignmentExpression = (PsiAssignmentExpression)parent;
            parentTokenType = parentAssignmentExpression.getOperationTokenType();
        } else if (parent instanceof PsiVariable) {
            parentTokenType = JavaTokenType.EQ;
        } else {
            return false;
        }
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        return parentTokenType.equals(tokenType);
    }

    private static void appendText(PsiExpression expression2, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        for (PsiElement child : expression2.getChildren()) {
            if (child instanceof PsiExpression) {
                UnclearBinaryExpressionInspection.createReplacementText((PsiExpression)child, out);
                continue;
            }
            out.append(child.getText());
        }
        if (parentheses) {
            out.append(')');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnclearBinaryExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnclearBinaryExpressionVisitor
    extends BaseInspectionVisitor {
        private UnclearBinaryExpressionVisitor() {
        }

        public void visitExpression(PsiExpression expression2) {
            super.visitExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent) || !UnclearBinaryExpressionInspection.isUnclearExpression(expression2, parent)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class UnclearBinaryExpressionFix
    extends InspectionGadgetsFix {
        private UnclearBinaryExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unclear.binary.expression.quickfix", new Object[0]);
            if (string == null) {
                UnclearBinaryExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            UnclearBinaryExpressionInspection.replaceElement(descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix", "getFamilyName"));
        }
    }
}

