/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryBlockStatementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSwitchBranches = false;

    @NotNull
    public String getID() {
        if ("UnnecessaryCodeBlock" == null) {
            UnnecessaryBlockStatementInspection.$$$reportNull$$$0(0);
        }
        return "UnnecessaryCodeBlock";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.code.block.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryBlockStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.block.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryBlockStatementInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.branches.of.switch.statements", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchBranches");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBlockStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBlockFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryBlockStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryBlockStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBlockStatementVisitor() {
        }

        public void visitBlockStatement(PsiBlockStatement blockStatement) {
            PsiElement prevStatement;
            super.visitBlockStatement(blockStatement);
            if (UnnecessaryBlockStatementInspection.this.ignoreSwitchBranches && (prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)blockStatement)) instanceof PsiSwitchLabelStatement) {
                return;
            }
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiJavaToken brace = codeBlock.getLBrace();
            if (brace == null) {
                return;
            }
            PsiCodeBlock parentBlock = (PsiCodeBlock)parent;
            if (parentBlock.getStatements().length > 1 && DeclarationSearchUtils.containsConflictingDeclarations(codeBlock, parentBlock)) {
                return;
            }
            this.registerError((PsiElement)brace, new Object[0]);
        }
    }

    private static class UnnecessaryBlockFix
    extends InspectionGadgetsFix {
        private UnnecessaryBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.code.block.unwrap.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement leftBrace = descriptor.getPsiElement();
            PsiElement parent = leftBrace.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)parent;
            PsiElement firstBodyElement = block.getFirstBodyElement();
            PsiElement lastBodyElement = block.getLastBodyElement();
            PsiBlockStatement blockStatement = (PsiBlockStatement)block.getParent();
            if (firstBodyElement != null && lastBodyElement != null) {
                PsiElement element = blockStatement.getParent();
                element.addRangeBefore(firstBodyElement, lastBodyElement, (PsiElement)blockStatement);
            }
            blockStatement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryBlockStatementInspection$UnnecessaryBlockFix", "getFamilyName"));
        }
    }
}

