/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessarySuperConstructorInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("UnnecessaryCallToSuper" == null) {
            UnnecessarySuperConstructorInspection.$$$reportNull$$$0(0);
        }
        return "UnnecessaryCallToSuper";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.display.name", new Object[0]);
        if (string == null) {
            UnnecessarySuperConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySuperConstructorInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarySuperConstructorFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessarySuperConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessarySuperConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySuperConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                UnnecessarySuperConstructorVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodText = methodExpression.getText();
            if (!"super".equals(methodText)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return;
            }
            this.registerError((PsiElement)call, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorVisitor", "visitMethodCallExpression"));
        }
    }

    private static class UnnecessarySuperConstructorFix
    extends InspectionGadgetsFix {
        private UnnecessarySuperConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySuperConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement superCall = descriptor.getPsiElement();
            PsiElement callStatement = superCall.getParent();
            assert (callStatement != null);
            UnnecessarySuperConstructorFix.deleteElement(callStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorFix", "getFamilyName"));
        }
    }
}

