/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

class VariableAccessVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiClass aClass;
    private final Set<PsiField> m_synchronizedAccesses;
    private final Set<PsiField> m_unsynchronizedAccesses;
    private final Set<PsiMethod> methodsAlwaysSynchronized;
    private final Set<PsiMethod> methodsNotAlwaysSynchronized;
    private final Set<PsiMethod> unusedMethods;
    private final Set<PsiMethod> usedMethods;
    private boolean m_inInitializer;
    private int m_inSynchronizedContextCount;
    private final Stack<Integer> contextStack;
    private final Stack<Boolean> contextInitializerStack;
    private boolean privateMethodUsagesCalculated;
    private final boolean countGettersAndSetters;
    private static final Key<Boolean> CODE_BLOCK_CONTAINS_HOLDS_LOCK_CALL = Key.create((String)"CODE_BLOCK_CONTAINS_HOLDS_LOCK_CALL");

    VariableAccessVisitor(@NotNull PsiClass aClass, boolean countGettersAndSetters) {
        if (aClass == null) {
            VariableAccessVisitor.$$$reportNull$$$0(0);
        }
        this.m_synchronizedAccesses = new HashSet<PsiField>(2);
        this.m_unsynchronizedAccesses = new HashSet<PsiField>(2);
        this.methodsAlwaysSynchronized = new HashSet<PsiMethod>();
        this.methodsNotAlwaysSynchronized = new HashSet<PsiMethod>();
        this.unusedMethods = new HashSet<PsiMethod>();
        this.usedMethods = new HashSet<PsiMethod>();
        this.contextStack = new Stack();
        this.contextInitializerStack = new Stack();
        this.aClass = aClass;
        this.countGettersAndSetters = countGettersAndSetters;
    }

    public void visitClass(PsiClass classToVisit) {
        this.calculatePrivateMethodUsagesIfNecessary();
        if (!classToVisit.equals(this.aClass)) {
            this.contextStack.push(this.m_inSynchronizedContextCount);
            this.m_inSynchronizedContextCount = 0;
            this.contextInitializerStack.push(this.m_inInitializer);
            this.m_inInitializer = false;
        }
        super.visitClass(classToVisit);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.contextStack.push(this.m_inSynchronizedContextCount);
        this.m_inSynchronizedContextCount = 0;
        this.contextInitializerStack.push(this.m_inInitializer);
        this.m_inInitializer = false;
        super.visitLambdaExpression(expression2);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            VariableAccessVisitor.$$$reportNull$$$0(1);
        }
        super.visitReferenceExpression(ref);
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return;
        }
        PsiElement element = ref.resolve();
        if (!(element instanceof PsiField)) {
            return;
        }
        if (!this.m_inInitializer) {
            if (this.m_inSynchronizedContextCount > 0) {
                this.m_synchronizedAccesses.add((PsiField)element);
            } else if (ref.getParent() instanceof PsiSynchronizedStatement) {
                this.m_synchronizedAccesses.add((PsiField)element);
            } else {
                this.m_unsynchronizedAccesses.add((PsiField)element);
            }
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        super.visitMethodCallExpression(expression2);
        if (!this.countGettersAndSetters) {
            return;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return;
        }
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        PsiField field = PropertyUtil.getFieldOfGetter(method);
        if (field == null) {
            field = PropertyUtil.getFieldOfSetter(method);
        }
        if (field == null) {
            return;
        }
        if (!this.m_inInitializer) {
            if (this.m_inSynchronizedContextCount > 0) {
                this.m_synchronizedAccesses.add(field);
            } else {
                this.m_unsynchronizedAccesses.add(field);
            }
        }
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        if (block.getParent() instanceof PsiSynchronizedStatement) {
            ++this.m_inSynchronizedContextCount;
        }
        super.visitCodeBlock(block);
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        PsiExpression condition2 = statement.getAssertCondition();
        if (SynchronizationUtil.isCallToHoldsLock(condition2)) {
            ++this.m_inSynchronizedContextCount;
            PsiElement codeBlock = statement.getParent();
            if (codeBlock != null) {
                codeBlock.putUserData(CODE_BLOCK_CONTAINS_HOLDS_LOCK_CALL, (Object)true);
            }
        }
        super.visitAssertStatement(statement);
    }

    public void visitMethod(@NotNull PsiMethod method) {
        boolean isConstructor;
        boolean methodIsSynchronized;
        if (method == null) {
            VariableAccessVisitor.$$$reportNull$$$0(2);
        }
        if (method.hasModifierProperty("private") && this.unusedMethods.contains(method)) {
            return;
        }
        boolean bl = methodIsSynchronized = method.hasModifierProperty("synchronized") || this.methodIsAlwaysUsedSynchronized(method);
        if (methodIsSynchronized) {
            ++this.m_inSynchronizedContextCount;
        }
        if (isConstructor = method.isConstructor()) {
            this.m_inInitializer = true;
        }
        super.visitMethod(method);
    }

    private boolean methodIsAlwaysUsedSynchronized(PsiMethod method) {
        if (!method.hasModifierProperty("private")) {
            return false;
        }
        return this.methodsAlwaysSynchronized.contains(method);
    }

    private void calculatePrivateMethodUsagesIfNecessary() {
        if (this.privateMethodUsagesCalculated) {
            return;
        }
        Set<PsiMethod> privateMethods = this.findPrivateMethods();
        HashMap<PsiMethod, Collection<PsiReference>> referenceMap = VariableAccessVisitor.buildReferenceMap(privateMethods);
        this.determineUsedMethods(privateMethods, referenceMap);
        this.determineUsageMap(referenceMap);
        this.privateMethodUsagesCalculated = true;
    }

    private void determineUsageMap(HashMap<PsiMethod, Collection<PsiReference>> referenceMap) {
        HashSet<PsiMethod> remainingMethods = new HashSet<PsiMethod>(this.usedMethods);
        boolean stabilized = false;
        while (!stabilized) {
            ProgressManager.checkCanceled();
            stabilized = true;
            HashSet<PsiMethod> methodsDeterminedThisPass = new HashSet<PsiMethod>();
            for (PsiMethod method : remainingMethods) {
                ProgressManager.checkCanceled();
                Collection references = (Collection)referenceMap.get((Object)method);
                boolean areAllReferencesSynchronized = true;
                for (PsiReference reference : references) {
                    ProgressManager.checkCanceled();
                    if (!this.isKnownToBeUsed(reference)) continue;
                    if (this.isInKnownUnsynchronizedContext(reference)) {
                        this.methodsNotAlwaysSynchronized.add(method);
                        methodsDeterminedThisPass.add(method);
                        areAllReferencesSynchronized = false;
                        stabilized = false;
                        break;
                    }
                    if (this.isInKnownSynchronizedContext(reference)) continue;
                    areAllReferencesSynchronized = false;
                }
                if (!areAllReferencesSynchronized || !this.unusedMethods.contains(method)) continue;
                this.methodsAlwaysSynchronized.add(method);
                methodsDeterminedThisPass.add(method);
                stabilized = false;
            }
            remainingMethods.removeAll(methodsDeterminedThisPass);
        }
        this.methodsAlwaysSynchronized.addAll(remainingMethods);
    }

    private void determineUsedMethods(Set<PsiMethod> privateMethods, HashMap<PsiMethod, Collection<PsiReference>> referenceMap) {
        HashSet<PsiMethod> remainingMethods = new HashSet<PsiMethod>(privateMethods);
        boolean stabilized = false;
        while (!stabilized) {
            ProgressManager.checkCanceled();
            stabilized = true;
            HashSet<PsiMethod> methodsDeterminedThisPass = new HashSet<PsiMethod>();
            for (PsiMethod method : remainingMethods) {
                ProgressManager.checkCanceled();
                Collection references = (Collection)referenceMap.get((Object)method);
                for (PsiReference reference : references) {
                    ProgressManager.checkCanceled();
                    if (!this.isKnownToBeUsed(reference)) continue;
                    this.usedMethods.add(method);
                    methodsDeterminedThisPass.add(method);
                    stabilized = false;
                }
            }
            remainingMethods.removeAll(methodsDeterminedThisPass);
        }
        this.unusedMethods.addAll(remainingMethods);
    }

    private static HashMap<PsiMethod, Collection<PsiReference>> buildReferenceMap(Set<PsiMethod> privateMethods) {
        HashMap referenceMap = new HashMap();
        for (PsiMethod method : privateMethods) {
            ProgressManager.checkCanceled();
            SearchScope scope = method.getUseScope();
            Collection references = ReferencesSearch.search((PsiElement)method, (SearchScope)scope).findAll();
            referenceMap.put((Object)method, (Object)references);
        }
        return referenceMap;
    }

    private Set<PsiMethod> findPrivateMethods() {
        PsiMethod[] methods;
        HashSet<PsiMethod> privateMethods = new HashSet<PsiMethod>();
        for (PsiMethod method : methods = this.aClass.getMethods()) {
            ProgressManager.checkCanceled();
            if (!method.hasModifierProperty("private")) continue;
            privateMethods.add(method);
        }
        return privateMethods;
    }

    private boolean isKnownToBeUsed(PsiReference reference) {
        PsiElement element = reference.getElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method == null) {
            return true;
        }
        if (!method.hasModifierProperty("private")) {
            return true;
        }
        return this.usedMethods.contains(method);
    }

    private boolean isInKnownSynchronizedContext(PsiReference reference) {
        PsiElement element = reference.getElement();
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class) != null) {
            return true;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method == null) {
            return false;
        }
        if (method.hasModifierProperty("synchronized")) {
            return true;
        }
        if (this.methodsAlwaysSynchronized.contains(method)) {
            return true;
        }
        return !this.methodsNotAlwaysSynchronized.contains(method);
    }

    private boolean isInKnownUnsynchronizedContext(PsiReference reference) {
        PsiElement element = reference.getElement();
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class) != null) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method == null) {
            return true;
        }
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (!method.hasModifierProperty("private")) {
            return true;
        }
        if (this.methodsAlwaysSynchronized.contains(method)) {
            return false;
        }
        return this.methodsNotAlwaysSynchronized.contains(method);
    }

    public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            VariableAccessVisitor.$$$reportNull$$$0(3);
        }
        this.m_inInitializer = true;
        super.visitClassInitializer(initializer);
    }

    public void visitField(@NotNull PsiField field) {
        if (field == null) {
            VariableAccessVisitor.$$$reportNull$$$0(4);
        }
        this.m_inInitializer = true;
        super.visitField(field);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        PsiMethod method;
        if (element == null) {
            VariableAccessVisitor.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiField || element instanceof PsiClassInitializer || element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            this.m_inInitializer = false;
        }
        if (element instanceof PsiClass && !element.equals(this.aClass) || element instanceof PsiLambdaExpression) {
            this.m_inSynchronizedContextCount = this.contextStack.pop();
            this.m_inInitializer = this.contextInitializerStack.pop();
        }
        if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiSynchronizedStatement) {
            --this.m_inSynchronizedContextCount;
        } else if (element instanceof PsiMethod && ((method = (PsiMethod)element).hasModifierProperty("synchronized") || this.methodIsAlwaysUsedSynchronized(method))) {
            --this.m_inSynchronizedContextCount;
        }
        if (element.getUserData(CODE_BLOCK_CONTAINS_HOLDS_LOCK_CALL) != null) {
            --this.m_inSynchronizedContextCount;
            element.putUserData(CODE_BLOCK_CONTAINS_HOLDS_LOCK_CALL, null);
        }
    }

    Set<PsiField> getInappropriatelyAccessedFields() {
        HashSet<PsiField> out = new HashSet<PsiField>(this.m_synchronizedAccesses);
        out.retainAll(this.m_unsynchronizedAccesses);
        return out;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/threading/VariableAccessVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClassInitializer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

