/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ComparisonPredicate;
import org.jetbrains.annotations.NotNull;

public class NegateComparisonIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        String operatorText = "";
        String negatedOperatorText = "";
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        if (exp != null) {
            PsiJavaToken sign = exp.getOperationSign();
            operatorText = sign.getText();
            negatedOperatorText = ComparisonUtils.getNegatedComparison(sign.getTokenType());
        }
        if (operatorText.equals(negatedOperatorText)) {
            return IntentionPowerPackBundle.message("negate.comparison.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("negate.comparison.intention.name1", operatorText, negatedOperatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ComparisonPredicate comparisonPredicate = new ComparisonPredicate();
        if (comparisonPredicate == null) {
            NegateComparisonIntention.$$$reportNull$$$0(0);
        }
        return comparisonPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression expression2 = (PsiBinaryExpression)element;
        PsiExpression lhs = expression2.getLOperand();
        PsiExpression rhs = expression2.getROperand();
        String negatedOperator = ComparisonUtils.getNegatedComparison(expression2.getOperationTokenType());
        String lhsText = lhs.getText();
        assert (rhs != null);
        String rhsText = rhs.getText();
        CommentTracker tracker = new CommentTracker();
        tracker.markUnchanged(lhs);
        tracker.markUnchanged(rhs);
        NegateComparisonIntention.replaceExpressionWithNegatedExpressionString(lhsText + negatedOperator + rhsText, (PsiExpression)expression2, tracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/bool/NegateComparisonIntention", "getElementPredicate"));
    }
}

