/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.commutative.FlipCommutativeMethodCallPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipCommutativeMethodCallIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        assert (methodName != null);
        if ("equals".equals(methodName) || "equalsIgnoreCase".equals(methodName)) {
            return IntentionPowerPackBundle.message("flip.commutative.method.call.intention.name", methodName);
        }
        return IntentionPowerPackBundle.message("flip.commutative.method.call.intention.name1", methodName);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        FlipCommutativeMethodCallPredicate flipCommutativeMethodCallPredicate = new FlipCommutativeMethodCallPredicate();
        if (flipCommutativeMethodCallPredicate == null) {
            FlipCommutativeMethodCallIntention.$$$reportNull$$$0(0);
        }
        return flipCommutativeMethodCallPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        PsiExpression target = methodExpression.getQualifierExpression();
        if (target == null) {
            return;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression arg = argumentList.getExpressions()[0];
        PsiExpression strippedTarget = ParenthesesUtils.stripParentheses(target);
        if (strippedTarget == null) {
            return;
        }
        PsiExpression strippedArg = ParenthesesUtils.stripParentheses(arg);
        if (strippedArg == null) {
            return;
        }
        String callString = ParenthesesUtils.getPrecedence(strippedArg) > 1 ? '(' + strippedArg.getText() + ")." + methodName + '(' + strippedTarget.getText() + ')' : strippedArg.getText() + '.' + methodName + '(' + strippedTarget.getText() + ')';
        CommentTracker commentTracker = new CommentTracker();
        commentTracker.markUnchanged(strippedArg);
        commentTracker.markUnchanged(strippedTarget);
        PsiReplacementUtil.replaceExpression((PsiExpression)call, callString, commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/commutative/FlipCommutativeMethodCallIntention", "getElementPredicate"));
    }
}

