/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithStringBufferIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return IntentionPowerPackBundle.message("replace.concatenation.with.string.builder.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("replace.concatenation.with.string.buffer.intention.name", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate(true);
        if (simpleStringConcatenationPredicate == null) {
            ReplaceConcatenationWithStringBufferIntention.$$$reportNull$$$0(0);
        }
        return simpleStringConcatenationPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ReplaceConcatenationWithStringBufferIntention.$$$reportNull$$$0(1);
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiElement parent = expression2.getParent();
        while (ExpressionUtils.isConcatenation(parent)) {
            expression2 = (PsiPolyadicExpression)parent;
            parent = expression2.getParent();
        }
        CommentTracker commentTracker = new CommentTracker();
        StringBuilder newExpression = new StringBuilder();
        if (ReplaceConcatenationWithStringBufferIntention.isPartOfStringBufferAppend((PsiExpression)expression2)) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            assert (methodCallExpression != null);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null) {
                String qualifierText = commentTracker.markUnchanged(qualifierExpression2).getText();
                newExpression.append(qualifierText);
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression2, newExpression, commentTracker);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString(), commentTracker);
        } else {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2)) {
                newExpression.append("new StringBuffer()");
            } else {
                newExpression.append("new StringBuilder()");
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression2, newExpression, commentTracker);
            newExpression.append(".toString()");
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString(), commentTracker);
        }
    }

    private static boolean isPartOfStringBufferAppend(PsiExpression expression2) {
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiType type2 = methodExpression.getType();
        if (type2 == null) {
            return false;
        }
        String className = type2.getCanonicalText();
        if (!"java.lang.StringBuffer".equals(className) && !"java.lang.StringBuilder".equals(className)) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        return "append".equals(methodName);
    }

    private static void turnExpressionIntoChainedAppends(PsiExpression expression2, @NonNls StringBuilder result, CommentTracker commentTracker) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression concatenation = (PsiPolyadicExpression)expression2;
            PsiType type2 = concatenation.getType();
            if (type2 != null && !type2.equalsToText("java.lang.String")) {
                result.append(".append(").append(commentTracker.markUnchanged(concatenation).getText()).append(')');
                return;
            }
            PsiExpression[] operands2 = concatenation.getOperands();
            PsiType startType = operands2[0].getType();
            if (startType == null || startType.equalsToText("java.lang.String")) {
                for (PsiExpression operand2 : operands2) {
                    ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand2, result, commentTracker);
                }
                return;
            }
            StringBuilder newExpressionText = new StringBuilder(operands2[0].getText());
            boolean string = false;
            for (int i = 1; i < operands2.length; ++i) {
                PsiExpression operand3 = operands2[i];
                if (!string) {
                    PsiType operandType = operand3.getType();
                    if (operandType == null || operandType.equalsToText("java.lang.String")) {
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
                        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText.toString(), (PsiElement)expression2);
                        ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(newExpression, result, commentTracker);
                        ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand3, result, commentTracker);
                        string = true;
                    }
                    newExpressionText.append('+').append(commentTracker.markUnchanged(operand3).getText());
                    continue;
                }
                ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand3, result, commentTracker);
            }
        } else {
            PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression2);
            result.append(".append(");
            if (strippedExpression != null) {
                result.append(commentTracker.markUnchanged(strippedExpression).getText());
            }
            result.append(')');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/concatenation/ReplaceConcatenationWithStringBufferIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/concatenation/ReplaceConcatenationWithStringBufferIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

