/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.NestedTryStatementsPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeNestedTryStatementsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        NestedTryStatementsPredicate nestedTryStatementsPredicate = new NestedTryStatementsPredicate();
        if (nestedTryStatementsPredicate == null) {
            MergeNestedTryStatementsIntention.$$$reportNull$$$0(0);
        }
        return nestedTryStatementsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCatchSection[] catchSections1;
        PsiCatchSection[] catchSections2;
        PsiCodeBlock tryBlock2;
        PsiCodeBlock tryBlock1;
        if (element == null) {
            MergeNestedTryStatementsIntention.$$$reportNull$$$0(1);
        }
        PsiTryStatement tryStatement1 = (PsiTryStatement)element.getParent();
        StringBuilder newTryStatement = new StringBuilder("try ");
        PsiResourceList list1 = tryStatement1.getResourceList();
        int resourceCount = 0;
        if (list1 != null) {
            resourceCount = MergeNestedTryStatementsIntention.appendResources(newTryStatement, resourceCount, list1);
        }
        if ((tryBlock1 = tryStatement1.getTryBlock()) == null) {
            return;
        }
        PsiStatement[] statements = tryBlock1.getStatements();
        if (statements.length != 1) {
            return;
        }
        PsiTryStatement tryStatement2 = (PsiTryStatement)statements[0];
        PsiResourceList list2 = tryStatement2.getResourceList();
        if (list2 != null) {
            resourceCount = MergeNestedTryStatementsIntention.appendResources(newTryStatement, resourceCount, list2);
        }
        if (resourceCount > 0) {
            newTryStatement.append(')');
        }
        if ((tryBlock2 = tryStatement2.getTryBlock()) == null) {
            return;
        }
        newTryStatement.append(tryBlock2.getText());
        for (PsiCatchSection section : catchSections2 = tryStatement2.getCatchSections()) {
            newTryStatement.append(section.getText());
        }
        for (PsiCatchSection section : catchSections1 = tryStatement1.getCatchSections()) {
            newTryStatement.append(section.getText());
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiStatement newStatement = factory.createStatementFromText(newTryStatement.toString(), element);
        tryStatement1.replace((PsiElement)newStatement);
    }

    private static int appendResources(StringBuilder newTryStatement, int count, PsiResourceList list) {
        for (PsiResourceListElement resource : list) {
            if (count == 0) {
                newTryStatement.append('(');
            }
            if (count > 0) {
                newTryStatement.append(';');
            }
            newTryStatement.append(resource.getText());
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/exceptions/MergeNestedTryStatementsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/exceptions/MergeNestedTryStatementsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

