/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.expression.ExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipExpressionIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        PsiExpression[] operands2;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element.getParent();
        PsiJavaToken sign = expression2.getTokenBeforeOperand((operands2 = expression2.getOperands())[1]);
        String operatorText = sign == null ? "" : sign.getText();
        IElementType tokenType = expression2.getOperationTokenType();
        boolean commutative = ParenthesesUtils.isCommutativeOperator(tokenType);
        if (commutative && !ExpressionUtils.isConcatenation((PsiElement)expression2)) {
            return IntentionPowerPackBundle.message("flip.smth.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("flip.smth.intention.name1", operatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpressionPredicate expressionPredicate = new ExpressionPredicate();
        if (expressionPredicate == null) {
            FlipExpressionIntention.$$$reportNull$$$0(0);
        }
        return expressionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token;
        PsiElement parent;
        if (element == null) {
            FlipExpressionIntention.$$$reportNull$$$0(1);
        }
        if (!((parent = (token = (PsiJavaToken)element).getParent()) instanceof PsiPolyadicExpression)) {
            return;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        StringBuilder newExpression = new StringBuilder();
        CommentTracker commentTracker = new CommentTracker();
        String prevOperand = null;
        String tokenText = token.getText() + ' ';
        for (PsiExpression operand2 : operands2) {
            PsiJavaToken token1 = polyadicExpression.getTokenBeforeOperand(operand2);
            if (token == token1) {
                newExpression.append(commentTracker.markUnchanged(operand2).getText()).append(tokenText);
                continue;
            }
            if (prevOperand != null) {
                newExpression.append(prevOperand).append(tokenText);
            }
            prevOperand = commentTracker.markUnchanged(operand2).getText();
        }
        newExpression.append(prevOperand);
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), commentTracker);
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            FlipExpressionIntention.$$$reportNull$$$0(2);
        }
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        super.processIntention(editor, element);
        caretModel.moveToOffset(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/expression/FlipExpressionIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/expression/FlipExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

