/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

class VarargArgumentsPredicate
implements PsiElementPredicate {
    VarargArgumentsPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        String text2;
        PsiCapturedWildcardType capturedWildcardType;
        PsiType lastParameterType;
        if (element == null) {
            VarargArgumentsPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiExpressionList)) {
            return false;
        }
        PsiExpressionList argumentList = (PsiExpressionList)element;
        PsiElement parent = argumentList.getParent();
        if (!(parent instanceof PsiCall)) {
            return false;
        }
        PsiCall call = (PsiCall)parent;
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        if (!resolveResult.isValidResult()) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null || !method.isVarArgs()) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length < parameters2.length) {
            return false;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType substitutedType = substitutor.substitute(lastParameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)(parameters2.length - 1), (boolean)true));
        if (substitutedType instanceof PsiCapturedWildcardType && !(capturedWildcardType = (PsiCapturedWildcardType)substitutedType).getWildcard().isSuper()) {
            return false;
        }
        if (!JavaGenericsUtil.isReifiableType((PsiType)substitutedType)) {
            return false;
        }
        if (arguments.length != parameters2.length) {
            return true;
        }
        PsiExpression lastExpression = arguments[arguments.length - 1];
        PsiExpression expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)lastExpression);
        if (expression2 instanceof PsiLiteralExpression && "null".equals(text2 = expression2.getText())) {
            return false;
        }
        PsiType lastArgumentType = lastExpression.getType();
        if (!(lastArgumentType instanceof PsiArrayType)) {
            return true;
        }
        PsiArrayType arrayType = (PsiArrayType)lastArgumentType;
        PsiType type2 = arrayType.getComponentType();
        return !substitutedType.equals(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/varargs/VarargArgumentsPredicate", "satisfiedBy"));
    }
}

