/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ExtractWhileLoopConditionToIfStatementIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        WhileLoopPredicate whileLoopPredicate = new WhileLoopPredicate();
        if (whileLoopPredicate == null) {
            ExtractWhileLoopConditionToIfStatementIntention.$$$reportNull$$$0(0);
        }
        return whileLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiElement newElement;
        PsiWhileStatement whileStatement;
        if (element == null) {
            ExtractWhileLoopConditionToIfStatementIntention.$$$reportNull$$$0(1);
        }
        if ((whileStatement = (PsiWhileStatement)element.getParent()) == null) {
            return;
        }
        PsiExpression condition2 = whileStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        Project project = whileStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        condition2.replace((PsiElement)factory.createExpressionFromText("true", (PsiElement)whileStatement));
        PsiStatement body2 = whileStatement.getBody();
        PsiStatement ifStatement = factory.createStatementFromText("if (" + conditionText + ") break;", (PsiElement)whileStatement);
        if (body2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            newElement = codeBlock.addBefore((PsiElement)ifStatement, codeBlock.getFirstBodyElement());
        } else if (body2 != null) {
            PsiStatement newStatement = BlockUtils.expandSingleStatementToBlockStatement(body2);
            newElement = newStatement.getParent().addBefore((PsiElement)ifStatement, (PsiElement)newStatement);
        } else {
            return;
        }
        CodeStyleManager.getInstance((Project)project).reformat(newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/whileloop/ExtractWhileLoopConditionToIfStatementIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/whileloop/ExtractWhileLoopConditionToIfStatementIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

