/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.resolve;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.AbstractTreeModel;
import icons.OsmorcIdeaIcons;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osmorc.i18n.OsmorcBundle;

class ResolutionSucceedDialog
extends DialogWrapper {
    private final Map<Resource, List<Wire>> myResolveResult;
    private Tree myTree;

    public ResolutionSucceedDialog(Project project, Map<Resource, List<Wire>> resolveResult) {
        super(project);
        this.myResolveResult = resolveResult;
        this.init();
        this.setTitle(OsmorcBundle.message("bnd.resolve.succeed.title", new Object[0]));
    }

    protected String getDimensionServiceKey() {
        return "bnd.resolution.succeeded";
    }

    protected JComponent createCenterPanel() {
        this.myTree = new Tree();
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)((Object)new MyTreeModel(this.myResolveResult)));
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        return new JBScrollPane((Component)this.myTree, 20, 30);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof Resource) {
                MyTreeCellRenderer.renderResource((Resource)userObject, (SimpleColoredComponent)this);
                this.setIcon(AllIcons.Nodes.PpLib);
            } else if (userObject instanceof Wire) {
                this.append("REQUIRED BY: ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                MyTreeCellRenderer.renderResource(((Wire)userObject).getRequirer(), (SimpleColoredComponent)this);
                Capability capability = ((Wire)userObject).getCapability();
                if (capability != null) {
                    String namespace = capability.getNamespace();
                    this.append(" VIA: ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                    this.append(namespace, SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                    Map attributes = capability.getAttributes();
                    this.append("=", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                    this.append(String.valueOf(attributes.get(namespace)), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                    MyTreeCellRenderer.renderVersion(attributes, (SimpleColoredComponent)this);
                    switch (namespace) {
                        case "osgi.wiring.package": {
                            this.setIcon(AllIcons.Nodes.Package);
                            break;
                        }
                        case "osgi.identity": {
                            this.setIcon(AllIcons.Nodes.PpLib);
                            break;
                        }
                        case "osgi.contract": 
                        case "osgi.implementation": 
                        case "osgi.extender": 
                        case "osgi.service": {
                            this.setIcon(OsmorcIdeaIcons.Osgi);
                        }
                    }
                }
            } else {
                this.append(String.valueOf(userObject), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                this.setIcon(null);
            }
        }

        private static void renderResource(Resource resource, SimpleColoredComponent renderer) {
            List capabilities = resource.getCapabilities("osgi.identity");
            if (capabilities.size() == 1) {
                Map attributes = ((Capability)capabilities.get(0)).getAttributes();
                Object identity = attributes.get("osgi.identity");
                renderer.append(String.valueOf(identity), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                MyTreeCellRenderer.renderVersion(attributes, renderer);
            } else {
                renderer.append(resource.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            }
        }

        private static void renderVersion(Map<String, Object> attributes, SimpleColoredComponent renderer) {
            Object version = attributes.get("version");
            if (version != null) {
                renderer.append(", version ", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
                renderer.append(version.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/osgi/bnd/resolve/ResolutionSucceedDialog$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class MyTreeModel
    extends AbstractTreeModel {
        private final Map<Resource, List<Wire>> myResolveResult;
        private final List<Resource> myResolveRoots;
        private DefaultMutableTreeNode myRoot;

        public MyTreeModel(Map<Resource, List<Wire>> resolveResult) {
            this.myResolveResult = resolveResult;
            this.myResolveRoots = resolveResult.keySet().stream().sorted().collect(Collectors.toList());
            this.myRoot = new DefaultMutableTreeNode(null);
        }

        public Object getRoot() {
            return this.myRoot;
        }

        public int getChildCount(Object parent) {
            return this.children(parent).size();
        }

        public Object getChild(Object parent, int index) {
            return new DefaultMutableTreeNode(this.children(parent).get(index));
        }

        public boolean isLeaf(Object node) {
            return this.children(node).isEmpty();
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            Object object;
            if (child instanceof DefaultMutableTreeNode && ((object = ((DefaultMutableTreeNode)child).getUserObject()) instanceof Resource || object instanceof Wire)) {
                return this.children(parent).indexOf(object);
            }
            return -1;
        }

        private List<?> children(Object node) {
            List<Resource> result = null;
            if (node instanceof DefaultMutableTreeNode) {
                Object object = ((DefaultMutableTreeNode)node).getUserObject();
                if (object == null) {
                    result = this.myResolveRoots;
                } else if (object instanceof Resource) {
                    result = this.myResolveResult.get(object);
                } else if (object instanceof Wire) {
                    result = this.myResolveResult.get(((Wire)object).getRequirer());
                }
            }
            return (List)ObjectUtils.notNull(result, Collections.emptyList());
        }
    }
}

