/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.resolve;

import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.clauses.HeaderClause;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.properties.Document;
import aQute.bnd.properties.IDocument;
import biz.aQute.resolve.ProjectResolver;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.resolve.ResolutionFailedDialog;
import org.jetbrains.osgi.bnd.resolve.ResolutionSucceedDialog;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osmorc.i18n.OsmorcBundle;

public class ResolveAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ResolveAction.$$$reportNull$$$0(0);
        }
        final VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        final com.intellij.openapi.project.Project project = event.getProject();
        if (virtualFile == null || project == null) {
            return;
        }
        final com.intellij.openapi.editor.Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        new Task.Backgroundable(project, OsmorcBundle.message("bnd.resolve.requirements.title", new Object[0]), true){
            private Map<Resource, List<Wire>> resolveResult;
            private String updatedText;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                File file = new File(virtualFile.getPath());
                try (Workspace workspace = Workspace.findWorkspace((File)file);
                     Run run = Run.createRun((Workspace)workspace, (File)file);
                     ProjectResolver projectResolver = new ProjectResolver((Project)run);){
                    this.resolveResult = projectResolver.resolve();
                    List versionedClauses = this.resolveResult.keySet().stream().map(resource -> ResourceUtils.toVersionClause((Resource)resource, (String)"[===,==+)")).sorted(Comparator.comparing(HeaderClause::getName)).collect(Collectors.toList());
                    BndEditModel editModel = new BndEditModel();
                    Document bndDocument = new Document(document.getImmutableCharSequence().toString());
                    editModel.loadFrom((IDocument)bndDocument);
                    editModel.setRunBundles(versionedClauses);
                    editModel.saveChangesTo((IDocument)bndDocument);
                    this.updatedText = bndDocument.get();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappingException(e);
                }
                indicator.checkCanceled();
            }

            public void onSuccess() {
                if (new ResolutionSucceedDialog(project, this.resolveResult).showAndGet() && FileModificationService.getInstance().prepareVirtualFilesForWrite(project, Collections.singleton(virtualFile))) {
                    WriteCommandAction.writeCommandAction((com.intellij.openapi.project.Project)project).withName("Bndrun Resolve").run(() -> document.setText((CharSequence)this.updatedText));
                }
            }

            public void onThrowable(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(1);
                }
                Throwable cause = t instanceof WrappingException ? t.getCause() : t;
                Logger.getInstance(ResolveAction.class).warn("resolution failed", cause);
                if (cause instanceof ResolutionException) {
                    new ResolutionFailedDialog(project, (ResolutionException)cause).show();
                } else {
                    OsmorcBundle.notification(OsmorcBundle.message("bnd.resolve.failed.title", new Object[0]), cause.getMessage(), NotificationType.ERROR).notify(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "t";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/osgi/bnd/resolve/ResolveAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ResolveAction.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        event.getPresentation().setEnabledAndVisible(virtualFile != null && "bndrun".equals(virtualFile.getExtension()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "org/jetbrains/osgi/bnd/resolve/ResolveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WrappingException
    extends RuntimeException {
        private WrappingException(Throwable cause) {
            super(cause);
        }
    }
}

