/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import aQute.bnd.build.ProjectLauncher;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.run.BndLaunchUtil;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationType;
import org.osmorc.i18n.OsmorcBundle;

public class BndLaunchState
extends JavaCommandLineState
implements CompilationStatusListener,
HotSwapVetoableListener {
    private static final Logger LOG = Logger.getInstance(BndLaunchState.class);
    private static final Pair<Long, Long> MISSING_BUNDLE = Pair.pair((Object)0L, (Object)0L);
    private static final Map<String, NotificationGroup> ourNotificationGroups = ContainerUtil.newHashMap();
    private final BndRunConfigurationBase.Launch myConfiguration;
    private final Project myProject;
    private final NotificationGroup myNotifications;
    private final ProjectLauncher myLauncher;
    private final Map<String, Pair<Long, Long>> myBundleStamps;

    public BndLaunchState(@NotNull ExecutionEnvironment environment, @NotNull BndRunConfigurationBase.Launch configuration) throws ExecutionException {
        File runFile;
        if (environment == null) {
            BndLaunchState.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            BndLaunchState.$$$reportNull$$$0(1);
        }
        super(environment);
        this.myConfiguration = configuration;
        this.myProject = this.myConfiguration.getProject();
        String toolWindowId = environment.getExecutor().getToolWindowId();
        NotificationGroup notificationGroup = ourNotificationGroups.get(toolWindowId);
        if (notificationGroup == null) {
            String name = BndRunConfigurationType.getInstance().getDisplayName() + " (" + toolWindowId + ")";
            notificationGroup = NotificationGroup.toolWindowGroup((String)name, (String)toolWindowId);
            ourNotificationGroups.put(toolWindowId, notificationGroup);
        }
        this.myNotifications = notificationGroup;
        String bndRunFile = this.myConfiguration.getOptions().getBndRunFile();
        File file = runFile = bndRunFile == null ? null : new File(bndRunFile);
        if (runFile == null || !runFile.isFile()) {
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.invalid", bndRunFile));
        }
        try {
            String title = OsmorcBundle.message("bnd.run.configuration.progress", new Object[0]);
            this.myLauncher = (ProjectLauncher)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<ProjectLauncher, Exception>(this.myProject, title, false){

                protected ProjectLauncher compute(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    ProjectLauncher launcher = BndLaunchUtil.getRun(runFile).getProjectLauncher();
                    launcher.prepare();
                    return launcher;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/run/BndLaunchState$1", "compute"));
                }
            });
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.cannot.run", runFile, BndLaunchUtil.message(t)));
        }
        this.myBundleStamps = ContainerUtil.newHashMap();
        this.bundlesChanged();
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        return BndLaunchUtil.createJavaParameters(this.myConfiguration, this.myLauncher);
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler handler = super.startProcess();
        final MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)this);
        final HotSwapUI hotSwapManager = HotSwapUI.getInstance((Project)this.myProject);
        hotSwapManager.addListener((HotSwapVetoableListener)this);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                connection.disconnect();
                hotSwapManager.removeListener((HotSwapVetoableListener)BndLaunchState.this);
                BndLaunchState.this.myLauncher.cleanup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/osgi/bnd/run/BndLaunchState$2", "processTerminated"));
            }
        });
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            BndLaunchState.$$$reportNull$$$0(2);
        }
        return oSProcessHandler;
    }

    public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext context) {
        if (!aborted && errors == 0 && this.bundlesChanged()) {
            try {
                this.myLauncher.update();
                this.myNotifications.createNotification(OsmorcBundle.message("bnd.run.reloaded.text", new Object[0]), NotificationType.INFORMATION).notify(this.myProject);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private boolean bundlesChanged() {
        boolean changed = false;
        for (String bundle : this.myLauncher.getRunBundles()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((String)bundle);
            Pair current = attributes != null ? Pair.pair((Object)attributes.lastModified, (Object)attributes.length) : MISSING_BUNDLE;
            if (current.equals(this.myBundleStamps.get(bundle))) continue;
            this.myBundleStamps.put(bundle, (Pair<Long, Long>)current);
            changed = true;
        }
        return changed;
    }

    public void fileGenerated(String outputRoot, String relativePath) {
    }

    public boolean shouldHotSwap(CompileContext context) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/bnd/run/BndLaunchState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/bnd/run/BndLaunchState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

