/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.service.EclipseJUnitTester;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.run.BndLaunchUtil;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;
import org.osmorc.i18n.OsmorcBundle;

public class BndTestState
extends JavaCommandLineState {
    private static final String TEST_FRAMEWORK_NAME = "Bnd-OSGi-JUnit";
    private static final Logger LOG = Logger.getInstance(BndTestState.class);
    private final BndRunConfigurationBase.Test myConfiguration;
    private final ProjectTester myTester;
    private final ServerSocket mySocket;

    public BndTestState(@NotNull ExecutionEnvironment environment, @NotNull BndRunConfigurationBase.Test configuration) throws ExecutionException {
        File runFile;
        if (environment == null) {
            BndTestState.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            BndTestState.$$$reportNull$$$0(1);
        }
        super(environment);
        this.myConfiguration = configuration;
        String bndRunFile = this.myConfiguration.getOptions().getBndRunFile();
        File file = runFile = bndRunFile == null ? null : new File(bndRunFile);
        if (runFile == null || !runFile.isFile()) {
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.invalid", bndRunFile));
        }
        try {
            String title = OsmorcBundle.message("bnd.run.configuration.progress", new Object[0]);
            this.myTester = (ProjectTester)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<ProjectTester, Exception>(this.myConfiguration.getProject(), title, false){

                protected ProjectTester compute(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    return BndLaunchUtil.getRun(runFile).getProjectTester();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/run/BndTestState$1", "compute"));
                }
            });
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.cannot.run", runFile, BndLaunchUtil.message(t)));
        }
        if (!(this.myTester instanceof EclipseJUnitTester)) {
            throw new CantRunException(OsmorcBundle.message("bnd.test.runner.unsupported", this.myTester.getClass().getName()));
        }
        try {
            this.mySocket = new ServerSocket(0);
            ((EclipseJUnitTester)this.myTester).setPort(this.mySocket.getLocalPort());
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new CantRunException(OsmorcBundle.message("bnd.test.cannot.run", e.getMessage()));
        }
        try {
            this.myTester.prepare();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.cannot.run", runFile, e.getMessage()));
        }
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        ProjectLauncher launcher = this.myTester.getProjectLauncher();
        return BndLaunchUtil.createJavaParameters(this.myConfiguration, launcher);
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) {
        if (executor == null) {
            BndTestState.$$$reportNull$$$0(2);
        }
        MyTestConsoleProperties consoleProperties = new MyTestConsoleProperties(this, executor);
        return SMTestRunnerConnectionUtil.createConsole((String)TEST_FRAMEWORK_NAME, (TestConsoleProperties)consoleProperties);
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler processHandler = super.startProcess();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                BndTestState.this.cleanup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/osgi/bnd/run/BndTestState$2", "processTerminated"));
            }
        });
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            BndTestState.$$$reportNull$$$0(3);
        }
        return oSProcessHandler;
    }

    private void cleanup() {
        try {
            this.mySocket.close();
            FileUtil.delete((File)this.myTester.getReportDir());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/bnd/run/BndTestState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/bnd/run/BndTestState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessOutputConsumer
    extends OutputToGeneralTestEventsConverter {
        private final ServerSocket mySocket;
        private GeneralTestEventsProcessor myProcessor;
        private final Object myTestLock;
        private String myCurrentTest;
        private static final int EVENT_TYPE_LEN = 8;
        private int myTestCount;
        private String myCurrentSuite;
        private long myTestStarted;
        private String myReason;
        private String myFailingTest;
        private List<String> myTrace;

        public MyProcessOutputConsumer(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ServerSocket socket) {
            if (testFrameworkName == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(0);
            }
            if (consoleProperties == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(1);
            }
            if (socket == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(2);
            }
            super(testFrameworkName, consoleProperties);
            this.myTestLock = new Object();
            this.myCurrentTest = null;
            this.myTestCount = 0;
            this.myCurrentSuite = null;
            this.myTestStarted = 0L;
            this.myReason = null;
            this.myFailingTest = null;
            this.myTrace = null;
            this.mySocket = socket;
        }

        public void setProcessor(GeneralTestEventsProcessor processor) {
            this.myProcessor = processor;
            this.startProtocolListener();
        }

        private void startProtocolListener() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try (Socket socket = this.mySocket.accept();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                    reader.lines().forEach(this::processEventLine);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String text, Key outputType) {
            GeneralTestEventsProcessor processor = this.myProcessor;
            Object object = this.myTestLock;
            synchronized (object) {
                if (this.myCurrentTest != null) {
                    processor.onTestOutput(new TestOutputEvent(this.myCurrentTest, text, outputType == ProcessOutputTypes.STDOUT));
                } else {
                    processor.onUncapturedOutput(text, outputType);
                }
            }
        }

        public void dispose() {
            this.myProcessor = null;
        }

        private void processEventLine(@NotNull String line) {
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(3);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> " + line);
            }
            if (this.myTrace != null) {
                if ("%TRACEE ".equals(line)) {
                    this.processTrace();
                } else {
                    this.myTrace.add(line);
                }
                return;
            }
            if (line.length() >= 8 && line.charAt(0) == '%') {
                if (line.startsWith("%TESTC  ")) {
                    MyProcessOutputConsumer.processInit(line);
                } else if (line.startsWith("%TSTTREE")) {
                    this.processTreeLine(line);
                } else if (line.startsWith("%TESTS  ")) {
                    this.processTestStart(line);
                } else if (line.startsWith("%FAILED ")) {
                    this.myReason = "%FAILED ";
                    this.myFailingTest = line;
                } else if (line.startsWith("%ERROR  ")) {
                    this.myReason = "%ERROR  ";
                    this.myFailingTest = line;
                } else if ("%TRACES ".equals(line)) {
                    this.myTrace = ContainerUtil.newArrayListWithCapacity((int)20);
                } else if (line.startsWith("%TESTE  ")) {
                    this.processTestEnd(line);
                } else if (line.startsWith("%RUNTIME")) {
                    this.processDone();
                }
            }
        }

        private static void processInit(@NotNull String line) {
            int p;
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(4);
            }
            if ((p = line.indexOf(32, 8)) < 0 || !" v2".equals(line.substring(p))) {
                LOG.warn("unsupported protocol: " + line);
            }
        }

        private void processTreeLine(@NotNull String line) {
            Pair<String, String> names;
            List parts;
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(5);
            }
            if ((parts = StringUtil.split((String)line, (String)",")).size() == 4 && "false".equals(parts.get(2)) && (names = MyProcessOutputConsumer.parseTestName((String)parts.get(1), true)) != null) {
                ++this.myTestCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTestStart(@NotNull String line) {
            String suite;
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(6);
            }
            this.myTestStarted = System.currentTimeMillis();
            Pair<String, String> names = MyProcessOutputConsumer.parseTestName(line, false);
            String testName = MyProcessOutputConsumer.fullTestName(names, line);
            if (this.myTestCount > 0) {
                this.myProcessor.onTestsCountInSuite(this.myTestCount);
                this.myTestCount = -1;
            }
            if (names != null && !(suite = (String)names.first).equals(this.myCurrentSuite)) {
                if (this.myCurrentSuite != null) {
                    this.myProcessor.onSuiteFinished(new TestSuiteFinishedEvent(this.myCurrentSuite));
                }
                this.myProcessor.onSuiteStarted(new TestSuiteStartedEvent(suite, "java:suite://" + suite));
                this.myCurrentSuite = suite;
            }
            GeneralTestEventsProcessor processor = this.myProcessor;
            Object object = this.myTestLock;
            synchronized (object) {
                this.myCurrentTest = testName;
                processor.onTestStarted(new TestStartedEvent(testName, "java:test://" + testName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTestEnd(@NotNull String line) {
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(7);
            }
            long t = System.currentTimeMillis() - this.myTestStarted;
            String testName = MyProcessOutputConsumer.fullTestName(MyProcessOutputConsumer.parseTestName(line, false), line);
            GeneralTestEventsProcessor processor = this.myProcessor;
            Object object = this.myTestLock;
            synchronized (object) {
                processor.onTestFinished(new TestFinishedEvent(testName, Long.valueOf(t)));
                this.myCurrentTest = null;
            }
        }

        private void processTrace() {
            if (this.myTrace != null) {
                StringBuilder header = new StringBuilder();
                StringBuilder stack = new StringBuilder();
                boolean inStack = false;
                for (String line : this.myTrace) {
                    if (!inStack && line.startsWith("\tat ")) {
                        inStack = true;
                    }
                    (inStack ? stack : header).append(line).append('\n');
                }
                Pair<String, String> pair = null;
                String message = header.toString();
                if ((message.startsWith("org.junit.") || message.startsWith("junit.framework.")) && (pair = MyProcessOutputConsumer.matchComparison(message)) != null) {
                    this.myReason = "%FAILED ";
                }
                if (this.myFailingTest != null) {
                    String testName = MyProcessOutputConsumer.fullTestName(MyProcessOutputConsumer.parseTestName(this.myFailingTest, false), this.myFailingTest);
                    boolean testError = this.myReason != "%FAILED ";
                    String expected = pair != null ? (String)pair.first : null;
                    String actual = pair != null ? (String)pair.second : null;
                    this.myProcessor.onTestFailure(new TestFailedEvent(testName, message, stack.toString(), testError, actual, expected));
                } else {
                    this.myProcessor.onError(message, stack.toString(), false);
                }
            }
            this.myTrace = null;
            this.myReason = null;
        }

        private void processDone() {
            if (this.myCurrentSuite != null) {
                this.myProcessor.onSuiteFinished(new TestSuiteFinishedEvent(this.myCurrentSuite));
                this.myCurrentSuite = null;
            }
        }

        @Nullable
        private static Pair<String, String> parseTestName(@NotNull String line, boolean fromStart) {
            int paren;
            int comma;
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(8);
            }
            int n = comma = fromStart ? 0 : line.indexOf(44, 8);
            if (comma >= 0 && (paren = line.indexOf(40, comma + 1)) > 0 && paren < line.length() - 1) {
                String test = line.substring(comma + 1, paren);
                String suite = line.substring(paren + 1, line.length() - 1);
                return Pair.pair((Object)suite, (Object)test);
            }
            return null;
        }

        @NotNull
        private static String fullTestName(@Nullable Pair<String, String> names, @NotNull String line) {
            if (line == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(9);
            }
            String string = names != null ? (String)names.first + '.' + (String)names.second : line.substring(8);
            if (string == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Nullable
        private static Pair<String, String> matchComparison(@NotNull String message) {
            if (message == null) {
                MyProcessOutputConsumer.$$$reportNull$$$0(11);
            }
            for (Pattern pattern : Comparisons.PATTERNS) {
                Matcher matcher = pattern.matcher(message);
                if (!matcher.find()) continue;
                return Pair.pair((Object)matcher.group(1).replaceAll("\\\\n", "\n"), (Object)matcher.group(2).replaceAll("\\\\n", "\n"));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFrameworkName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleProperties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "socket";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fullTestName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processEventLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processInit";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processTreeLine";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processTestStart";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processTestEnd";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTestName";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "fullTestName";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "matchComparison";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class Comparisons {
            private static final List<Pattern> PATTERNS = ContainerUtil.newArrayList((Object[])new Pattern[]{Comparisons.compile("\nExpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n"), Comparisons.compile("\nExpected: is \"(.*)\"\n\\s*but: was \"(.*)\""), Comparisons.compile("\nExpected: (.*)\n\\s*got: (.*)"), Comparisons.compile(".*?\\s*expected same:<(.*)> was not:<(.*)>"), Comparisons.compile(".*?\\s*expected:<(.*?)> but was:<(.*?)>"), Comparisons.compile("\nExpected: \"(.*)\"\n\\s*but: was \"(.*)\""), Comparisons.compile("\\s*Expected: (.*)\\s*but: was (.*)")});

            private Comparisons() {
            }

            private static Pattern compile(String regex) {
                return Pattern.compile(regex, 34);
            }
        }

        private static final class Proto {
            private static final String INIT = "%TESTC  ";
            private static final String TREE = "%TSTTREE";
            private static final String TEST = "%TESTS  ";
            private static final String ERROR = "%ERROR  ";
            private static final String FAILED = "%FAILED ";
            private static final String TRACE = "%TRACES ";
            private static final String TRACE_END = "%TRACEE ";
            private static final String TEST_END = "%TESTE  ";
            private static final String DONE = "%RUNTIME";

            private Proto() {
            }
        }
    }

    private static class MyTestConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final ServerSocket mySocket;

        public MyTestConsoleProperties(@NotNull BndTestState runProfile, @NotNull Executor executor) {
            if (runProfile == null) {
                MyTestConsoleProperties.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                MyTestConsoleProperties.$$$reportNull$$$0(1);
            }
            super((RunConfiguration)runProfile.myConfiguration, BndTestState.TEST_FRAMEWORK_NAME, executor);
            this.mySocket = runProfile.mySocket;
            this.setPrintTestingStartedTime(false);
        }

        @NotNull
        public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                MyTestConsoleProperties.$$$reportNull$$$0(2);
            }
            if (consoleProperties == null) {
                MyTestConsoleProperties.$$$reportNull$$$0(3);
            }
            MyProcessOutputConsumer myProcessOutputConsumer = new MyProcessOutputConsumer(testFrameworkName, consoleProperties, this.mySocket);
            if (myProcessOutputConsumer == null) {
                MyTestConsoleProperties.$$$reportNull$$$0(4);
            }
            return myProcessOutputConsumer;
        }

        public SMTestLocator getTestLocator() {
            return JavaTestLocator.INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runProfile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFrameworkName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleProperties";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTestEventsConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createTestEventsConverter";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

