/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class HeaderParametersProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> ATTRIBUTE_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            context.setAddCompletionChar(false);
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)"=");
            context.commitDocument();
        }
    };
    private static final InsertHandler<LookupElement> DIRECTIVE_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            context.setAddCompletionChar(false);
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)":=");
            context.commitDocument();
        }
    };
    private final String[] myNames;

    public HeaderParametersProvider(String ... names) {
        this.myNames = names;
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            HeaderParametersProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            HeaderParametersProvider.$$$reportNull$$$0(1);
        }
        for (String name : this.myNames) {
            boolean directive = StringUtil.endsWithChar((CharSequence)name, (char)':');
            if (directive) {
                name = name.substring(0, name.length() - 1);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)name).withCaseSensitivity(false).withInsertHandler(directive ? DIRECTIVE_HANDLER : ATTRIBUTE_HANDLER));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/osmorc/manifest/completion/HeaderParametersProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

