/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.frameworkintegration.FrameworkRunner;
import org.osmorc.make.BundleCompiler;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;

public class OsgiRunState
extends JavaCommandLineState {
    private static final Logger LOG = Logger.getInstance(OsgiRunState.class);
    private final OsgiRunConfiguration myRunConfiguration;
    private final FrameworkRunner myRunner;
    public static final Comparator<SelectedBundle> START_LEVEL_COMPARATOR = (b1, b2) -> b1.getStartLevel() - b2.getStartLevel();

    public OsgiRunState(@NotNull ExecutionEnvironment environment, @NotNull OsgiRunConfiguration configuration) throws ExecutionException {
        if (environment == null) {
            OsgiRunState.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            OsgiRunState.$$$reportNull$$$0(1);
        }
        super(environment);
        this.myRunConfiguration = configuration;
        FrameworkInstanceDefinition instance = this.myRunConfiguration.getInstanceToUse();
        if (instance == null) {
            throw new CantRunException("Incorrect OSGi run configuration: framework not set");
        }
        FrameworkIntegrator integrator = FrameworkIntegratorRegistry.getInstance().findIntegratorByInstanceDefinition(instance);
        if (integrator == null) {
            throw new CantRunException("Internal error: missing integrator for " + (Object)((Object)instance));
        }
        this.myRunner = integrator.createFrameworkRunner();
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        return this.myRunner.createJavaParameters(this.myRunConfiguration, this.getSelectedBundles());
    }

    private List<SelectedBundle> getSelectedBundles() throws ExecutionException {
        final Ref result = Ref.create();
        final Ref error = Ref.create();
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRunConfiguration.getProject(), "Preparing bundles...", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                progressIndicator.setIndeterminate(false);
                AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                try {
                    HashSet<Object> selectedBundles = new HashSet<Object>();
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)OsgiRunState.this.myRunConfiguration.getProject());
                    BundleCompiler bundleCompiler = new BundleCompiler(progressIndicator);
                    int bundleCount = OsgiRunState.this.myRunConfiguration.getBundlesToDeploy().size();
                    for (int i = 0; i < bundleCount; ++i) {
                        progressIndicator.setFraction((double)i / (double)bundleCount);
                        SelectedBundle selectedBundle = OsgiRunState.this.myRunConfiguration.getBundlesToDeploy().get(i);
                        if (selectedBundle.isModule()) {
                            String string = selectedBundle.getName();
                            Module module = moduleManager.findModuleByName(string);
                            if (module == null) {
                                throw new CantRunException("Module '" + string + "' no longer exists. Please check your run configuration.");
                            }
                            OsmorcFacet facet = OsmorcFacet.getInstance(module);
                            if (facet == null) {
                                throw new CantRunException("Module '" + string + "' has no OSGi facet. Please check your run configuration.");
                            }
                            selectedBundle.setBundlePath(((OsmorcFacetConfiguration)facet.getConfiguration()).getJarFileLocation());
                            selectedBundles.add(selectedBundle);
                            List<String> paths = bundleCompiler.bundlifyLibraries(module);
                            for (String path : paths) {
                                selectedBundles.add(new SelectedBundle(SelectedBundle.BundleType.PlainLibrary, "Dependency", path));
                            }
                            continue;
                        }
                        if (selectedBundles.contains(selectedBundle)) {
                            selectedBundles.remove(selectedBundle);
                        }
                        selectedBundles.add(selectedBundle);
                    }
                    HashMap<String, SelectedBundle> filteredBundles = new HashMap<String, SelectedBundle>();
                    for (SelectedBundle selectedBundle : selectedBundles) {
                        String path = selectedBundle.getBundlePath();
                        if (path == null) continue;
                        String name = CachingBundleInfoProvider.getBundleSymbolicName((String)path);
                        String version = CachingBundleInfoProvider.getBundleVersion((String)path);
                        String key = name + version;
                        if (filteredBundles.containsKey(key)) continue;
                        filteredBundles.put(key, selectedBundle);
                    }
                    ArrayList sortedBundles = ContainerUtil.newArrayList(filteredBundles.values());
                    Collections.sort(sortedBundles, START_LEVEL_COMPARATOR);
                    result.set((Object)sortedBundles);
                }
                catch (CantRunException e) {
                    error.set((Object)e);
                }
                catch (OsgiBuildException e) {
                    LOG.warn((Throwable)e);
                    error.set((Object)new CantRunException(e.getMessage()));
                }
                catch (Throwable t) {
                    LOG.error(t);
                    error.set((Object)new CantRunException("Internal error: " + t.getMessage()));
                }
                finally {
                    token.finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/osmorc/run/OsgiRunState$1", "run"));
            }
        });
        if (!result.isNull()) {
            return (List)result.get();
        }
        throw (ExecutionException)error.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "environment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "org/osmorc/run/OsgiRunState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

