/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.SaveDocumentAction;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.OldPublishConfigStateHolder;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PublishConfigData", storages={@Storage(value="deployment.xml")})
public class PublishConfig
implements PersistentStateComponent<State>,
Cloneable {
    public static final int DEFAULT_FILE_PERMISSIONS = 420;
    public static final int DEFAULT_FOLDER_PERMISSIONS = 493;
    public static final TraceLevel DEFAULT_TRACE_LEVEL = TraceLevel.BRIEF;
    private static final Logger LOG = Logger.getInstance(PublishConfig.class);
    public static final String EXCLUDE_DELIM = ";";
    @NonNls
    public static final String[] DEFAULT_EXCLUDES = new String[]{".svn", ".cvs", ".idea", ".DS_Store", ".git", ".hg", "*.hprof", "*.pyc"};
    public static final int PRESERVE_PERMISSIONS = -1;
    @Nullable
    private final Project myProject;
    private volatile State myState;
    private volatile State myOldFashionedState;
    private final Collection<Pattern> myExcludePatterns;

    public static PublishConfig getInstance(@NotNull Project project) {
        if (project == null) {
            PublishConfig.$$$reportNull$$$0(0);
        }
        return (PublishConfig)ServiceManager.getService((Project)project, PublishConfig.class);
    }

    public PublishConfig(@Nullable Project project, @NotNull UltimateVerifier verifier) {
        if (verifier == null) {
            PublishConfig.$$$reportNull$$$0(1);
        }
        this.myExcludePatterns = new ArrayList<Pattern>();
        PluginVerifier.verifyUltimatePlugin(verifier);
        this.myProject = project;
        this.myState = new State();
        if (project != null && !project.isDefault()) {
            OldPublishConfigStateHolder oldConfig = OldPublishConfigStateHolder.getInstance(project);
            this.myOldFashionedState = new State();
            this.myOldFashionedState.loadOldData(oldConfig, project);
            State savedState = this.myOldFashionedState;
            this.myOldFashionedState = null;
            this.doLoadState(savedState.clone(), WebServersConfigManagerImpl.collectUnpatchedServers(this.myProject));
            this.myOldFashionedState = savedState;
            oldConfig.eraseData();
        }
        this.updatePatterns();
    }

    @NotNull
    public State getState() {
        State copiedState = this.myProject != null && this.myProject.isDefault() ? this.myState.copyForDefaultProject() : this.myState.clone();
        copiedState.removeEffectivelyEmptyServerData(this.myProject);
        WebServersConfigManager manager = WebServersConfigManager.getInstance(this.myProject);
        copiedState.serializeEffectiveServerData(manager);
        copiedState.improveDefaultServerData(manager);
        copiedState.myDefaultServerId = null;
        State state = copiedState;
        if (state == null) {
            PublishConfig.$$$reportNull$$$0(2);
        }
        return state;
    }

    public void loadState(State state) {
        List<WebServerConfig> servers = WebServersConfigManager.getInstance(this.myProject).getServers(false);
        com.intellij.util.containers.hash.HashMap idToServer = new com.intellij.util.containers.hash.HashMap();
        for (WebServerConfig server : servers) {
            idToServer.put(server.getId(), server);
        }
        this.doLoadState(state, (Map<String, WebServerConfig>)idToServer);
    }

    private void doLoadState(State state, Map<String, WebServerConfig> idToServer) {
        WebServerConfig server;
        String id;
        this.myState = state;
        for (Map.Entry<String, ServerData> entry : this.myState.myIdServerData.entrySet()) {
            id = entry.getKey();
            server = idToServer.get(id);
            if (server == null || this.myState.myNameServerData.containsKey(server.getName())) continue;
            this.myState.myNameServerData.put(server.getName(), entry.getValue());
        }
        this.myState.myIdServerData.clear();
        if (this.myOldFashionedState != null) {
            for (Map.Entry<String, ServerData> entry : this.myOldFashionedState.myNameServerData.entrySet()) {
                if (this.myState.myNameServerData.containsKey(entry.getKey())) continue;
                this.myState.myNameServerData.put((String)entry.getKey(), ((ServerData)entry.getValue()).clone());
            }
            for (Map.Entry<String, ServerData> entry : this.myOldFashionedState.myIdServerData.entrySet()) {
                id = (String)entry.getKey();
                server = idToServer.get(id);
                if (server == null || this.myState.myNameServerData.containsKey(server.getName())) continue;
                this.myState.myNameServerData.put(server.getName(), ((ServerData)entry.getValue()).clone());
            }
            if (StringUtil.isEmptyOrSpaces((String)this.myState.myDefaultServerName) && StringUtil.isEmptyOrSpaces((String)this.myState.myDefaultServerId)) {
                this.myState.myDefaultServerName = this.myOldFashionedState.myDefaultServerName;
                this.myState.myDefaultServerId = this.myOldFashionedState.myDefaultServerId;
            }
            this.myOldFashionedState = null;
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myState.myDefaultServerName) && StringUtil.isEmptyOrSpaces((String)this.myState.myDefaultServerId)) {
            for (WebServerConfig server2 : idToServer.values()) {
                if (!this.myState.myDefaultServerName.equals(server2.getName())) continue;
                this.myState.myDefaultServerId = server2.getId();
                break;
            }
        }
        this.myState.loadEffectiveServerData(idToServer);
        this.myState.myIdServerData.clear();
        this.myState.myNameServerData.clear();
        this.updatePatterns();
        for (WebServerConfig server2 : idToServer.values()) {
            this.getServerData(server2.getId());
        }
        for (ServerData data : this.myState.myServerData.values()) {
            for (DeploymentPathMapping mapping : data.myPathMappings) {
                mapping.setLocalPath(mapping.getPresentableLocalPath());
            }
        }
    }

    public void notifyServersPatched(Map<WebServerConfig, WebServerConfig> oldToNew, List<WebServerConfig> servers) {
        ArrayList<String> allServerNames = new ArrayList<String>();
        ArrayList<String> allServerIds = new ArrayList<String>();
        for (WebServerConfig webServerConfig : servers) {
            allServerNames.add(webServerConfig.getName());
            allServerIds.add(webServerConfig.getId());
        }
        for (Map.Entry entry : oldToNew.entrySet()) {
            ServerData idData;
            ServerData namedData;
            String oldName = ((WebServerConfig)entry.getKey()).getName();
            String serverName = ((WebServerConfig)entry.getValue()).getName();
            String oldId = ((WebServerConfig)entry.getKey()).getId();
            String serverId = ((WebServerConfig)entry.getValue()).getId();
            if (StringUtil.equals((CharSequence)oldId, (CharSequence)this.myState.myDefaultServerId)) {
                this.myState.myDefaultServerName = serverName;
                this.myState.myDefaultServerId = serverId;
            }
            if ((namedData = this.myState.myNameServerData.get(oldName)) != null) {
                if (allServerNames.contains(oldName)) {
                    namedData = namedData.clone();
                    this.myState.myNameServerData.put(serverName, namedData);
                } else {
                    this.myState.myNameServerData.remove(oldName);
                    this.myState.myNameServerData.put(serverName, namedData);
                }
            }
            if ((idData = this.myState.myServerData.get(oldId)) == null) continue;
            if (allServerIds.contains(oldId)) {
                idData = idData.clone();
                this.myState.myServerData.put(serverId, idData);
                continue;
            }
            this.myState.myServerData.remove(oldId);
            this.myState.myServerData.put(serverId, idData);
        }
    }

    private ServerData getServerData(String serverId) {
        ServerData data = this.getAllServerData().get(serverId);
        if (data == null) {
            data = new ServerData();
            this.getAllServerData().put(serverId, data);
            PublishConfig.addDefaultMappings(this.myProject, data.myPathMappings);
        }
        return data;
    }

    private Map<String, ServerData> getAllServerData() {
        return this.myState.myServerData;
    }

    public static void addDefaultMappings(@Nullable Project project, List<DeploymentPathMapping> result) {
        if (project != null && !project.isDefault()) {
            for (VirtualFile root : PublishConfig.collectContentRoots(project)) {
                DeploymentPathMapping mapping = new DeploymentPathMapping();
                mapping.setSerializedLocalPath(root.getPresentableUrl());
                mapping.setWebPath("/");
                result.add(mapping);
            }
        }
    }

    @NotNull
    private static Collection<VirtualFile> collectContentRoots(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                PublishConfig.$$$reportNull$$$0(3);
            }
            return list;
        }
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        Module[] modules = manager.getModules();
        if (modules.length == 0) {
            Set<VirtualFile> set = Collections.singleton(baseDir);
            if (set == null) {
                PublishConfig.$$$reportNull$$$0(4);
            }
            return set;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)modules[0]).getContentRoots();
        if (contentRoots.length == 0) {
            Set<VirtualFile> set = Collections.singleton(baseDir);
            if (set == null) {
                PublishConfig.$$$reportNull$$$0(5);
            }
            return set;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Collections.addAll(result, contentRoots);
        if (!result.contains(baseDir)) {
            result.add(baseDir);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            PublishConfig.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public Map<String, List<DeploymentPathMapping>> getAllPathMappings() {
        HashMap<String, List<DeploymentPathMapping>> result = new HashMap<String, List<DeploymentPathMapping>>();
        for (Map.Entry<String, ServerData> entry : this.getAllServerData().entrySet()) {
            result.put(entry.getKey(), PublishConfig.cloneMappings(entry.getValue().myPathMappings, false));
        }
        return result;
    }

    public Map<String, List<ExcludedPath>> getAllExcludedPaths() {
        HashMap<String, List<ExcludedPath>> result = new HashMap<String, List<ExcludedPath>>();
        for (Map.Entry<String, ServerData> entry : this.getAllServerData().entrySet()) {
            result.put(entry.getKey(), PublishConfig.cloneExcludedPaths(entry.getValue().myExcludedPaths));
        }
        return result;
    }

    public List<DeploymentPathMapping> getPathMappings(String serverId) {
        return PublishConfig.cloneMappings(this.getServerData((String)serverId).myPathMappings, false);
    }

    public List<ExcludedPath> getExcludedPaths(String serverId) {
        return PublishConfig.cloneExcludedPaths(this.getServerData((String)serverId).myExcludedPaths);
    }

    public void setPathMappings(Map<String, List<DeploymentPathMapping>> mappings) {
        for (ServerData serverData : this.getAllServerData().values()) {
            serverData.myPathMappings.clear();
        }
        for (Map.Entry entry : mappings.entrySet()) {
            this.setPathMappings((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public void setPathMappings(String serverId, List<DeploymentPathMapping> mappings) {
        this.getServerData((String)serverId).myPathMappings = PublishConfig.cloneMappings(mappings, false);
    }

    public void setExcludedPaths(Map<String, List<ExcludedPath>> excludedPaths) {
        for (ServerData serverData : this.getAllServerData().values()) {
            serverData.myExcludedPaths.clear();
        }
        for (Map.Entry entry : excludedPaths.entrySet()) {
            this.setExcludedPaths((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public void setExcludedPaths(String serverId, List<ExcludedPath> excludedPaths) {
        this.getServerData((String)serverId).myExcludedPaths = PublishConfig.cloneExcludedPaths(excludedPaths);
    }

    public static List<DeploymentPathMapping> cloneMappings(List<DeploymentPathMapping> pathMappings, boolean filterEmpty) {
        ArrayList<DeploymentPathMapping> result = new ArrayList<DeploymentPathMapping>(pathMappings.size());
        for (DeploymentPathMapping pathMapping : pathMappings) {
            if (filterEmpty && pathMapping.isDegenerate()) continue;
            result.add(pathMapping.clone());
        }
        return result;
    }

    public static List<ExcludedPath> cloneExcludedPaths(@NotNull List<ExcludedPath> excludedPaths) {
        if (excludedPaths == null) {
            PublishConfig.$$$reportNull$$$0(7);
        }
        ArrayList<ExcludedPath> result = new ArrayList<ExcludedPath>(excludedPaths.size());
        for (ExcludedPath pathMapping : excludedPaths) {
            if (StringUtil.isEmpty((String)pathMapping.getPath())) continue;
            result.add(pathMapping.clone());
        }
        return result;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingForLocal(FileObject local, boolean strict, boolean checkDeployPath, boolean checkWebPath, Mappable server) {
        Pair<DeploymentPathMapping, Boolean> pair = this.getNearestMappingForLocal(DeploymentPathUtils.getLocalPath(local), strict, checkDeployPath, checkWebPath, server, false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingForLocal(String localPath, boolean strict, boolean checkDeployPath, boolean checkWebPath, Mappable server) {
        Pair<DeploymentPathMapping, Boolean> pair = this.getNearestMappingForLocal(localPath, strict, checkDeployPath, checkWebPath, server, false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingForLocal(String localPath, boolean strict, boolean checkDeployPath, boolean checkWebPath, Mappable server, boolean ignoreExcludedPaths) {
        if (localPath == null || this.isExcludedByName(localPath)) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(10);
            }
            return pair;
        }
        if (!ignoreExcludedPaths && PublishConfig.isLocalPathExcluded(localPath, server, this)) {
            Pair pair = Pair.create(null, (Object)true);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(11);
            }
            return pair;
        }
        DeploymentPathMapping result = null;
        for (DeploymentPathMapping mapping : this.getServerData((String)server.getId()).myPathMappings) {
            if (!mapping.isParentForLocalPath(localPath, strict) || checkDeployPath && !mapping.isDeployPathValid(server.getAccessType().isProtocolBased()) || checkWebPath && !mapping.isWebPathValid() || result != null && !result.isParentForLocalPath(mapping.getLocalPath(), true)) continue;
            result = mapping;
        }
        Pair pair = Pair.create(result, (Object)false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingDeploy2Local(FileObject deploy, boolean strict, Mappable mappable) {
        Pair<DeploymentPathMapping, Boolean> pair = this.getNearestMappingDeploy2Local(deploy.getName(), strict, mappable, false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingDeploy2Local(FileObject deploy, boolean strict, Mappable server, boolean ignoreExcludedPaths) {
        Pair<DeploymentPathMapping, Boolean> pair = this.getNearestMappingDeploy2Local(deploy.getName(), strict, server, ignoreExcludedPaths);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingDeploy2Local(FileName deploy, boolean strict, Mappable mappable) {
        Pair<DeploymentPathMapping, Boolean> pair = this.getNearestMappingDeploy2Local(deploy, strict, mappable, false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(15);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingDeploy2Local(FileName deploy, boolean strict, Mappable mappable, boolean ignoreExcludedPaths) {
        if (this.isExcludedByName(mappable.getPresentablePath(deploy))) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(16);
            }
            return pair;
        }
        if (!ignoreExcludedPaths && PublishConfig.isRemotePathExcluded(deploy, mappable, this)) {
            Pair pair = Pair.create(null, (Object)true);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(17);
            }
            return pair;
        }
        DeploymentPathMapping result = null;
        for (DeploymentPathMapping mapping : this.getServerData((String)mappable.getId()).myPathMappings) {
            if (!mapping.isLocalPathValid() || !mapping.isParentForDeployPath(deploy, strict, mappable) || result != null && !result.isParentByDeployPath(mapping, mappable.isCaseSensitive())) continue;
            result = mapping;
        }
        Pair pair = Pair.create(result, (Object)false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingDeploy2Local(WebServerConfig.RemotePath deploy, boolean strict, Mappable mappable) {
        Pair<DeploymentPathMapping, Boolean> pair = this.getNearestMappingDeploy2Local(deploy, strict, mappable, false, true, false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @NotNull
    public Pair<DeploymentPathMapping, Boolean> getNearestMappingDeploy2Local(WebServerConfig.RemotePath deploy, boolean strict, Mappable mappable, boolean ignoreExcluded, boolean checkLocalPath, boolean checkWebPath) {
        if (!ignoreExcluded && this.isExcludedByName(mappable.getPresentablePath(deploy))) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(20);
            }
            return pair;
        }
        if (!ignoreExcluded && PublishConfig.isRemotePathExcluded(deploy, mappable, this)) {
            Pair pair = Pair.create(null, (Object)true);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(21);
            }
            return pair;
        }
        DeploymentPathMapping result = null;
        for (DeploymentPathMapping mapping : this.getServerData((String)mappable.getId()).myPathMappings) {
            if (checkLocalPath && !mapping.isLocalPathValid() || checkWebPath && !mapping.isWebPathValid() || !mapping.isParentForDeployPath(deploy, strict, mappable) || result != null && !result.isParentByDeployPath(mapping, mappable.isCaseSensitive())) continue;
            result = mapping;
        }
        Pair pair = Pair.create(result, (Object)false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @NotNull
    public Pair<List<DeploymentPathMapping>, Boolean> getChildMappingsDeploy2Local(FileObject deploy, Mappable mappable) {
        Pair<List<DeploymentPathMapping>, Boolean> pair = this.getChildMappingsDeploy2Local(deploy.getName(), mappable);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    public Pair<List<DeploymentPathMapping>, Boolean> getChildMappingsDeploy2Local(FileName deployPath, Mappable mappable) {
        if (this.isExcludedByName(mappable.getPresentablePath(deployPath))) {
            Pair.create(Collections.emptyList(), (Object)false);
        }
        if (PublishConfig.isRemotePathExcluded(deployPath, mappable, this)) {
            Pair pair = Pair.create(Collections.emptyList(), (Object)true);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(24);
            }
            return pair;
        }
        ArrayList<DeploymentPathMapping> result = new ArrayList<DeploymentPathMapping>();
        for (DeploymentPathMapping mapping : this.getServerData((String)mappable.getId()).myPathMappings) {
            if (!mapping.isLocalPathValid() || !mapping.isChildForDeployPath(deployPath, true, mappable)) continue;
            result.add(mapping);
        }
        Pair pair = Pair.create(result, (Object)false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(25);
        }
        return pair;
    }

    @NotNull
    public Pair<List<DeploymentPathMapping>, Boolean> getChildMappingsForLocal(FileObject local, boolean checkDeployPath, boolean checkWebPath, Mappable mappable) {
        Pair<List<DeploymentPathMapping>, Boolean> pair = this.getChildMappingsForLocal(DeploymentPathUtils.getLocalPath(local), checkDeployPath, checkWebPath, mappable);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(26);
        }
        return pair;
    }

    @NotNull
    public Pair<List<DeploymentPathMapping>, Boolean> getChildMappingsForLocal(String localPath, boolean checkDeployPath, boolean checkWebPath, Mappable mappable) {
        if (this.isExcludedByName(localPath)) {
            Pair pair = Pair.create(Collections.emptyList(), (Object)false);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(27);
            }
            return pair;
        }
        if (PublishConfig.isLocalPathExcluded(localPath, mappable, this)) {
            Pair pair = Pair.create(Collections.emptyList(), (Object)true);
            if (pair == null) {
                PublishConfig.$$$reportNull$$$0(28);
            }
            return pair;
        }
        ArrayList<DeploymentPathMapping> result = new ArrayList<DeploymentPathMapping>();
        for (DeploymentPathMapping mapping : this.getServerData((String)mappable.getId()).myPathMappings) {
            if (!mapping.isChildForLocalPath(localPath, true) || checkDeployPath && !mapping.isDeployPathValid(mappable.getAccessType().isProtocolBased()) || checkWebPath && !mapping.isWebPathValid()) continue;
            result.add(mapping);
        }
        Pair pair = Pair.create(result, (Object)false);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(29);
        }
        return pair;
    }

    public static boolean isLocalPathExcluded(String localPath, Mappable mappable, PublishConfig config) {
        for (ExcludedPath excludedPath : config.getServerData((String)mappable.getId()).myExcludedPaths) {
            if (!excludedPath.isLocal() || !excludedPath.isParentForLocalPath(localPath)) continue;
            LOG.debug("Local path is really excluded: " + localPath);
            return true;
        }
        return false;
    }

    public static boolean isRemotePathExcluded(FileName remotePath, Mappable mappable, PublishConfig config) {
        for (ExcludedPath excludedPath : config.getServerData((String)mappable.getId()).myExcludedPaths) {
            if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(remotePath, false, mappable)) continue;
            LOG.debug("Remote path is really excluded: " + remotePath.getPath());
            return true;
        }
        return false;
    }

    public static boolean isRemotePathExcluded(WebServerConfig.RemotePath remotePath, Mappable mappable, PublishConfig config) {
        for (ExcludedPath excludedPath : config.getServerData((String)mappable.getId()).myExcludedPaths) {
            if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(remotePath, mappable)) continue;
            LOG.debug("Remote path is really excluded: " + remotePath.path);
            return true;
        }
        return false;
    }

    @NotNull
    public Pair<String, String> getDefaultServerIdAndName() {
        Pair pair = Pair.create((Object)this.myState.myDefaultServerId, (Object)this.myState.myDefaultServerName);
        if (pair == null) {
            PublishConfig.$$$reportNull$$$0(30);
        }
        return pair;
    }

    public void setDefaultServer(@Nullable WebServerConfig server, @Nullable String serverName) {
        this.myState.myDefaultServerName = serverName;
        this.myState.myDefaultServerId = server != null ? server.getId() : null;
    }

    public void setDefaultServerIdAndName(@Nullable String serverId, @Nullable String serverName) {
        this.myState.myDefaultServerName = serverName;
        this.myState.myDefaultServerId = serverId;
    }

    @Nullable
    public WebServerConfig findDefaultServer() {
        return StringUtil.isEmpty((String)this.myState.myDefaultServerId) ? null : WebServersConfigManager.getInstance(this.myProject).findServer(this.myState.myDefaultServerId);
    }

    @Nullable
    public String mapToWebPath(String localPath, @Nullable Mappable server) {
        if (server == null || server.validateUrl() != null) {
            return null;
        }
        Pair<DeploymentPathMapping, Boolean> mapping = this.getNearestMappingForLocal(localPath, false, false, true, server);
        if (mapping.getFirst() == null) {
            return null;
        }
        String webPath = ((DeploymentPathMapping)mapping.getFirst()).mapToWebPath(localPath);
        if (webPath == null) {
            return null;
        }
        return DeploymentPathUtils.joinWebPath(server.getUrl(), webPath);
    }

    public boolean isExcludedByName(String path) {
        String[] components = FileUtil.toSystemIndependentName((String)path).split("/");
        for (int i = components.length - 1; i >= 0; --i) {
            String component = components[i];
            for (Pattern pattern : this.myExcludePatterns) {
                try {
                    if (!new Perl5Matcher().matches(component, pattern)) continue;
                    return true;
                }
                catch (Throwable t) {
                    LOG.error("Failed to check name \"" + component + "\" against pattern \"" + pattern.getPattern() + "\"", t);
                }
            }
        }
        return false;
    }

    public boolean isStopOnFirstError() {
        return this.myState.myStopOnFirstError;
    }

    public void setStopOnFirstError(boolean stopOnFirstError) {
        this.myState.myStopOnFirstError = stopOnFirstError;
    }

    public boolean isOverwriteAll() {
        return this.myState.myOverwriteAll;
    }

    public void setOverwriteAll(boolean overwriteAll) {
        this.myState.myOverwriteAll = overwriteAll;
    }

    public boolean isPreserveTimestamps() {
        return this.myState.myPreserveTimestamps;
    }

    public void setPreserveTimestamps(boolean preserveTimestamps) {
        this.myState.myPreserveTimestamps = preserveTimestamps;
    }

    public PublishConfig clone() {
        PublishConfig clone = new PublishConfig(this.myProject, UltimateVerifier.getInstance());
        clone.loadState(this.getState().clone());
        return clone;
    }

    public boolean isDeleteMissingItems() {
        return this.myState.myDeleteMissingItems;
    }

    public void setDeleteMissingItems(boolean value) {
        this.myState.myDeleteMissingItems = value;
    }

    public boolean isCreateEmptyDirectories() {
        return this.myState.myCreateEmptyDirectories;
    }

    public void setCreateEmptyDirectories(boolean value) {
        this.myState.myCreateEmptyDirectories = value;
    }

    public boolean isPromptOnLocalOverwrite() {
        return this.myState.myPromptOnLocalOverwrite;
    }

    public void setPromptOnLocalOverwrite(boolean value) {
        this.myState.myPromptOnLocalOverwrite = value;
    }

    @Nullable
    public Pair<String, String> getUploadOnCheckin() {
        return this.myState.myUploadOnCheckinId != null ? Pair.create((Object)this.myState.myUploadOnCheckinId, (Object)this.myState.myUploadOnCheckinName) : null;
    }

    public void setUploadOnCheckin(@Nullable WebServerConfig server) {
        this.myState.myUploadOnCheckinId = server != null ? server.getId() : null;
        this.myState.myUploadOnCheckinName = server != null ? server.getName() : null;
    }

    public String getExcludeMask() {
        return this.myState.myExcludeMask;
    }

    public void setExcludeMask(String value) {
        this.myState.myExcludeMask = value;
        this.updatePatterns();
    }

    public int getFilePermissions() {
        return this.myState.myFilePermissions;
    }

    public void setFilePermissions(int value) {
        this.myState.myFilePermissions = value;
    }

    public int getFolderPermissions() {
        return this.myState.myFolderPermissions;
    }

    public void setFolderPermissions(int value) {
        this.myState.myFolderPermissions = value;
    }

    public AutoUploadState getAutoUploadState() {
        return this.myState.myAutoUpload;
    }

    public void setAutoUploadState(AutoUploadState state) {
        this.myState.myAutoUpload = state;
    }

    public boolean isAutoUploadExternalChanges() {
        return this.myState.myAutoUploadExternalChanges;
    }

    public void setAutoUploadExternalChanges(boolean value) {
        this.myState.myAutoUploadExternalChanges = value;
    }

    public TraceLevel getTraceLevel() {
        return this.myState.myTraceLevel;
    }

    public void setTraceLevel(TraceLevel value) {
        this.myState.myTraceLevel = value;
    }

    private void updatePatterns() {
        this.myExcludePatterns.clear();
        if (StringUtil.isEmpty((String)this.getExcludeMask())) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.myState.myExcludeMask.trim(), EXCLUDE_DELIM);
        while (tokenizer.hasMoreTokens()) {
            String mask = tokenizer.nextToken().trim();
            mask = PublishConfig.normalizeWildcards(mask);
            mask = PublishConfig.optimize(mask);
            try {
                this.myExcludePatterns.add(PublishConfig.compilePattern(mask));
            }
            catch (MalformedPatternException malformedPatternException) {}
        }
    }

    private static String normalizeWildcards(String wildcardPattern) {
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"\\!", (String)"!");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)".", (String)"\\.");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*?", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?*", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*", (String)".*");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?", (String)".");
        return wildcardPattern;
    }

    private static String optimize(String wildcardPattern) {
        try {
            return java.util.regex.Pattern.compile("(?:\\.\\*)+").matcher(StringUtil.newBombedCharSequence((CharSequence)wildcardPattern, (long)1000L)).replaceAll(".*");
        }
        catch (ProcessCanceledException e) {
            return wildcardPattern;
        }
    }

    private static Pattern compilePattern(@NonNls String s) throws MalformedPatternException {
        Perl5Compiler compiler = new Perl5Compiler();
        return SystemInfo.isFileSystemCaseSensitive ? compiler.compile(s) : compiler.compile(s, 1);
    }

    public void copyTo(PublishConfig config) {
        config.loadState(this.getState());
    }

    @Nullable
    public DeploymentPathMapping getNearestMappingForWeb(String webPath, boolean strict, boolean checkLocalPath, boolean checkDeployPath, Mappable server) {
        DeploymentPathMapping result = null;
        for (DeploymentPathMapping mapping : this.getServerData((String)server.getId()).myPathMappings) {
            if (!mapping.isParentForWebPath(webPath, strict) || checkLocalPath && !mapping.isLocalPathValid() || checkDeployPath && !mapping.isDeployPathValid(server.getAccessType().isProtocolBased()) || result != null && !result.isParentByWebPath(mapping)) continue;
            result = mapping;
        }
        return result;
    }

    public Collection<WebServerConfig> findSuitableServers(Collection<String> localPaths, boolean checkDeployPath, boolean checkWebPath, boolean returnAll) {
        ArrayList<WebServerConfig> result = new ArrayList<WebServerConfig>();
        WebServerConfig defaultServer = this.findDefaultServer();
        if (defaultServer != null) {
            for (String localPath : localPaths) {
                if (PublishUtils.needsTransfer(defaultServer.getAccessType()) && this.getNearestMappingForLocal(localPath, false, checkDeployPath, checkWebPath, (Mappable)defaultServer).getFirst() == null) continue;
                result.add(defaultServer);
            }
        }
        if (!result.isEmpty() && !returnAll) {
            return result;
        }
        for (WebServerConfig server : WebServersConfigManager.getInstance(this.myProject).getServers(false)) {
            if (server == defaultServer) continue;
            for (String localPath : localPaths) {
                if (this.getNearestMappingForLocal(localPath, false, checkDeployPath && server.needsTransfer(), checkWebPath, (Mappable)server).getFirst() == null) continue;
                result.add(server);
                if (returnAll) continue;
                return result;
            }
        }
        return result;
    }

    public PromptOnRemoteOverwrite getPromptOnRemoteOverwrite() {
        return this.myState.myPromptOnRemoteOverwrite;
    }

    public void setPromptOnRemoteOverwrite(PromptOnRemoteOverwrite value) {
        this.myState.myPromptOnRemoteOverwrite = value;
    }

    public boolean isPersistUploadOnCheckin() {
        return this.myState.myPersistUploadOnCheckin;
    }

    public void setPersistUploadOnCheckin(boolean value) {
        this.myState.myPersistUploadOnCheckin = value;
    }

    public boolean isNotifyRemoteChanges() {
        return this.myState.myNotifyRemoteChanges;
    }

    public void setNotifyRemoteChanges(boolean notifyRemoteChanges) {
        this.myState.myNotifyRemoteChanges = notifyRemoteChanges;
    }

    public DirDiffSettings.CompareMode getCompareModeInSync() {
        return this.myState.myCompareModeInSync;
    }

    public void setCompareModeInSync(DirDiffSettings.CompareMode compareModeInSync) {
        this.myState.myCompareModeInSync = compareModeInSync;
    }

    public boolean isShowEqualInSync() {
        return this.myState.myShowEqualInSync;
    }

    public void setShowEqualInSync(boolean show) {
        this.myState.myShowEqualInSync = show;
    }

    public boolean isShowDifferentInSync() {
        return this.myState.myShowDifferentInSync;
    }

    public void setShowDifferentInSync(boolean show) {
        this.myState.myShowDifferentInSync = show;
    }

    public boolean isShowNewOnSourceInSync() {
        return this.myState.myShowNewOnSourceInSync;
    }

    public void setShowNewOnSourceInSync(boolean show) {
        this.myState.myShowNewOnSourceInSync = show;
    }

    public boolean isShowNewOnTargetInSync() {
        return this.myState.myShowNewOnTargetInSync;
    }

    public void setShowNewOnTargetInSync(boolean show) {
        this.myState.myShowNewOnTargetInSync = show;
    }

    public boolean isShowExcludedInSync() {
        return this.myState.myShowExcludedInSync;
    }

    public void setShowExcludedInSync(boolean show) {
        this.myState.myShowExcludedInSync = show;
    }

    public boolean isDefault(@Nullable WebServerConfig server) {
        return server != null && StringUtil.equals((CharSequence)server.getId(), (CharSequence)((CharSequence)this.getDefaultServerIdAndName().first));
    }

    public boolean isDefault(@Nullable Deployable deployable) {
        if (deployable == null) {
            return false;
        }
        String id = deployable.getId();
        return id != null && id.equals(this.getDefaultServerIdAndName().first);
    }

    public boolean isConfigured(@Nullable WebServerConfig server, boolean deployPathOnly) {
        if (server == null) {
            return false;
        }
        return server.isUsedInProject(this.myProject, this, deployPathOnly);
    }

    public int compareServers(WebServerConfig o1, WebServerConfig o2) {
        boolean isProjectLevel2;
        boolean isConfigured2;
        boolean isDefault2;
        boolean isDefault1 = this.isDefault(o1);
        if (isDefault1 != (isDefault2 = this.isDefault(o2))) {
            return isDefault1 ? -1 : 1;
        }
        if (isDefault1) {
            return StringUtil.notNullize((String)o1.getName()).compareToIgnoreCase(StringUtil.notNullize((String)o2.getName()));
        }
        boolean isConfigured1 = this.isConfigured(o1, false);
        if (isConfigured1 != (isConfigured2 = this.isConfigured(o2, false))) {
            return isConfigured1 ? -1 : 1;
        }
        if (isConfigured1 && (isConfigured1 = this.isConfigured(o1, true)) != (isConfigured2 = this.isConfigured(o2, true))) {
            return isConfigured1 ? -1 : 1;
        }
        boolean isProjectLevel1 = o1.isProjectLevel();
        if (isProjectLevel1 != (isProjectLevel2 = o2.isProjectLevel())) {
            return isProjectLevel1 ? -1 : 1;
        }
        return StringUtil.notNullize((String)o1.getName()).compareToIgnoreCase(StringUtil.notNullize((String)o2.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verifier";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/PublishConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/PublishConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContentRoots";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestMappingForLocal";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestMappingDeploy2Local";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildMappingsDeploy2Local";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildMappingsForLocal";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultServerIdAndName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneExcludedPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AutoUploadState {
        ALWAYS{

            @Override
            public String getPresentableName() {
                return WDBundle.message("auto.upload.options.always", new Object[0]);
            }

            @Override
            @NonNls
            public String getSerializableName() {
                return "Always";
            }
        }
        ,
        ON_EXPLICIT_SAVE{

            @Override
            public String getPresentableName() {
                StringBuilder sb;
                ShortcutSet set;
                ShortcutSet set2;
                AnAction saveDocAction = ActionManager.getInstance().getAction("SaveDocument");
                Shortcut[] saveDocShortcuts = null;
                if (saveDocAction instanceof SaveDocumentAction && (set2 = saveDocAction.getShortcutSet()).getShortcuts().length > 0) {
                    saveDocShortcuts = set2.getShortcuts();
                }
                AnAction saveAllAction = ActionManager.getInstance().getAction("SaveAll");
                Shortcut[] saveAllShortcuts = null;
                if (saveAllAction instanceof SaveAllAction && (set = saveAllAction.getShortcutSet()).getShortcuts().length > 0) {
                    saveAllShortcuts = set.getShortcuts();
                }
                if (saveAllShortcuts != null && saveDocShortcuts != null) {
                    sb = new StringBuilder(KeymapUtil.getShortcutText((Shortcut)saveAllShortcuts[0]));
                    for (int i = 1; i < saveAllShortcuts.length; ++i) {
                        sb.append(", ");
                        sb.append(KeymapUtil.getShortcutText((Shortcut)saveAllShortcuts[i]));
                    }
                    for (Shortcut saveDocShortcut : saveDocShortcuts) {
                        sb.append(", ");
                        sb.append(KeymapUtil.getShortcutText((Shortcut)saveDocShortcut));
                    }
                    return WDBundle.message("auto.upload.options.on.explicit.save.action.0", sb);
                }
                if (saveAllShortcuts != null) {
                    sb = new StringBuilder(KeymapUtil.getShortcutText((Shortcut)saveAllShortcuts[0]));
                    for (int i = 1; i < saveAllShortcuts.length; ++i) {
                        sb.append(", ");
                        sb.append(KeymapUtil.getShortcutText((Shortcut)saveAllShortcuts[i]));
                    }
                    return WDBundle.message("auto.upload.options.on.explicit.save.action.0", sb);
                }
                if (saveDocShortcuts != null) {
                    sb = new StringBuilder(KeymapUtil.getShortcutText((Shortcut)saveDocShortcuts[0]));
                    for (int i = 1; i < saveDocShortcuts.length; ++i) {
                        sb.append(", ");
                        sb.append(KeymapUtil.getShortcutText((Shortcut)saveDocShortcuts[i]));
                    }
                    return WDBundle.message("auto.upload.options.on.explicit.save.action.file.save.all.or.0", sb);
                }
                return WDBundle.message("auto.upload.options.on.explicit.save.action.file.save.all", new Object[0]);
            }

            @Override
            @NonNls
            public String getSerializableName() {
                return "On explicit save action";
            }
        }
        ,
        NEVER{

            @Override
            public String getPresentableName() {
                return WDBundle.message("auto.upload.options.never", new Object[0]);
            }

            @Override
            @NonNls
            public String getSerializableName() {
                return "Never";
            }
        };


        public abstract String getPresentableName();

        @NonNls
        public abstract String getSerializableName();

        private static AutoUploadState fromName(String name) {
            for (AutoUploadState state : AutoUploadState.values()) {
                if (!state.getSerializableName().equals(name)) continue;
                return state;
            }
            if (name.startsWith("On explicit save action")) {
                return ON_EXPLICIT_SAVE;
            }
            throw new IllegalStateException("Unexpected AutoUploadState name: " + name);
        }
    }

    public static class State
    implements Cloneable {
        @Attribute(value="serverName")
        public String myDefaultServerName;
        @Attribute(value="serverId")
        public String myDefaultServerId;
        @Tag(value="servers")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, keyAttributeName="id", surroundValueWithTag=false, entryTagName="server")
        public Map<String, ServerData> myIdServerData = new HashMap<String, ServerData>();
        @Tag(value="serverData")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, keyAttributeName="name", surroundValueWithTag=false, entryTagName="paths")
        public Map<String, ServerData> myNameServerData = new HashMap<String, ServerData>();
        @Transient
        public Map<String, ServerData> myServerData = new HashMap<String, ServerData>();
        @Attribute(value="stopOnFirstError")
        public boolean myStopOnFirstError = false;
        @Attribute(value="overwriteAll")
        public boolean myOverwriteAll = true;
        @Attribute(value="preserveTimestamps")
        public boolean myPreserveTimestamps = true;
        @Attribute(value="deleteMissingItems")
        public boolean myDeleteMissingItems = false;
        @Attribute(value="createEmptyFolders")
        public boolean myCreateEmptyDirectories = false;
        @Attribute(value="traceLevel")
        public TraceLevel myTraceLevel = DEFAULT_TRACE_LEVEL;
        @Attribute(value="promptOnLocalOverwrite")
        public boolean myPromptOnLocalOverwrite = true;
        @Attribute(value="uploadOnCheckin")
        public String myUploadOnCheckinId;
        public String myUploadOnCheckinName;
        @Attribute(value="persistUploadOnCheckin")
        public boolean myPersistUploadOnCheckin = true;
        @Attribute(value="exclude")
        public String myExcludeMask = StringUtil.join((String[])DEFAULT_EXCLUDES, (String)";");
        @Attribute(value="filePermissions")
        public int myFilePermissions = -1;
        @Attribute(value="folderPermissions")
        public int myFolderPermissions = -1;
        public AutoUploadState myAutoUpload = AutoUploadState.NEVER;
        @Attribute(value="autoUploadExternalChanges")
        public boolean myAutoUploadExternalChanges = false;
        private PromptOnRemoteOverwrite myPromptOnRemoteOverwrite = PromptOnRemoteOverwrite.NONE;
        @Attribute(value="notifyRemoteChanges")
        public boolean myNotifyRemoteChanges = false;
        @Attribute(value="compareModeInSync")
        public DirDiffSettings.CompareMode myCompareModeInSync = DirDiffSettings.CompareMode.CONTENT;
        @Attribute(value="showEqualInSync")
        public boolean myShowEqualInSync = false;
        @Attribute(value="showDifferentInSync")
        public boolean myShowDifferentInSync = true;
        @Attribute(value="showNewOnSourceInSync")
        public boolean myShowNewOnSourceInSync = true;
        @Attribute(value="showNewOnTargetInSync")
        public boolean myShowNewOnTargetInSync = true;
        @Attribute(value="showExcludedInSync")
        public boolean myShowExcludedInSync = false;

        @Attribute(value="autoUpload")
        public String getAutoUpload() {
            return this.myAutoUpload.getSerializableName();
        }

        public void setAutoUpload(String autoUploadName) {
            this.myAutoUpload = AutoUploadState.fromName(autoUploadName);
        }

        @Attribute(value="promptOnRemoteOverwrite")
        public String getPromptOnRemoteOverwrite() {
            return this.myPromptOnRemoteOverwrite.name();
        }

        public void setPromptOnRemoteOverwrite(String promptOnRemoteOverwrite) {
            try {
                this.myPromptOnRemoteOverwrite = PromptOnRemoteOverwrite.valueOf(promptOnRemoteOverwrite);
            }
            catch (IllegalArgumentException e) {
                this.myPromptOnRemoteOverwrite = PromptOnRemoteOverwrite.NONE;
            }
        }

        protected State clone() {
            try {
                State clone = (State)super.clone();
                clone.myIdServerData = new HashMap<String, ServerData>(this.myIdServerData.size());
                for (Map.Entry<String, ServerData> entry : this.myIdServerData.entrySet()) {
                    clone.myIdServerData.put(entry.getKey(), entry.getValue().clone());
                }
                clone.myNameServerData = new HashMap<String, ServerData>(this.myNameServerData.size());
                for (Map.Entry<String, ServerData> entry : this.myNameServerData.entrySet()) {
                    clone.myNameServerData.put(entry.getKey(), entry.getValue().clone());
                }
                clone.myServerData = new HashMap<String, ServerData>(this.myServerData.size());
                for (Map.Entry<String, ServerData> entry : this.myServerData.entrySet()) {
                    clone.myServerData.put(entry.getKey(), entry.getValue().clone());
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @NotNull
        private State copyForDefaultProject() {
            State state;
            try {
                State clone = (State)super.clone();
                clone.myIdServerData = new HashMap<String, ServerData>();
                clone.myNameServerData = new HashMap<String, ServerData>();
                clone.myServerData = new HashMap<String, ServerData>();
                clone.myDefaultServerId = null;
                clone.myDefaultServerName = null;
                state = clone;
            }
            catch (CloneNotSupportedException e) {
                if (null == null) {
                    State.$$$reportNull$$$0(1);
                }
                return null;
            }
            if (state == null) {
                State.$$$reportNull$$$0(0);
            }
            return state;
        }

        private void loadOldData(OldPublishConfigStateHolder config, @NotNull Project project) {
            WebServerConfig defaultServer;
            if (project == null) {
                State.$$$reportNull$$$0(2);
            }
            this.myDefaultServerId = (defaultServer = config.findDefaultServer()) == null ? null : defaultServer.getId();
            this.myDefaultServerName = defaultServer == null ? null : defaultServer.getName();
            Map<String, List<DeploymentPathMapping>> allMappings = config.getAllPathMappings();
            Map<String, List<ExcludedPath>> allExcludedPaths = config.getAllExcludedPaths();
            HashSet knownIds = new HashSet();
            knownIds.addAll(allMappings.keySet());
            knownIds.addAll(allExcludedPaths.keySet());
            this.myIdServerData.clear();
            this.myNameServerData.clear();
            this.myServerData.clear();
            if (!knownIds.isEmpty()) {
                Map<String, WebServerConfig> idToServerMap = WebServersConfigManagerImpl.collectUnpatchedServers(project);
                for (String serverId : knownIds) {
                    List<ExcludedPath> excludedPaths;
                    WebServerConfig server = idToServerMap.get(serverId);
                    if (server == null) continue;
                    ServerData data = new ServerData();
                    List<DeploymentPathMapping> mappings = allMappings.get(serverId);
                    if (mappings != null) {
                        data.myPathMappings.addAll(mappings);
                    }
                    if ((excludedPaths = allExcludedPaths.get(serverId)) != null) {
                        data.myExcludedPaths.addAll(excludedPaths);
                    }
                    this.myNameServerData.put(server.getName(), data);
                }
            }
            this.myStopOnFirstError = config.isStopOnFirstError();
            this.myOverwriteAll = config.isOverwriteAll();
            this.myPreserveTimestamps = config.isPreserveTimestamps();
            this.myDeleteMissingItems = config.isDeleteMissingItems();
            this.myCreateEmptyDirectories = config.isCreateEmptyDirectories();
            this.myTraceLevel = config.getTraceLevel();
            this.myPromptOnLocalOverwrite = config.isPromptOnLocalOverwrite();
            Pair<String, String> onCheckin = config.getUploadOnCheckin();
            this.myUploadOnCheckinId = onCheckin == null ? null : (String)onCheckin.first;
            this.myUploadOnCheckinName = onCheckin == null ? null : (String)onCheckin.second;
            this.myPersistUploadOnCheckin = config.isPersistUploadOnCheckin();
            this.myExcludeMask = config.getExcludeMask();
            this.myFilePermissions = config.getFilePermissions();
            this.myFolderPermissions = config.getFolderPermissions();
            this.myAutoUpload = config.getAutoUploadState();
            this.myAutoUploadExternalChanges = config.isAutoUploadExternalChanges();
            this.myPromptOnRemoteOverwrite = config.getPromptOnRemoteOverwrite();
            this.myNotifyRemoteChanges = config.isNotifyRemoteChanges();
            this.myCompareModeInSync = config.getCompareModeInSync();
            this.myShowEqualInSync = config.isShowEqualInSync();
            this.myShowDifferentInSync = config.isShowDifferentInSync();
            this.myShowNewOnSourceInSync = config.isShowNewOnSourceInSync();
            this.myShowNewOnTargetInSync = config.isShowNewOnTargetInSync();
            this.myShowExcludedInSync = config.isShowExcludedInSync();
        }

        private void loadEffectiveServerData(Map<String, WebServerConfig> idToServer) {
            this.myServerData.clear();
            for (WebServerConfig serverConfig : idToServer.values()) {
                ServerData data = this.myNameServerData.get(serverConfig.getName());
                if (data == null) continue;
                this.myServerData.put(serverConfig.getId(), data);
            }
            this.myNameServerData.clear();
        }

        private void serializeEffectiveServerData(WebServersConfigManager manager) {
            this.myNameServerData.clear();
            for (Map.Entry<String, ServerData> entry : this.myServerData.entrySet()) {
                String id = entry.getKey();
                WebServerConfig serverConfig = manager.findServer(id);
                if (serverConfig != null) {
                    this.myNameServerData.put(serverConfig.getName(), entry.getValue());
                    continue;
                }
                LOG.debug("Failed to find server with id " + id);
            }
            this.myServerData.clear();
        }

        private void removeEffectivelyEmptyServerData(@Nullable Project project) {
            State.removeEffectivelyEmptyServerData(this.myIdServerData, project);
            State.removeEffectivelyEmptyServerData(this.myNameServerData, project);
            State.removeEffectivelyEmptyServerData(this.myServerData, project);
        }

        private static void removeEffectivelyEmptyServerData(Map<String, ServerData> map, @Nullable Project project) {
            Iterator<Map.Entry<String, ServerData>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ServerData> next = iterator.next();
                if (!State.isEffectivelyEmpty(next.getValue(), project)) continue;
                iterator.remove();
            }
        }

        private static boolean isEffectivelyEmpty(ServerData data, Project project) {
            if (!data.myExcludedPaths.isEmpty()) {
                return false;
            }
            for (DeploymentPathMapping next : data.myPathMappings) {
                if (next.isEffectivelyEmpty(project)) continue;
                return false;
            }
            return true;
        }

        private void improveDefaultServerData(WebServersConfigManager manager) {
            if (!StringUtil.isEmptyOrSpaces((String)this.myDefaultServerId)) {
                WebServerConfig server;
                if (StringUtil.isEmptyOrSpaces((String)this.myDefaultServerName) && (server = manager.findServer(this.myDefaultServerId)) != null) {
                    this.myDefaultServerName = server.getName();
                }
                this.myDefaultServerId = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/PublishConfig$State";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyForDefaultProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/PublishConfig$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadOldData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="serverdata")
    public static class ServerData
    implements Cloneable {
        @XCollection(propertyElementName="mappings")
        public List<DeploymentPathMapping> myPathMappings = new ArrayList<DeploymentPathMapping>();
        @XCollection(propertyElementName="excludedPaths")
        public List<ExcludedPath> myExcludedPaths = new ArrayList<ExcludedPath>();

        protected ServerData clone() {
            try {
                ServerData clone = (ServerData)super.clone();
                clone.myPathMappings = PublishConfig.cloneMappings(this.myPathMappings, false);
                clone.myExcludedPaths = PublishConfig.cloneExcludedPaths(this.myExcludedPaths);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static enum PromptOnRemoteOverwrite {
        NONE,
        CHECK_TIMESTAMP,
        CHECK_CONTENT;

    }

    public static enum TraceLevel {
        ERRORS(ConsoleViewContentType.ERROR_OUTPUT),
        BRIEF(ConsoleViewContentType.ERROR_OUTPUT, ConsoleViewContentType.SYSTEM_OUTPUT),
        DETAILS(ConsoleViewContentType.ERROR_OUTPUT, ConsoleViewContentType.SYSTEM_OUTPUT, ConsoleViewContentType.NORMAL_OUTPUT);

        private final ConsoleViewContentType[] myEnabledTypes;

        private TraceLevel(ConsoleViewContentType ... enabledTypes) {
            this.myEnabledTypes = enabledTypes;
        }

        public boolean enabled(ConsoleViewContentType type) {
            return ArrayUtil.contains((Object)type, (Object[])this.myEnabledTypes);
        }
    }
}

