/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.gutter.LiveRequestMappingsNavigationHandler;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class LiveRequestMappingsLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    static final Icon GUTTER_ICON = new LayeredIcon(new Icon[]{SpringApiIcons.RequestMapping, AllIcons.Nodes.RunnableMark});
    static final String GUTTER_NAME = "Live Request Mappings";

    public String getId() {
        return "LiveRequestMappingLineMarkerProvider";
    }

    public String getName() {
        return GUTTER_NAME;
    }

    public Icon getIcon() {
        return GUTTER_ICON;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Project project = psiElement.getProject();
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project) || !SpringMvcLibraryUtil.isSpringMVCEnabled((Project)project)) {
            return;
        }
        Collection infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos().values();
        if (infos.stream().noneMatch(info -> info.getRequestMappingsModel().getValue() != null)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement context, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UMethod uMethod;
        if (context == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((uMethod = (UMethod)UastContextKt.toUElement((PsiElement)context, UMethod.class)) == null) {
            return;
        }
        UElement anchor = uMethod.getUastAnchor();
        if (anchor == null) {
            return;
        }
        PsiElement nameIdentifier = UElementKt.getSourcePsiElement((UElement)anchor);
        if (nameIdentifier == null) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class);
        if (psiMethod == null) {
            return;
        }
        if (psiMethod.isConstructor()) {
            return;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        Project project = psiMethod.getProject();
        List items = ContainerUtil.newSmartList();
        Map infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        for (SpringBootApplicationInfo info : infos.values()) {
            List mappings;
            String applicationUrl;
            LiveRequestMappingsModel mappingsModel = (LiveRequestMappingsModel)info.getRequestMappingsModel().getValue();
            if (mappingsModel == null || (applicationUrl = (String)info.getApplicationUrl().getValue()) == null || (mappings = mappingsModel.getRequestMappingsByMethod(psiMethod)).isEmpty()) continue;
            items.add(new LiveRequestMappingsNavigationHandler.MethodNavigationItem(project, info, applicationUrl, mappings));
        }
        if (items.isEmpty()) {
            return;
        }
        LiveRequestMappingsNavigationHandler navigationHandler = new LiveRequestMappingsNavigationHandler(items);
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)GUTTER_ICON);
        builder.setNavigationHandler((GutterIconNavigationHandler)navigationHandler).setTooltipText(navigationHandler.getLiveMarkerInfoTooltipText()).setTargets((Collection)ContainerUtil.newSmartList((Object)nameIdentifier));
        result.add((RelatedItemLineMarkerInfo)builder.createSpringGroupLineMarkerInfo(nameIdentifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/mvc/gutter/LiveRequestMappingsLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

