/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.mvc.gutter.LiveRequestMappingsLineMarkerProvider;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.web.mvc.request.NavigatorHttpRequest;
import com.intellij.spring.web.mvc.request.RequestNavigator;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.SmartList;
import icons.SpringBootApiIcons;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class LiveRequestMappingsNavigationHandler
implements GutterIconNavigationHandler<PsiElement> {
    private final List<MethodNavigationItem> myItems;

    LiveRequestMappingsNavigationHandler(List<MethodNavigationItem> items) {
        this.myItems = items;
    }

    String getLiveMarkerInfoTooltipText() {
        if (this.myItems.size() == 1) {
            MethodNavigationItem item = this.myItems.get(0);
            if (item.mappings.size() == 1) {
                return LiveRequestMapping.appendMappingPath((String)item.applicationUrl, (String)item.mappings.get(0).getPath()) + " [" + item.info.getRunProfile().getName() + "]";
            }
            return item.info.getRunProfile().getName();
        }
        return "Live Request Mappings";
    }

    public void navigate(MouseEvent e, PsiElement element) {
        if (this.myItems.size() == 1) {
            MethodNavigationItem item = this.myItems.get(0);
            if (item.mappings.size() == 1) {
                LiveRequestMappingsNavigationHandler.navigateToMapping(item, item.mappings.get(0));
            } else {
                LiveRequestMappingsNavigationHandler.createMappingsPopup(null, this.myItems.get(0)).show(new RelativePoint(e));
            }
        } else {
            LiveRequestMappingsNavigationHandler.createApplicationsPopup(this.myItems).show(new RelativePoint(e));
        }
    }

    @NotNull
    private static ListPopup createApplicationsPopup(List<MethodNavigationItem> items) {
        ListPopupImpl listPopupImpl = new ListPopupImpl((ListPopupStep)new ApplicationsPopupStep(items)){

            protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
                if (!(step instanceof ListPopupStep)) {
                    throw new IllegalArgumentException("Step: " + step.getClass().toString());
                }
                if (!(parentValue instanceof MethodNavigationItem)) {
                    throw new IllegalArgumentException("Parent value: " + step.getClass().toString());
                }
                return LiveRequestMappingsNavigationHandler.createMappingsPopup(parent, (MethodNavigationItem)parentValue);
            }
        };
        if (listPopupImpl == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(0);
        }
        return listPopupImpl;
    }

    @NotNull
    private static ListPopupImpl createMappingsPopup(WizardPopup parent, final MethodNavigationItem item) {
        ListPopupImpl listPopupImpl = new ListPopupImpl(parent, (ListPopupStep)new MappingsPopupStep(item), item){

            protected ListCellRenderer getListElementRenderer() {
                return new LiveRequestMappingPopupRenderer(item.applicationUrl);
            }
        };
        if (listPopupImpl == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(1);
        }
        return listPopupImpl;
    }

    private static void navigateToMapping(MethodNavigationItem item, LiveRequestMapping mapping) {
        NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(mapping, item.applicationUrl);
        Arrays.stream(RequestNavigator.EP_NAME.getExtensions()).filter(navigator -> navigator.accept(request)).findFirst().ifPresent(navigator -> navigator.navigate(item.project, request, item.info.getRunProfile().getName()));
    }

    private static NavigatorHttpRequest createRequest(LiveRequestMapping mapping, String applicationUrl) {
        String url = LiveRequestMapping.appendMappingPath((String)applicationUrl, (String)mapping.getPath());
        List requestMethods = mapping.getRequestMethods();
        String requestMethod = requestMethods.isEmpty() ? "" : (requestMethods.contains("GET") ? "GET" : (String)requestMethods.get(0));
        List headers = (List)mapping.getHeaders().stream().filter(header -> !((String)header.first).startsWith("!")).collect(Collectors.toCollection(SmartList::new));
        mapping.getProduces().stream().filter(value -> !value.startsWith("!")).findFirst().ifPresent(value -> headers.add(Pair.create((Object)"Accept", (Object)value)));
        mapping.getConsumes().stream().filter(value -> !value.startsWith("!")).findFirst().ifPresent(value -> headers.add(Pair.create((Object)"Content-Type", (Object)value)));
        List params = (List)mapping.getParams().stream().filter(param -> !((String)param.first).startsWith("!")).collect(Collectors.toCollection(SmartList::new));
        return new NavigatorHttpRequest(url, requestMethod, headers, params);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/gutter/LiveRequestMappingsNavigationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createApplicationsPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createMappingsPopup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class MethodNavigationItem {
        final Project project;
        final SpringBootApplicationInfo info;
        final String applicationUrl;
        final List<LiveRequestMapping> mappings;

        MethodNavigationItem(Project project, SpringBootApplicationInfo info, String applicationUrl, List<LiveRequestMapping> mappings) {
            this.project = project;
            this.info = info;
            this.applicationUrl = applicationUrl;
            this.mappings = mappings;
        }
    }

    private static class LiveRequestMappingPopupRenderer
    extends ColoredListCellRenderer<LiveRequestMapping> {
        private final String myApplicationUrl;

        LiveRequestMappingPopupRenderer(String applicationUrl) {
            this.myApplicationUrl = applicationUrl;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends LiveRequestMapping> list, LiveRequestMapping value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                LiveRequestMappingPopupRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(LiveRequestMappingsLineMarkerProvider.GUTTER_ICON);
            SimpleTextAttributes urlTextAttributes = value.canNavigate() ? (selected ? new SimpleTextAttributes(16, UI.getColor((String)"link.hover.foreground")) : new SimpleTextAttributes(0, UI.getColor((String)"link.foreground"))) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            this.append(LiveRequestMapping.appendMappingPath((String)this.myApplicationUrl, (String)value.getPath()), urlTextAttributes);
            List requestMethods = value.getRequestMethods();
            if (!requestMethods.isEmpty()) {
                this.append(" [" + StringUtil.join((Collection)requestMethods, (String)"|") + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/boot/mvc/gutter/LiveRequestMappingsNavigationHandler$LiveRequestMappingPopupRenderer", "customizeCellRenderer"));
        }
    }

    private static class MappingsPopupStep
    extends BaseListPopupStep<LiveRequestMapping> {
        private final MethodNavigationItem myItem;

        MappingsPopupStep(MethodNavigationItem item) {
            super(item.info.getRunProfile().getName(), item.mappings);
            this.myItem = item;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(LiveRequestMapping mapping, boolean finalChoice) {
            LiveRequestMappingsNavigationHandler.navigateToMapping(this.myItem, mapping);
            return FINAL_CHOICE;
        }
    }

    private static class ApplicationsPopupStep
    extends BaseListPopupStep<MethodNavigationItem> {
        ApplicationsPopupStep(List<MethodNavigationItem> items) {
            super("Live Request Mappings", items);
        }

        @NotNull
        public String getTextFor(MethodNavigationItem item) {
            String string = item.info.getRunProfile().getName();
            if (string == null) {
                ApplicationsPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(MethodNavigationItem item) {
            return true;
        }

        public Icon getIconFor(MethodNavigationItem item) {
            return SpringBootApiIcons.SpringBoot;
        }

        public PopupStep onChosen(MethodNavigationItem item, boolean finalChoice) {
            return new MappingsPopupStep(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/mvc/gutter/LiveRequestMappingsNavigationHandler$ApplicationsPopupStep", "getTextFor"));
        }
    }
}

