/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComboBoxContentQuery;
import org.fest.swing.driver.JComboBoxDropDownListFinder;
import org.fest.swing.driver.JComboBoxEditableQuery;
import org.fest.swing.driver.JComboBoxItemCountQuery;
import org.fest.swing.driver.JComboBoxItemIndexPreconditions;
import org.fest.swing.driver.JComboBoxMatchingItemQuery;
import org.fest.swing.driver.JComboBoxSelectedIndexQuery;
import org.fest.swing.driver.JComboBoxSelectionValueQuery;
import org.fest.swing.driver.JComboBoxSetSelectedIndexTask;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JComboBoxDriver
extends JComponentDriver<JComboBox> {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListDriver listDriver;
    private final JComboBoxDropDownListFinder dropDownListFinder;
    private JComboBoxCellReader cellReader;

    public JComboBoxDriver(@Nonnull Robot robot) {
        super(robot);
        this.listDriver = new JListDriver(robot);
        this.dropDownListFinder = new JComboBoxDropDownListFinder(robot);
        this.replaceCellReader(new BasicJComboBoxCellReader());
    }

    @Nonnull
    @RunsInEDT
    public String[] contentsOf(@Nonnull JComboBox comboBox) {
        return JComboBoxContentQuery.contents(comboBox, this.cellReader());
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox comboBox, @Nullable String value) {
        this.selectItem(comboBox, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox comboBox, @Nonnull Pattern pattern) {
        this.selectItem(comboBox, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(@Nonnull JComboBox comboBox, @Nonnull TextMatcher matcher) {
        int index = JComboBoxMatchingItemQuery.matchingItemIndex(comboBox, matcher, this.cellReader());
        if (index < 0) {
            String format = "Unable to find item matching %s among the JComboBox contents: ";
            String msg = String.format(format, matcher.description(), Arrays.format((Object)this.contentsOf(comboBox)));
            throw new LocationUnavailableException(msg);
        }
        this.selectItem(comboBox, index);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox comboBox, @Nullable String value) {
        String selection = this.requiredSelectionOf(comboBox);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox comboBox, @Nonnull Pattern pattern) {
        String selection = this.requiredSelectionOf(comboBox);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox)).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    private String requiredSelectionOf(@Nonnull JComboBox comboBox) throws AssertionError {
        Pair<Boolean, String> selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader());
        boolean hasSelection = (Boolean)selection.first;
        if (!hasSelection) {
            throw this.failNoSelection(comboBox);
        }
        return (String)selection.second;
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox comboBox, int index) {
        int selectedIndex = JComboBoxSelectedIndexQuery.selectedIndexOf(comboBox);
        if (selectedIndex == -1) {
            this.failNoSelection(comboBox);
        }
        ((IntAssert)Assertions.assertThat((int)selectedIndex).as(this.selectedIndexProperty(comboBox))).isEqualTo(index);
    }

    @Nonnull
    private AssertionError failNoSelection(@Nonnull JComboBox comboBox) {
        throw Fail.fail((String)String.format("[%s] No selection", this.selectedIndexProperty(comboBox).value()));
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JComboBox comboBox) {
        Pair<Boolean, String> selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader());
        boolean hasSelection = (Boolean)selection.first;
        if (!hasSelection) {
            return;
        }
        String format = "[%s] Expecting no selection, but found:<%s>";
        Fail.fail((String)String.format(format, this.selectedIndexProperty(comboBox).value(), Strings.quote((String)((String)selection.second))));
    }

    @Nullable
    public String value(@Nonnull JComboBox comboBox, int index) {
        return JComboBoxDriver.valueAsText(comboBox, index, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String valueAsText(final @Nonnull JComboBox comboBox, final int index, final @Nonnull JComboBoxCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            @Nullable
            protected String executeInEDT() {
                JComboBoxItemIndexPreconditions.checkItemIndexInBounds(comboBox, index);
                return cellReader.valueAt(comboBox, index);
            }
        });
    }

    @Nonnull
    private Description selectedIndexProperty(@Nonnull JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, SELECTED_INDEX_PROPERTY);
    }

    public void clearSelection(@Nonnull JComboBox comboBox) {
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, -1);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox comboBox, int index) {
        JComboBoxDriver.validateCanSelectItem(comboBox, index);
        this.showDropDownList(comboBox);
        this.selectItemAtIndex(comboBox, index);
        this.hideDropDownListIfVisible(comboBox);
    }

    @RunsInEDT
    private static void validateCanSelectItem(final @Nonnull JComboBox comboBox, final int index) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(comboBox);
                JComboBoxItemIndexPreconditions.checkItemIndexInBounds(comboBox, index);
            }
        });
    }

    @VisibleForTesting
    @RunsInEDT
    void showDropDownList(@Nonnull JComboBox comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, true);
    }

    @RunsInEDT
    private void selectItemAtIndex(@Nonnull JComboBox comboBox, int index) {
        JList dropDownList = this.dropDownListFinder.findDropDownList();
        if (dropDownList != null) {
            this.listDriver.selectItem(dropDownList, index);
            return;
        }
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, index);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void hideDropDownListIfVisible(@Nonnull JComboBox comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, false);
    }

    @RunsInEDT
    private void dropDownVisibleThroughUIDelegate(final @Nonnull JComboBox comboBox, final boolean visible) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                comboBox.setPopupVisible(visible);
            }
        });
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void replaceText(@Nonnull JComboBox comboBox, @Nonnull String text) {
        this.selectAllText(comboBox);
        this.enterText(comboBox, text);
    }

    @RunsInEDT
    public void selectAllText(@Nonnull JComboBox comboBox) {
        Component editor = JComboBoxDriver.accessibleEditorOf(comboBox);
        if (!(editor instanceof JComponent)) {
            return;
        }
        this.focus(editor);
        this.invokeAction((JComponent)editor, "select-all");
    }

    @Nullable
    @RunsInEDT
    private static Component accessibleEditorOf(final @Nonnull JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                JComboBoxDriver.checkAccessibleEditor(comboBox);
                return JComboBoxDriver.editorComponentOf(comboBox);
            }
        });
    }

    @RunsInEDT
    public void enterText(final @Nonnull JComboBox comboBox, @Nonnull String text) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JComboBoxDriver.checkAccessibleEditor(comboBox);
            }
        });
        Component editor = JComboBoxDriver.editorComponentOf(comboBox);
        if (editor == null) {
            throw ActionFailedException.actionFailure("JComboBox does not have an editor");
        }
        this.focusAndWaitForFocusGain(editor);
        this.robot.enterText(text);
    }

    @Override
    @RunsInEDT
    public void pressAndReleaseKeys(@Nonnull JComboBox comboBox, int ... keyCodes) {
        Preconditions.checkNotNull((Object)keyCodes);
        JComboBoxDriver.checkInEdtEnabledAndShowing(comboBox);
        Component target = JComboBoxDriver.editorIfEditable(comboBox);
        if (target == null) {
            target = comboBox;
        }
        this.focusAndWaitForFocusGain(target);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    private static Component editorIfEditable(final JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                if (!comboBox.isEditable()) {
                    return null;
                }
                return JComboBoxDriver.editorComponent(comboBox);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkAccessibleEditor(@Nonnull JComboBox comboBox) {
        ComponentPreconditions.checkEnabledAndShowing(comboBox);
        if (!comboBox.isEditable()) {
            String msg = String.format("Expecting component %s to be editable", Formatting.format(comboBox));
            throw new IllegalStateException(msg);
        }
    }

    @Nullable
    @RunsInEDT
    private static Component editorComponentOf(final @Nonnull JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                return JComboBoxDriver.editorComponent(comboBox);
            }
        });
    }

    @Nullable
    @RunsInCurrentThread
    private static Component editorComponent(@Nonnull JComboBox comboBox) {
        ComboBoxEditor editor = comboBox.getEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorComponent();
    }

    @Nonnull
    @RunsInEDT
    public JList dropDownList() {
        JList list = this.dropDownListFinder.findDropDownList();
        if (list == null) {
            throw new ComponentLookupException("Unable to find the pop-up list for the JComboBox");
        }
        return list;
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JComboBox comboBox) {
        this.checkEditable(comboBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JComboBox comboBox) {
        this.checkEditable(comboBox, false);
    }

    @RunsInEDT
    private void checkEditable(@Nonnull JComboBox comboBox, boolean expected) {
        ((BooleanAssert)Assertions.assertThat((boolean)JComboBoxEditableQuery.isEditable(comboBox)).as(JComboBoxDriver.editableProperty(comboBox))).isEqualTo(expected);
    }

    @RunsInEDT
    private static Description editableProperty(@Nonnull JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, EDITABLE_PROPERTY);
    }

    public void replaceCellReader(@Nonnull JComboBoxCellReader newCellReader) {
        this.cellReader = (JComboBoxCellReader)Preconditions.checkNotNull((Object)newCellReader);
    }

    @RunsInEDT
    public void requireItemCount(@Nonnull JComboBox comboBox, int expected) {
        int actual = JComboBoxItemCountQuery.itemCountIn(comboBox);
        ((IntAssert)Assertions.assertThat((int)actual).as(JComboBoxDriver.propertyName(comboBox, "itemCount"))).isEqualTo(expected);
    }

    @Nullable
    public String selectedItemOf(@Nonnull JComboBox comboBox) {
        return (String)JComboBoxSelectionValueQuery.selection((JComboBox)comboBox, (JComboBoxCellReader)this.cellReader()).second;
    }

    @Nonnull
    private JComboBoxCellReader cellReader() {
        return this.cellReader;
    }
}

