/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTabbedPane;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

final class JTabbedPaneTabIndexQuery {
    @RunsInEDT
    static int indexOfTab(final @Nonnull JTabbedPane tabbedPane, final @Nonnull TextMatcher matcher) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    if (!matcher.isMatching(tabbedPane.getTitleAt(i))) continue;
                    return i;
                }
                return -1;
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    private JTabbedPaneTabIndexQuery() {
    }
}

