/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ChildrenFinderStrategy;
import org.fest.swing.hierarchy.JDesktopPaneChildrenFinder;
import org.fest.swing.hierarchy.JMenuChildrenFinder;
import org.fest.swing.hierarchy.WindowChildrenFinder;
import org.fest.util.Lists;
import org.fest.util.VisibleForTesting;

class ChildrenFinder {
    private static List<ChildrenFinderStrategy> strategies = Lists.newArrayList((Object[])new ChildrenFinderStrategy[]{new JDesktopPaneChildrenFinder(), new JMenuChildrenFinder(), new WindowChildrenFinder()});

    ChildrenFinder() {
    }

    @Nonnull
    @RunsInCurrentThread
    Collection<Component> childrenOf(@Nonnull Component c) {
        if (!(c instanceof Container)) {
            return Lists.emptyList();
        }
        Container container = (Container)c;
        ArrayList children = Lists.newArrayList((Object[])container.getComponents());
        children.addAll(this.nonExplicitChildrenOf(container));
        return children;
    }

    @Nonnull
    private Collection<Component> nonExplicitChildrenOf(@Nonnull Container c) {
        ArrayList children = Lists.newArrayList();
        for (ChildrenFinderStrategy s : strategies) {
            children.addAll(s.nonExplicitChildrenOf(c));
        }
        return children;
    }

    @Nonnull
    @VisibleForTesting
    static List<ChildrenFinderStrategy> strategies() {
        return Lists.newArrayList(strategies);
    }

    @VisibleForTesting
    static void replaceStrategiesWith(@Nonnull List<ChildrenFinderStrategy> newStrategies) {
        strategies = Lists.newArrayList(newStrategies);
    }
}

