/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.lock;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.fest.swing.exception.ScreenLockException;

@ThreadSafe
public final class ScreenLock {
    private final Lock lock = new ReentrantLock();
    private final Condition released = this.lock.newCondition();
    @GuardedBy(value="lock")
    private Object owner;
    @GuardedBy(value="lock")
    private boolean acquired;

    public void acquire(@Nonnull Object newOwner) {
        this.lock.lock();
        try {
            if (this.acquired && this.owner == newOwner) {
                return;
            }
            while (this.acquired) {
                this.released.await();
            }
            this.owner = newOwner;
            this.acquired = true;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release(@Nonnull Object currentOwner) {
        this.lock.lock();
        try {
            if (!this.acquired) {
                throw new ScreenLockException("No lock to release");
            }
            if (this.owner != currentOwner) {
                throw new ScreenLockException(String.format("%s is not the lock owner", currentOwner.toString()));
            }
            this.acquired = false;
            this.owner = null;
            this.released.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquiredBy(@Nullable Object possibleOwner) {
        if (possibleOwner == null) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.acquired && this.owner == possibleOwner;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquired() {
        this.lock.lock();
        try {
            boolean bl = this.acquired;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nonnull
    public static ScreenLock instance() {
        return ScreenLockHolder.instance;
    }

    ScreenLock() {
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

