/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.MultipleBuildsView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AbstractViewManager
implements ViewManager,
BuildProgressListener,
Disposable {
    private static final Key<Boolean> d = new Key("PINNED_EXTRACTED_CONTENT");
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicClearableLazyValue<MultipleBuildsView> b;
    private final Set<MultipleBuildsView> c;
    private final AtomicBoolean a = new AtomicBoolean(false);

    public AbstractViewManager(Project project2, BuildContentManager buildContentManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.b = new AtomicClearableLazyValue<MultipleBuildsView>(){

            @NotNull
            protected MultipleBuildsView compute() {
                MultipleBuildsView multipleBuildsView;
                MultipleBuildsView multipleBuildsView2 = new MultipleBuildsView(AbstractViewManager.this.myProject, AbstractViewManager.this.myBuildContentManager, AbstractViewManager.this);
                try {
                    Disposer.register((Disposable)AbstractViewManager.this, (Disposable)multipleBuildsView2);
                    multipleBuildsView = multipleBuildsView2;
                    if (multipleBuildsView == null) {
                        1.a(0);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw 1.b(illegalStateException);
                }
                return multipleBuildsView;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/AbstractViewManager$1", "compute"));
            }

            private static IllegalStateException b(IllegalStateException illegalStateException) {
                return illegalStateException;
            }
        };
        this.c = ContainerUtil.newConcurrentSet();
    }

    @Override
    public boolean isConsoleEnabledByDefault() {
        return false;
    }

    @Override
    public boolean isBuildContentView() {
        return true;
    }

    protected abstract String getViewName();

    protected Map<BuildInfo, BuildView> getBuildsMap() {
        return ((MultipleBuildsView)this.b.getValue()).getBuildsMap();
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        MultipleBuildsView multipleBuildsView2;
        if (this.a.get()) {
            return;
        }
        if (buildEvent instanceof StartBuildEvent) {
            this.a();
            multipleBuildsView2 = (MultipleBuildsView)this.b.getValue();
        } else {
            multipleBuildsView2 = (MultipleBuildsView)this.b.getValue();
            if (!multipleBuildsView2.shouldConsume(buildEvent)) {
                multipleBuildsView2 = this.c.stream().filter(multipleBuildsView -> multipleBuildsView.shouldConsume(buildEvent)).findFirst().orElse(null);
            }
        }
        if (multipleBuildsView2 != null) {
            multipleBuildsView2.onEvent(buildEvent);
        }
    }

    void configureToolbar(DefaultActionGroup defaultActionGroup, MultipleBuildsView multipleBuildsView, BuildView buildView) {
        defaultActionGroup.removeAll();
        defaultActionGroup.addAll(buildView.createConsoleActions());
        defaultActionGroup.add((AnAction)new PinBuildViewAction(multipleBuildsView));
        defaultActionGroup.add((AnAction)new CloseBuildContentAction(multipleBuildsView));
    }

    @Nullable
    protected Icon getContentIcon() {
        return null;
    }

    protected void onBuildStart(BuildDescriptor buildDescriptor) {
    }

    protected void onBuildFinish(BuildDescriptor buildDescriptor) {
        BuildInfo buildInfo = (BuildInfo)buildDescriptor;
        if (buildInfo.result instanceof FailureResult) {
            boolean bl2 = buildInfo.activateToolWindowWhenFailed;
            this.myBuildContentManager.setSelectedContent(buildInfo.content, bl2, bl2, bl2, null);
            List<? extends Failure> list = ((FailureResult)buildInfo.result).getFailures();
            if (list.isEmpty()) {
                return;
            }
            Failure failure = list.get(0);
            Notification notification = failure.getNotification();
            if (notification != null) {
                String string = notification.getTitle();
                String string2 = notification.getContent();
                SystemNotifications.getInstance().notify(ToolWindowId.BUILD, string, string2);
            }
        }
    }

    public void dispose() {
        this.a.set(true);
        this.c.clear();
        this.b.drop();
    }

    private void a() {
        MultipleBuildsView multipleBuildsView = (MultipleBuildsView)this.b.getValue();
        Content content = multipleBuildsView.getContent();
        if (content != null && content.isPinned()) {
            String string = this.a(multipleBuildsView);
            UIUtil.invokeLaterIfNeeded(() -> {
                content.setPinnable(false);
                if (content.getIcon() == null) {
                    content.setIcon(EmptyIcon.ICON_8);
                }
                content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                ((BuildContentManagerImpl)this.myBuildContentManager).updateTabDisplayName(content, string);
            });
            this.c.add(multipleBuildsView);
            this.b.drop();
            content.putUserData(d, (Object)Boolean.TRUE);
        }
    }

    private String a(MultipleBuildsView multipleBuildsView) {
        Map<BuildInfo, BuildView> map = multipleBuildsView.getBuildsMap();
        BuildInfo buildInfo3 = map.keySet().stream().reduce((buildInfo, buildInfo2) -> buildInfo.getStartTime() <= buildInfo2.getStartTime() ? buildInfo : buildInfo2).orElse(null);
        if (buildInfo3 != null) {
            String string = buildInfo3.getTitle();
            String string2 = this.getViewName();
            String string3 = string2 + ": " + StringUtil.trimStart((String)string, (String)string2);
            if (map.size() > 1) {
                string3 = string3 + String.format(" and %d more", map.size() - 1);
            }
            return string3;
        }
        return this.getViewName();
    }

    private class CloseBuildContentAction
    extends AnAction
    implements DumbAware {
        private MultipleBuildsView a;

        public CloseBuildContentAction(MultipleBuildsView multipleBuildsView) {
            this.a = multipleBuildsView;
            AnAction anAction = ActionManager.getInstance().getAction("CloseContent");
            this.copyFrom(anAction);
            this.registerCustomShortcutSet(anAction.getShortcutSet(), multipleBuildsView.getContent().getPreferredFocusableComponent());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Cancel);
            presentation.setText(ExecutionBundle.message((String)"close.tab.action.name", (Object[])new Object[0]));
            presentation.setDescription(null);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            if (this.a == null) {
                return;
            }
            Content content = this.a.getContent();
            if (!content.isValid()) {
                return;
            }
            content.getManager().removeContent(content, true, true, true);
            if (AbstractViewManager.this.b.getValue() == this.a) {
                AbstractViewManager.this.b.drop();
            } else {
                AbstractViewManager.this.c.remove(this.a);
            }
            this.a = null;
        }

        public void update(AnActionEvent anActionEvent) {
            if (this.a != null && this.a.hasRunningBuilds()) {
                anActionEvent.getPresentation().setEnabled(false);
            } else {
                anActionEvent.getPresentation().setEnabled(this.a != null);
            }
        }
    }

    private static class PinBuildViewAction
    extends DumbAwareAction
    implements Toggleable {
        private final Content a;

        public PinBuildViewAction(MultipleBuildsView multipleBuildsView) {
            this.a = multipleBuildsView.getContent();
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            boolean bl2;
            try {
                bl2 = !this.a.isPinned();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw PinBuildViewAction.b(illegalArgumentException);
            }
            boolean bl3 = bl2;
            try {
                if (bl3) {
                    this.a.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw PinBuildViewAction.b(illegalArgumentException);
            }
            this.a.setPinned(bl3);
            anActionEvent.getPresentation().putClientProperty("selected", (Object)bl3);
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            String string;
            block20: {
                String string2;
                boolean bl2;
                block17: {
                    String string3;
                    block19: {
                        block18: {
                            boolean bl3;
                            try {
                                if (anActionEvent == null) {
                                    PinBuildViewAction.a(0);
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PinBuildViewAction.b(illegalArgumentException);
                            }
                            try {
                                if (!this.a.isValid()) {
                                    return;
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PinBuildViewAction.b(illegalArgumentException);
                            }
                            Boolean bl4 = (Boolean)this.a.getUserData(d);
                            try {
                                if (bl4 == Boolean.TRUE) {
                                    anActionEvent.getPresentation().setEnabledAndVisible(false);
                                    return;
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PinBuildViewAction.b(illegalArgumentException);
                            }
                            try {
                                bl3 = this.a.getManager().getSelectedContent() == this.a;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PinBuildViewAction.b(illegalArgumentException);
                            }
                            boolean bl5 = bl3;
                            bl2 = this.a.isPinned();
                            try {
                                try {
                                    anActionEvent.getPresentation().setIcon(AllIcons.General.Pin_tab);
                                    anActionEvent.getPresentation().putClientProperty("selected", (Object)bl2);
                                    if (bl5) break block17;
                                    if (!bl2) break block18;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw PinBuildViewAction.b(illegalArgumentException);
                                }
                                string3 = IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]);
                                break block19;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PinBuildViewAction.b(illegalArgumentException);
                            }
                        }
                        string3 = IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0]);
                    }
                    string = string3;
                    break block20;
                }
                try {
                    string2 = bl2 ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw PinBuildViewAction.b(illegalArgumentException);
                }
                string = string2;
            }
            anActionEvent.getPresentation().setText(string);
            anActionEvent.getPresentation().setEnabledAndVisible(true);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/AbstractViewManager$PinBuildViewAction", "update"));
        }

        private static IllegalArgumentException b(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    static class BuildInfo
    extends DefaultBuildDescriptor {
        String message;
        String statusMessage;
        long endTime;
        EventResult result;
        Content content;
        boolean activateToolWindowWhenAdded;
        boolean activateToolWindowWhenFailed;

        public BuildInfo(@NotNull Object object, @NotNull String string, @NotNull String string2, long l2) {
            if (object == null) {
                BuildInfo.b(0);
            }
            if (string == null) {
                BuildInfo.b(1);
            }
            if (string2 == null) {
                BuildInfo.b(2);
            }
            super(object, string, string2, l2);
            this.endTime = -1L;
            this.activateToolWindowWhenFailed = true;
        }

        public Icon getIcon() {
            return BuildInfo.a(this.result);
        }

        private static Icon a(EventResult eventResult) {
            try {
                if (eventResult == null) {
                    return ExecutionNodeProgressAnimator.getCurrentFrame();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw BuildInfo.c(illegalArgumentException);
            }
            try {
                if (eventResult instanceof FailureResult) {
                    return AllIcons.Process.State.RedExcl;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw BuildInfo.c(illegalArgumentException);
            }
            try {
                if (eventResult instanceof SkippedResult) {
                    return AllIcons.Process.State.YellowStr;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw BuildInfo.c(illegalArgumentException);
            }
            return AllIcons.Process.State.GreenOK;
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void b(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException c(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }
}

