/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int g = 8;
    private static final int c = 1200;
    private static final int f = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long a = -1L;
    private Alarm d;
    private List<ExecutionNode> e = new SmartList();
    private BuildTreeConsoleView b;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView buildTreeConsoleView) {
        Disposer.register((Disposable)buildTreeConsoleView, (Disposable)this);
        this.d = new Alarm();
        this.b = buildTreeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long l2;
        if (!this.e.isEmpty() && (l2 = System.currentTimeMillis()) - this.a >= 150L) {
            this.c();
            this.a = l2;
        }
        this.b();
    }

    public void addNode(@Nullable ExecutionNode executionNode) {
        this.e.add(executionNode);
    }

    public void startMovie() {
        this.b();
    }

    public void stopMovie() {
        this.c();
        for (ExecutionNode executionNode : this.e) {
            executionNode.setIconProvider(() -> AllIcons.Process.State.YellowStr);
            executionNode.setEndTime(System.currentTimeMillis());
        }
        this.e.clear();
        this.d();
    }

    public void dispose() {
        this.b = null;
        this.e.clear();
        this.d();
    }

    private void d() {
        if (this.d != null) {
            this.d.cancelAllRequests();
            this.d = null;
        }
    }

    private void c() {
        if (this.b == null || this.b.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.e.iterator();
        while (iterator.hasNext()) {
            ExecutionNode executionNode = iterator.next();
            this.b.scheduleUpdate(executionNode);
            if (executionNode.isRunning()) continue;
            iterator.remove();
        }
    }

    private void b() {
        if (this.d == null) {
            return;
        }
        this.d.cancelAllRequests();
        this.d.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

