/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean l;
    private final List<Runnable> d;
    private final ProgressWatcher h;
    private final ThreeComponentsSplitter i;
    private final JBList<AbstractViewManager.BuildInfo> b;
    private final Map<Object, AbstractViewManager.BuildInfo> k;
    private final Map<AbstractViewManager.BuildInfo, BuildView> f;
    private final AbstractViewManager e;
    private volatile Content a;
    private volatile DefaultActionGroup g;
    private volatile boolean c;
    private final TransferToEDTQueue<Runnable> j;

    public MultipleBuildsView(Project project2, BuildContentManager buildContentManager, AbstractViewManager abstractViewManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.e = abstractViewManager;
        this.l = new AtomicBoolean();
        this.d = ContainerUtil.createConcurrentList();
        this.i = new ThreeComponentsSplitter();
        Disposer.register((Disposable)this, (Disposable)this.i);
        this.b = new JBList();
        this.b.setModel(new DefaultListModel());
        this.b.setFixedCellHeight(40);
        this.b.installCellRenderer(object -> {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)object;
            JPanel jPanel = new JPanel(new BorderLayout());
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setIcon(buildInfo.getIcon());
            simpleColoredComponent.append(buildInfo.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            simpleColoredComponent.append(buildInfo.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            jPanel.add((Component)simpleColoredComponent, "North");
            if (buildInfo.statusMessage != null) {
                SimpleColoredComponent simpleColoredComponent2 = new SimpleColoredComponent();
                simpleColoredComponent2.setIcon(EmptyIcon.ICON_16);
                simpleColoredComponent2.append(buildInfo.statusMessage, SimpleTextAttributes.GRAY_ATTRIBUTES);
                jPanel.add((Component)simpleColoredComponent2, "South");
            }
            return jPanel;
        });
        this.f = ContainerUtil.newConcurrentMap();
        this.k = ContainerUtil.newConcurrentMap();
        this.h = new ProgressWatcher();
        this.j = new TransferToEDTQueue("Multiple builds view queue", runnable -> {
            runnable.run();
            return true;
        }, object -> this.c);
    }

    public void dispose() {
        this.c = true;
    }

    public Content getContent() {
        return this.a;
    }

    public Map<AbstractViewManager.BuildInfo, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.f);
    }

    public boolean shouldConsume(BuildEvent buildEvent) {
        return buildEvent.getParentId() != null && this.k.containsKey(buildEvent.getParentId()) || this.k.containsKey(buildEvent.getId());
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        SmartList smartList = new SmartList();
        if (buildEvent instanceof StartBuildEvent) {
            if (this.l.get()) {
                long l2 = System.currentTimeMillis();
                DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
                boolean bl2 = !defaultListModel.isEmpty();
                for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                    AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)defaultListModel.getElementAt(i2);
                    if (buildInfo.endTime != -1L && l2 - buildInfo.endTime >= TimeUnit.SECONDS.toMillis(1L)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    this.k.clear();
                    SmartList smartList2 = new SmartList(this.f.values());
                    smartList.add(() -> smartList2.forEach(Disposer::dispose));
                    this.f.clear();
                    defaultListModel.clear();
                    this.b.setVisible(false);
                    smartList.add(() -> {
                        this.i.setFirstComponent(null);
                        this.i.setLastComponent(null);
                    });
                    this.g.removeAll();
                }
            }
            StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
            AbstractViewManager.BuildInfo buildInfo = new AbstractViewManager.BuildInfo(buildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), buildEvent.getEventTime());
            this.k.put(buildEvent.getId(), buildInfo);
        } else if (buildEvent.getParentId() != null) {
            AbstractViewManager.BuildInfo buildInfo = this.k.get(buildEvent.getParentId());
            assert (buildInfo != null);
            this.k.put(buildEvent.getId(), buildInfo);
        }
        smartList.add(() -> {
            AbstractViewManager.BuildInfo buildInfo2 = this.k.get(buildEvent.getId());
            assert (buildInfo2 != null);
            if (buildEvent instanceof StartBuildEvent) {
                RunContentDescriptor runContentDescriptor;
                StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
                buildInfo2.message = startBuildEvent.getMessage();
                DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
                defaultListModel.addElement(buildInfo2);
                BuildView buildView = this.f.computeIfAbsent(buildInfo2, buildInfo -> {
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(startBuildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), startBuildEvent.getEventTime());
                    String string = "build.toolwindow." + this.e.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, defaultBuildDescriptor, string, this.e);
                    Disposer.register((Disposable)this.i, (Disposable)buildView);
                    return buildView;
                });
                buildView.onEvent(startBuildEvent);
                this.a.setPreferredFocusedComponent(buildView::getPreferredFocusableComponent);
                Supplier<RunContentDescriptor> supplier = startBuildEvent.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor2 = runContentDescriptor = supplier != null ? supplier.get() : null;
                if (runContentDescriptor != null) {
                    boolean bl2;
                    buildInfo2.activateToolWindowWhenAdded = bl2 = runContentDescriptor.isActivateToolWindowWhenAdded();
                    if (runContentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo2.activateToolWindowWhenFailed = ((BuildContentDescriptor)runContentDescriptor).isActivateToolWindowWhenFailed();
                    }
                    boolean bl3 = runContentDescriptor.isAutoFocusContent();
                    this.myBuildContentManager.setSelectedContent(this.a, bl3, bl3, bl2, runContentDescriptor.getActivationCallback());
                    Disposer.register((Disposable)buildView, (Disposable)runContentDescriptor);
                } else {
                    this.myBuildContentManager.setSelectedContent(this.a, true, true, false, null);
                }
                buildInfo2.content = this.a;
                if (this.i.getLastComponent() == null) {
                    this.i.setLastComponent((JComponent)buildView);
                    this.e.configureToolbar(this.g, this, buildView);
                }
                if (this.b.getModel().getSize() > 1) {
                    JBScrollPane jBScrollPane = new JBScrollPane();
                    jBScrollPane.setBorder((Border)JBUI.Borders.empty());
                    jBScrollPane.setViewportView(this.b);
                    this.i.setFirstComponent((JComponent)jBScrollPane);
                    this.b.setVisible(true);
                    this.b.setSelectedIndex(0);
                    this.i.repaint();
                    for (BuildView buildView2 : this.f.values()) {
                        BuildTreeConsoleView buildTreeConsoleView = buildView2.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildTreeConsoleView == null) continue;
                        buildTreeConsoleView.hideRootNode();
                    }
                } else {
                    this.i.setFirstComponent(null);
                }
                this.e.onBuildStart(buildInfo2);
                this.h.addBuild(buildInfo2);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo2, buildInfo2.content, startBuildEvent.getProcessHandler());
            } else {
                if (buildEvent instanceof FinishBuildEvent) {
                    buildInfo2.endTime = buildEvent.getEventTime();
                    buildInfo2.message = buildEvent.getMessage();
                    buildInfo2.result = ((FinishBuildEvent)buildEvent).getResult();
                    this.h.stopBuild(buildInfo2);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo2, buildInfo2.content);
                    this.e.onBuildFinish(buildInfo2);
                } else {
                    buildInfo2.statusMessage = buildEvent.getMessage();
                }
                this.f.get(buildInfo2).onEvent(buildEvent);
            }
        });
        if (this.a == null) {
            this.d.addAll((Collection<Runnable>)smartList);
            if (this.l.compareAndSet(false, true)) {
                this.j.offer(() -> {
                    this.b.setSelectionMode(0);
                    this.b.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.b.getSelectedValue();
                            if (buildInfo == null) {
                                return;
                            }
                            BuildView buildView = (BuildView)MultipleBuildsView.this.f.get(buildInfo);
                            JComponent jComponent = MultipleBuildsView.this.i.getLastComponent();
                            if (buildView != null && jComponent != buildView.getComponent()) {
                                MultipleBuildsView.this.i.setLastComponent(buildView.getComponent());
                                buildView.getComponent().setVisible(true);
                                if (jComponent != null) {
                                    jComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.e.configureToolbar(MultipleBuildsView.this.g, MultipleBuildsView.this, buildView);
                                buildView.getComponent().repaint();
                            }
                            int n2 = MultipleBuildsView.this.i.getFirstSize();
                            int n3 = MultipleBuildsView.this.i.getLastSize();
                            if (n2 == 0 && n3 == 0) {
                                EdtInvocationManager.getInstance().invokeLater(() -> {
                                    int n2 = Math.round((float)MultipleBuildsView.this.i.getWidth() / 4.0f);
                                    MultipleBuildsView.this.i.setFirstSize(n2);
                                });
                            }
                        }
                    });
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)this.i, "Center");
                    this.g = new DefaultActionGroup();
                    jPanel.add((Component)ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.g, false).getComponent(), "West");
                    this.a = new ContentImpl((JComponent)jPanel, this.e.getViewName(), true);
                    Disposer.register((Disposable)this.a, (Disposable)this);
                    this.a.setCloseable(false);
                    Icon icon = this.e.getContentIcon();
                    if (icon != null) {
                        this.a.setIcon(icon);
                        this.a.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.a);
                    ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.d);
                    this.d.clear();
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                });
            }
        } else {
            this.j.offer(() -> MultipleBuildsView.a((List)smartList));
        }
    }

    public boolean hasRunningBuilds() {
        return !this.h.b.isEmpty();
    }

    private static /* synthetic */ void a(List list) {
        for (Runnable runnable : list) {
            runnable.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm a = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> b = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.a.cancelAllRequests();
            JComponent jComponent = MultipleBuildsView.this.i.getFirstComponent();
            if (jComponent != null) {
                jComponent.revalidate();
                jComponent.repaint();
            }
            if (!this.b.isEmpty()) {
                this.a.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.b.add(buildInfo);
            if (this.b.size() > 1) {
                this.a.cancelAllRequests();
                this.a.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.b.remove(buildInfo);
        }
    }
}

