/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.util.JdomKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0000\u001a2\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0011\u001a\u00020\fH\u0000\u00a8\u0006\u0012"}, d2={"getFilteredModuleNameList", "", "", "project", "Lcom/intellij/openapi/project/Project;", "map", "", "isExternal", "", "readByteTargetLevel", "", "parentNode", "Lorg/jdom/Element;", "result", "", "writeBytecodeTarget", "moduleNames", "element", "compiler-impl"})
public final class ExternalCompilerConfigurationStorageKt {
    @NotNull
    public static final List<String> getFilteredModuleNameList(@NotNull Project project2, @NotNull Map<String, String> map, boolean bl2) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)project2)) {
            return CollectionsKt.toList((Iterable)map.keySet());
        }
        ModuleManagerImpl moduleManagerImpl = ModuleManagerImpl.getInstanceImpl((Project)project2);
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        Iterable iterable2 = iterable = (Iterable)map.keySet();
        Collection collection = new ArrayList();
        for (Object t2 : iterable2) {
            Module module2;
            String string = (String)t2;
            boolean bl3 = moduleManagerImpl.findModuleByName(string) == null ? !bl2 : externalProjectSystemRegistry.getExternalSource(module2) != null == bl2;
            if (!bl3) continue;
            collection.add(t2);
        }
        return (List)collection;
    }

    public static final void writeBytecodeTarget(@NotNull List<String> list, @NotNull Map<String, String> map, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull(list, (String)"moduleNames");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Collections.sort(list, StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        for (String string : list) {
            Element element2 = JdomKt.element((Element)element, (String)"module");
            element2.setAttribute("name", string);
            String string2 = map.get(string);
            if (string2 == null) {
                string2 = "";
            }
            element2.setAttribute("target", string2);
        }
    }

    public static final void readByteTargetLevel(@NotNull Element element, @NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"parentNode");
        Intrinsics.checkParameterIsNotNull(map, (String)"result");
        Element element2 = element.getChild("bytecodeTargetLevel");
        if (element2 == null) {
            return;
        }
        Element element3 = element2;
        for (Element element4 : element3.getChildren("module")) {
            String string;
            String string2;
            if (element4.getAttributeValue("name") == null) {
                continue;
            }
            if (element4.getAttributeValue("target") == null) {
                continue;
            }
            map.put(string2, string);
        }
    }
}

