/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Exclude;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class CompilerExcludes
extends Generator {
    private final PatternSet a;

    public CompilerExcludes(Project project2, GenerationOptions generationOptions) {
        CompilerConfigurationImpl compilerConfigurationImpl = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        ExcludeEntryDescription[] excludeEntryDescriptionArray = compilerConfigurationImpl.getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        this.a = new PatternSet("compiler.excluded");
        for (ExcludeEntryDescription excludeEntryDescription : excludeEntryDescriptionArray) {
            String string = GenerationUtils.toRelativePath((VirtualFile)excludeEntryDescription.getVirtualFile(), (File)BuildProperties.getProjectBaseDir((Project)project2), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)generationOptions);
            if (string == null) continue;
            if (excludeEntryDescription.isFile()) {
                this.a.add((Generator)new Exclude(string));
                continue;
            }
            if (excludeEntryDescription.isIncludeSubdirectories()) {
                this.a.add((Generator)new Exclude(string + "/**"));
                continue;
            }
            this.a.add((Generator)new Exclude(string + "/*"));
        }
    }

    public void generate(PrintWriter printWriter) throws IOException {
        this.a.generate(printWriter);
    }

    public static boolean isAvailable(Project project2) {
        CompilerConfigurationImpl compilerConfigurationImpl = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        ExcludeEntryDescription[] excludeEntryDescriptionArray = compilerConfigurationImpl.getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        return excludeEntryDescriptionArray.length > 0;
    }
}

