/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class LibraryDefinitionsGeneratorFactory {
    private final ProjectEx a;
    private final GenerationOptions c;
    private final Set<String> b = new HashSet<String>();

    public LibraryDefinitionsGeneratorFactory(ProjectEx projectEx, GenerationOptions generationOptions) {
        Module[] moduleArray;
        this.a = projectEx;
        this.c = generationOptions;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)projectEx);
        for (Module module2 : moduleArray = moduleManager.getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().forEachLibrary(library -> {
                String string = library.getName();
                try {
                    if (string != null) {
                        this.b.add(string);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
                }
                return true;
            });
        }
    }

    @Nullable
    public Generator create(LibraryTable libraryTable, File file, String string) {
        Object object;
        Library[] libraryArray = libraryTable.getLibraries();
        try {
            if (libraryArray.length == 0) {
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
        }
        CompositeGenerator compositeGenerator = new CompositeGenerator();
        compositeGenerator.add((Generator)new Comment(string), 1);
        TreeMap<String, Library> treeMap = new TreeMap<String, Library>();
        for (Library library2 : libraryArray) {
            String string2 = library2.getName();
            try {
                if (!this.b.contains(string2)) {
                    continue;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
            }
            treeMap.put(BuildProperties.getLibraryPathId((String)string2), library2);
        }
        for (Library library : treeMap.values()) {
            Library library2;
            String string3 = library.getName();
            library2 = new Path(BuildProperties.getLibraryPathId((String)string3));
            LibraryDefinitionsGeneratorFactory.genLibraryContent(this.a, this.c, library, file, (CompositeGenerator)library2);
            compositeGenerator.add((Generator)library2, 1);
        }
        try {
            object = compositeGenerator.getGeneratorCount() > 0 ? compositeGenerator : null;
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
        }
        return object;
    }

    public static void genLibraryContent(ProjectEx projectEx, GenerationOptions generationOptions, Library library, File file, CompositeGenerator compositeGenerator) {
        LibraryDefinitionsGeneratorFactory.genLibraryContent(generationOptions, library, OrderRootType.CLASSES, file, compositeGenerator);
    }

    public static void genLibraryContent(GenerationOptions generationOptions, Library library, OrderRootType orderRootType, File file, CompositeGenerator compositeGenerator) {
        if (generationOptions.expandJarDirectories) {
            VirtualFile[] virtualFileArray = library.getFiles(orderRootType);
            TreeSet<String> treeSet = new TreeSet<String>();
            for (VirtualFile virtualFile : virtualFileArray) {
                String string = GenerationUtils.toRelativePath((VirtualFile)virtualFile, (File)file, (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)generationOptions);
                treeSet.add(string);
            }
            for (String string : treeSet) {
                compositeGenerator.add((Generator)new PathElement(string));
            }
        } else {
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(library.getUrls(orderRootType)));
            for (String string : treeSet) {
                block10: {
                    String string2;
                    block11: {
                        File file2 = LibraryDefinitionsGeneratorFactory.a(string);
                        string2 = GenerationUtils.toRelativePath((String)file2.getPath(), (File)file, (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)generationOptions);
                        try {
                            if (string.startsWith("jar://")) {
                                compositeGenerator.add((Generator)new PathElement(string2));
                                continue;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
                        }
                        try {
                            if (!string.startsWith("file://")) break block10;
                            if (!library.isJarDirectory(string, orderRootType)) break block11;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
                        }
                        FileSet fileSet = new FileSet(string2);
                        fileSet.add((Generator)new PatternSetRef("library.patterns"));
                        compositeGenerator.add((Generator)fileSet);
                        continue;
                    }
                    compositeGenerator.add((Generator)new PathElement(string2));
                    continue;
                }
                throw new IllegalStateException("Unknown url type: " + string);
            }
        }
    }

    private static File a(String string) {
        String string2;
        block5: {
            block4: {
                try {
                    if (!string.startsWith("jar://") || !string.endsWith("!/")) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw LibraryDefinitionsGeneratorFactory.b(illegalStateException);
                }
                string2 = string.substring("jar://".length(), string.length() - "!/".length());
                break block5;
            }
            if (string.startsWith("file://")) {
                string2 = string.substring("jar://".length());
            } else {
                throw new IllegalArgumentException("Unknown url type: " + string);
            }
        }
        return new File(string2.replace('/', File.separatorChar));
    }

    private static IllegalStateException b(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

