/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.artifacts.ArtifactAntGenerationContextImpl;
import com.intellij.compiler.ant.artifacts.CleanArtifactTarget;
import com.intellij.compiler.ant.artifacts.DirectoryAntCopyInstructionCreator;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.Delete;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ArtifactsGenerator {
    @NonNls
    public static final String BUILD_ALL_ARTIFACTS_TARGET = "build.all.artifacts";
    @NonNls
    private static final String a = "init.artifacts";
    private final PackagingElementResolvingContext c;
    private final ArtifactAntGenerationContextImpl d;
    private final List<Artifact> b;

    public ArtifactsGenerator(Project project2, GenerationOptions generationOptions) {
        this.c = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        this.b = new ArrayList<Artifact>(Arrays.asList(ArtifactManager.getInstance((Project)project2).getSortedArtifacts()));
        this.d = new ArtifactAntGenerationContextImpl(project2, generationOptions, this.b);
    }

    public boolean hasArtifacts() {
        return !this.b.isEmpty();
    }

    public List<Generator> generate() {
        ArrayList<Generator> arrayList = new ArrayList<Generator>();
        Target target = new Target(a, null, null, null);
        arrayList.add((Generator)target);
        target.add((Generator)new Property("artifacts.temp.dir", BuildProperties.propertyRelativePath((String)BuildProperties.getProjectBaseDirProperty(), (String)"__artifacts_temp")));
        for (Artifact object2 : this.b) {
            String string;
            if (!this.d.shouldBuildIntoTempDirectory(object2)) {
                arrayList.add((Generator)new CleanArtifactTarget(object2, this.d));
            }
            if (StringUtil.isEmpty((String)(string = object2.getOutputPath()))) continue;
            target.add((Generator)new Property(this.d.getConfiguredArtifactOutputProperty(object2), this.d.getSubstitutedPath(string)));
        }
        target.add((Generator)new Mkdir(BuildProperties.propertyRef((String)"artifacts.temp.dir")));
        StringBuilder stringBuilder = new StringBuilder();
        for (Artifact artifact : this.b) {
            Target target2 = this.a(artifact);
            arrayList.add((Generator)target2);
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.d.getTargetName(artifact));
        }
        for (Generator generator : this.d.getBeforeBuildGenerators()) {
            target.add(generator);
        }
        this.a(this.c.getProject(), (CompositeGenerator)target);
        Target target3 = new Target(BUILD_ALL_ARTIFACTS_TARGET, stringBuilder.toString(), "Build all artifacts", null);
        for (Artifact artifact : this.b) {
            String string = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)string) || !this.d.shouldBuildIntoTempDirectory(artifact)) continue;
            String string2 = BuildProperties.propertyRef((String)this.d.getConfiguredArtifactOutputProperty(artifact));
            target3.add((Generator)new Mkdir(string2));
            Copy copy = new Copy(string2);
            copy.add((Generator)new FileSet(BuildProperties.propertyRef((String)this.d.getArtifactOutputProperty(artifact))));
            target3.add((Generator)copy);
        }
        target3.add((Generator)new Comment("Delete temporary files"), 1);
        for (Generator generator : this.d.getAfterBuildGenerators()) {
            target3.add(generator);
        }
        target3.add((Generator)new Delete(BuildProperties.propertyRef((String)"artifacts.temp.dir")));
        arrayList.add((Generator)target3);
        return arrayList;
    }

    private Target a(Artifact artifact) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(a);
        ArtifactUtil.processRecursivelySkippingIncludedArtifacts(artifact, packagingElement -> {
            Module module2;
            if (packagingElement instanceof ArtifactPackagingElement) {
                Artifact artifact = ((ArtifactPackagingElement)((Object)packagingElement)).findArtifact(this.c);
                if (artifact != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.d.getTargetName(artifact));
                }
            } else if (packagingElement instanceof ModuleOutputPackagingElement && (module2 = ((ModuleOutputPackagingElement)packagingElement).findModule(this.c)) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(BuildProperties.getCompileTargetName((String)module2.getName()));
            }
            return true;
        }, this.c);
        Couple<String> couple = ArtifactsGenerator.a(artifact.getArtifactType());
        Target target = new Target(this.d.getTargetName(artifact), stringBuilder.toString(), "Build '" + artifact.getName() + "' artifact", null, couple != null ? (String)couple.first : null, couple != null ? (String)couple.second : null);
        if (this.d.shouldBuildIntoTempDirectory(artifact)) {
            string = BuildProperties.propertyRelativePath((String)"artifacts.temp.dir", (String)FileUtil.sanitizeFileName((String)artifact.getName()));
            target.add((Generator)new Property(this.d.getArtifactOutputProperty(artifact), string));
        }
        string = BuildProperties.propertyRef((String)this.d.getArtifactOutputProperty(artifact));
        target.add((Generator)new Mkdir(string));
        this.a(artifact, target, true);
        DirectoryAntCopyInstructionCreator directoryAntCopyInstructionCreator = new DirectoryAntCopyInstructionCreator(string);
        ArrayList arrayList = new ArrayList();
        if (ArtifactsGenerator.b(artifact.getArtifactType())) {
            arrayList.addAll(artifact.getRootElement().computeAntInstructions(this.c, (AntCopyInstructionCreator)directoryAntCopyInstructionCreator, (ArtifactAntGenerationContext)this.d, artifact.getArtifactType()));
        }
        for (Generator generator : this.d.getAndClearBeforeCurrentArtifact()) {
            target.add(generator);
        }
        for (Generator generator : arrayList) {
            target.add(generator);
        }
        this.a(artifact, target, false);
        return target;
    }

    private void a(Artifact artifact, Target target, boolean bl2) {
        for (ChunkBuildExtension chunkBuildExtension : (ChunkBuildExtension[])ChunkBuildExtension.EP_NAME.getExtensions()) {
            chunkBuildExtension.generateTasksForArtifact(artifact, bl2, (ArtifactAntGenerationContext)this.d, (CompositeGenerator)target);
        }
    }

    private void a(Project project2, CompositeGenerator compositeGenerator) {
        for (ChunkBuildExtension chunkBuildExtension : (ChunkBuildExtension[])ChunkBuildExtension.EP_NAME.getExtensions()) {
            chunkBuildExtension.initArtifacts(project2, this.d.getGenerationOptions(), compositeGenerator);
        }
    }

    private static Couple<String> a(ArtifactType artifactType) {
        for (ChunkBuildExtension chunkBuildExtension : (ChunkBuildExtension[])ChunkBuildExtension.EP_NAME.getExtensions()) {
            Couple couple = chunkBuildExtension.getArtifactXmlNs(artifactType);
            if (couple == null) continue;
            return couple;
        }
        return null;
    }

    private static boolean b(ArtifactType artifactType) {
        for (ChunkBuildExtension chunkBuildExtension : (ChunkBuildExtension[])ChunkBuildExtension.EP_NAME.getExtensions()) {
            if (chunkBuildExtension.needAntArtifactInstructions(artifactType)) continue;
            return false;
        }
        return true;
    }

    public List<String> getCleanTargetNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Artifact artifact : this.b) {
            if (this.d.shouldBuildIntoTempDirectory(artifact)) continue;
            arrayList.add(this.d.getCleanTargetName(artifact));
        }
        return arrayList;
    }
}

