/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

class ExcludeFromCompileAction
extends AnAction {
    private final Project a;
    private final NewErrorTreeViewPanel b;

    public ExcludeFromCompileAction(Project project2, NewErrorTreeViewPanel newErrorTreeViewPanel) {
        super(CompilerBundle.message((String)"actions.exclude.from.compile.text", (Object[])new Object[0]));
        this.a = project2;
        this.b = newErrorTreeViewPanel;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        VirtualFile virtualFile = this.a();
        if (virtualFile != null && virtualFile.isValid()) {
            ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(virtualFile, false, true, (Disposable)this.a);
            CompilerConfiguration.getInstance((Project)this.a).getExcludedEntriesConfiguration().addExcludeEntryDescription(excludeEntryDescription);
            FileStatusManager.getInstance((Project)this.a).fileStatusesChanged();
        }
    }

    @Nullable
    private VirtualFile a() {
        NodeDescriptor nodeDescriptor;
        ErrorTreeElement errorTreeElement;
        ErrorTreeNodeDescriptor errorTreeNodeDescriptor = this.b.getSelectedNodeDescriptor();
        ErrorTreeElement errorTreeElement2 = errorTreeElement = errorTreeNodeDescriptor != null ? errorTreeNodeDescriptor.getElement() : null;
        if (errorTreeElement != null && !(errorTreeElement instanceof GroupingElement) && (nodeDescriptor = errorTreeNodeDescriptor.getParentDescriptor()) instanceof ErrorTreeNodeDescriptor) {
            errorTreeElement = ((ErrorTreeNodeDescriptor)nodeDescriptor).getElement();
        }
        return errorTreeElement instanceof GroupingElement ? ((GroupingElement)errorTreeElement).getFile() : null;
    }

    public void update(AnActionEvent anActionEvent) {
        Presentation presentation = anActionEvent.getPresentation();
        boolean bl2 = this.a() != null;
        presentation.setEnabled(bl2);
        presentation.setVisible(bl2);
    }
}

