/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class FileProcessingCompilerStateCache {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.compiler.impl.FileProcessingCompilerStateCache");
    private final StateCache<MyState> a;

    public FileProcessingCompilerStateCache(File file, final ValidityStateFactory validityStateFactory) throws IOException {
        this.a = new StateCache<MyState>(new File(file, "timestamps")){

            @Override
            public MyState read(DataInput dataInput) throws IOException {
                return new MyState(dataInput.readLong(), validityStateFactory.createValidityState(dataInput));
            }

            @Override
            public void write(MyState myState, DataOutput dataOutput) throws IOException {
                dataOutput.writeLong(myState.getTimestamp());
                ValidityState validityState = myState.getExtState();
                try {
                    if (validityState != null) {
                        validityState.save(dataOutput);
                    }
                }
                catch (IOException iOException) {
                    throw 1.c(iOException);
                }
            }

            private static IOException c(IOException iOException) {
                return iOException;
            }
        };
    }

    public void update(VirtualFile virtualFile, ValidityState validityState) throws IOException {
        try {
            if (virtualFile.isValid()) {
                this.a.update(virtualFile.getUrl(), new MyState(virtualFile.getTimeStamp(), validityState));
            }
        }
        catch (IOException iOException) {
            throw FileProcessingCompilerStateCache.b(iOException);
        }
    }

    public void remove(String string) throws IOException {
        this.a.remove(string);
    }

    public long getTimestamp(String string) throws IOException {
        long l2;
        Serializable serializable = this.a.getState(string);
        try {
            if (serializable != null) {
                b.assertTrue(serializable instanceof MyState);
            }
        }
        catch (IOException iOException) {
            throw FileProcessingCompilerStateCache.b(iOException);
        }
        MyState myState = (MyState)serializable;
        try {
            l2 = myState != null ? myState.getTimestamp() : -1L;
        }
        catch (IOException iOException) {
            throw FileProcessingCompilerStateCache.b(iOException);
        }
        return l2;
    }

    public ValidityState getExtState(String string) throws IOException {
        ValidityState validityState;
        MyState myState = this.a.getState(string);
        try {
            validityState = myState != null ? myState.getExtState() : null;
        }
        catch (IOException iOException) {
            throw FileProcessingCompilerStateCache.b(iOException);
        }
        return validityState;
    }

    public void force() {
        this.a.force();
    }

    public Collection<String> getUrls() throws IOException {
        return this.a.getUrls();
    }

    public boolean wipe() {
        return this.a.wipe();
    }

    public void close() {
        try {
            this.a.close();
        }
        catch (IOException iOException) {
            b.info((Throwable)iOException);
        }
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }

    private static class MyState
    implements Serializable {
        private final long a;
        private final ValidityState b;

        public MyState(long l2, @Nullable ValidityState validityState) {
            this.a = l2;
            this.b = validityState;
        }

        public long getTimestamp() {
            return this.a;
        }

        @Nullable
        public ValidityState getExtState() {
            return this.b;
        }
    }
}

