/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.HashMap;
import java.util.Map;

@State(name="ValidationConfiguration", storages={@Storage(value="validation.xml")})
public class ValidationConfiguration
implements PersistentStateComponent<ValidationConfiguration> {
    public boolean VALIDATE_ON_BUILD = false;
    public Map<String, Boolean> VALIDATORS = new HashMap<String, Boolean>();

    public static boolean shouldValidate(Compiler compiler, CompileContext compileContext) {
        ValidationConfiguration validationConfiguration = ValidationConfiguration.getInstance(compileContext.getProject());
        return validationConfiguration.VALIDATE_ON_BUILD && validationConfiguration.isSelected(compiler);
    }

    public boolean isSelected(Compiler compiler) {
        return this.isSelected(compiler.getDescription());
    }

    public boolean isSelected(String string) {
        Boolean bl2 = this.VALIDATORS.get(string);
        return bl2 == null || bl2 != false;
    }

    public void setSelected(Compiler compiler, boolean bl2) {
        this.setSelected(compiler.getDescription(), bl2);
    }

    public void setSelected(String string, boolean bl2) {
        this.VALIDATORS.put(string, bl2);
    }

    public static ValidationConfiguration getInstance(Project project2) {
        return (ValidationConfiguration)ServiceManager.getService((Project)project2, ValidationConfiguration.class);
    }

    public static ExcludesConfiguration getExcludedEntriesConfiguration(Project project2) {
        return (ExcludesConfiguration)ServiceManager.getService((Project)project2, ExcludedFromValidationConfiguration.class);
    }

    public ValidationConfiguration getState() {
        return this;
    }

    public void loadState(ValidationConfiguration validationConfiguration) {
        XmlSerializerUtil.copyBean((Object)validationConfiguration, (Object)this);
    }

    @State(name="ExcludeFromValidation", storages={@Storage(value="excludeFromValidation.xml")})
    public static class ExcludedFromValidationConfiguration
    extends ExcludedEntriesConfiguration {
        public ExcludedFromValidationConfiguration() {
            super(null);
        }
    }
}

