/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import java.io.File;
import java.util.List;
import org.junit.Assert;

public class ProjectConversionTestUtil {
    private ProjectConversionTestUtil() {
    }

    public static void assertNoConversionNeeded(String string) {
        MyConversionListener myConversionListener = new MyConversionListener();
        ConversionResult conversionResult = ConversionService.getInstance().convertSilently(string, (ConversionListener)myConversionListener);
        Assert.assertTrue((boolean)conversionResult.conversionNotNeeded());
        Assert.assertFalse((boolean)myConversionListener.isConversionNeeded());
        Assert.assertFalse((boolean)myConversionListener.isConverted());
    }

    public static void convert(String string) {
        MyConversionListener myConversionListener = new MyConversionListener();
        ConversionResult conversionResult = ConversionService.getInstance().convertSilently(string, (ConversionListener)myConversionListener);
        Assert.assertFalse((boolean)conversionResult.conversionNotNeeded());
        Assert.assertFalse((boolean)conversionResult.openingIsCanceled());
        Assert.assertTrue((boolean)myConversionListener.isConversionNeeded());
        Assert.assertTrue((boolean)myConversionListener.isConverted());
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean a;
        private boolean b;

        public void conversionNeeded() {
            this.a = true;
        }

        public void successfullyConverted(File file) {
            this.b = true;
        }

        public void error(String string) {
            Assert.fail((String)string);
        }

        public void cannotWriteToFiles(List<File> list) {
        }

        public boolean isConversionNeeded() {
            return this.a;
        }

        public boolean isConverted() {
            return this.b;
        }
    }
}

