/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import org.jdom.Element;

@Tag(value="instance-filter")
public class InstanceFilter
implements JDOMExternalizable {
    public static final InstanceFilter[] EMPTY_ARRAY = new InstanceFilter[0];
    @Attribute(value="id")
    public long ID = 0L;
    @Attribute(value="enabled")
    public boolean ENABLED = true;

    public InstanceFilter() {
    }

    protected InstanceFilter(long l2, boolean bl2) {
        this.ID = l2;
        this.ENABLED = bl2;
    }

    @Transient
    public long getId() {
        return this.ID;
    }

    @Transient
    public boolean isEnabled() {
        return this.ENABLED;
    }

    public void setId(long l2) {
        this.ID = l2;
    }

    public void setEnabled(boolean bl2) {
        this.ENABLED = bl2;
    }

    public static InstanceFilter create(String string) {
        return new InstanceFilter(Long.parseLong(string), true);
    }

    public static InstanceFilter create(ClassFilter classFilter) {
        return new InstanceFilter(Long.parseLong(classFilter.getPattern()), classFilter.isEnabled());
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public static ClassFilter[] createClassFilters(InstanceFilter[] instanceFilterArray) {
        ClassFilter[] classFilterArray = new ClassFilter[instanceFilterArray.length];
        for (int i2 = 0; i2 < classFilterArray.length; ++i2) {
            InstanceFilter instanceFilter = instanceFilterArray[i2];
            ClassFilter classFilter = new ClassFilter();
            classFilter.setEnabled(instanceFilter.isEnabled());
            classFilter.setPattern(Long.toString(instanceFilter.getId()));
            classFilterArray[i2] = classFilter;
        }
        return classFilterArray;
    }

    public boolean equals(Object object) {
        block13: {
            try {
                if (this == object) {
                    return true;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw InstanceFilter.b(invalidDataException);
            }
            try {
                try {
                    if (object != null && this.getClass() == object.getClass()) break block13;
                }
                catch (InvalidDataException invalidDataException) {
                    throw InstanceFilter.b(invalidDataException);
                }
                return false;
            }
            catch (InvalidDataException invalidDataException) {
                throw InstanceFilter.b(invalidDataException);
            }
        }
        InstanceFilter instanceFilter = (InstanceFilter)object;
        try {
            if (this.ID != instanceFilter.ID) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw InstanceFilter.b(invalidDataException);
        }
        try {
            if (this.ENABLED != instanceFilter.ENABLED) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw InstanceFilter.b(invalidDataException);
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.ID, this.ENABLED);
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

