/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;

public class AddSteppingFilterAction
extends DebuggerAction {
    public void actionPerformed(final AnActionEvent anActionEvent) {
        final DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        final StackFrameProxyImpl stackFrameProxyImpl = PopFrameAction.getStackFrameProxy(anActionEvent);
        debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                StackFrameProxyImpl stackFrameProxyImpl2;
                try {
                    stackFrameProxyImpl2 = stackFrameProxyImpl != null ? stackFrameProxyImpl : debuggerContextImpl.getFrameProxy();
                }
                catch (Exception exception) {
                    throw 1.b(exception);
                }
                String string = AddSteppingFilterAction.a(stackFrameProxyImpl2);
                try {
                    if (string == null) {
                        return;
                    }
                }
                catch (Exception exception) {
                    throw 1.b(exception);
                }
                Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String string2 = Messages.showInputDialog((Project)project2, (String)"", (String)"Add Stepping Filter", null, (String)string, null);
                    if (string2 != null) {
                        ClassFilter[] classFilterArray = (ClassFilter[])ArrayUtil.append((Object[])DebuggerSettings.getInstance().getSteppingFilters(), (Object)new ClassFilter(string2));
                        DebuggerSettings.getInstance().setSteppingFilters(classFilterArray);
                    }
                });
            }

            private static Exception b(Exception exception) {
                return exception;
            }
        });
    }

    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setEnabledAndVisible(PopFrameAction.getStackFrameProxy(anActionEvent) != null);
    }

    private static String a(StackFrameProxyImpl stackFrameProxyImpl) {
        if (stackFrameProxyImpl != null) {
            try {
                ReferenceType referenceType;
                Location location = stackFrameProxyImpl.location();
                if (location != null && (referenceType = location.declaringType()) != null) {
                    return referenceType.name();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }
}

