/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;

public class ResumeThreadAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = ResumeThreadAction.getSelectedNodes(anActionEvent.getDataContext());
        DebuggerContextImpl debuggerContextImpl = ResumeThreadAction.getDebuggerContext(anActionEvent.getDataContext());
        final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        for (final DebuggerTreeNodeImpl debuggerTreeNodeImpl : debuggerTreeNodeImplArray) {
            ThreadDescriptorImpl threadDescriptorImpl = (ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor();
            if (!threadDescriptorImpl.isSuspended()) continue;
            final ThreadReferenceProxyImpl threadReferenceProxyImpl = threadDescriptorImpl.getThreadReference();
            debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendContextImpl = SuspendManagerUtil.getSuspendingContext(debugProcessImpl.getSuspendManager(), threadReferenceProxyImpl);
                    try {
                        if (suspendContextImpl != null) {
                            debugProcessImpl.createResumeThreadCommand(suspendContextImpl, threadReferenceProxyImpl).run();
                        }
                    }
                    catch (Exception exception) {
                        throw 1.b(exception);
                    }
                    debuggerTreeNodeImpl.calcValue();
                }

                private static Exception b(Exception exception) {
                    return exception;
                }
            });
        }
    }

    public void update(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = ResumeThreadAction.getSelectedNodes(anActionEvent.getDataContext());
        boolean bl2 = false;
        boolean bl3 = false;
        String string = DebuggerBundle.message((String)"action.resume.thread.text.resume", (Object[])new Object[0]);
        if (debuggerTreeNodeImplArray != null && debuggerTreeNodeImplArray.length > 0) {
            bl2 = true;
            bl3 = true;
            for (DebuggerTreeNodeImpl debuggerTreeNodeImpl : debuggerTreeNodeImplArray) {
                NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
                if (nodeDescriptorImpl instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)nodeDescriptorImpl).isSuspended()) continue;
                bl2 = false;
                break;
            }
        }
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray2 = anActionEvent.getPresentation();
        debuggerTreeNodeImplArray2.setText(string);
        debuggerTreeNodeImplArray2.setVisible(bl2);
        debuggerTreeNodeImplArray2.setEnabled(bl3);
    }
}

