/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Location;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ContextUtil {
    public static final Key<Boolean> IS_JSP_IMPLICIT = new Key("JspImplicit");
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.PositionUtil");

    @Nullable
    public static SourcePosition getSourcePosition(@Nullable StackFrameContext stackFrameContext) {
        try {
            if (stackFrameContext == null) {
                return null;
            }
        }
        catch (Throwable throwable) {
            throw ContextUtil.b(throwable);
        }
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)stackFrameContext.getDebugProcess();
        try {
            if (debugProcessImpl == null) {
                return null;
            }
        }
        catch (Throwable throwable) {
            throw ContextUtil.b(throwable);
        }
        StackFrameProxy stackFrameProxy = stackFrameContext.getFrameProxy();
        try {
            if (stackFrameProxy == null) {
                return null;
            }
        }
        catch (Throwable throwable) {
            throw ContextUtil.b(throwable);
        }
        Location location = null;
        try {
            location = stackFrameProxy.location();
        }
        catch (Throwable throwable) {
            a.debug(throwable);
        }
        try {
            if (location == null) {
                return null;
            }
        }
        catch (Throwable throwable) {
            throw ContextUtil.b(throwable);
        }
        return debugProcessImpl.getPositionManager().getSourcePosition(location);
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext stackFrameContext) {
        return ContextUtil.getContextElement(stackFrameContext, ContextUtil.getSourcePosition(stackFrameContext));
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext stackFrameContext, SourcePosition sourcePosition) {
        if (a.isDebugEnabled()) {
            SourcePosition sourcePosition2 = ContextUtil.getSourcePosition(stackFrameContext);
            a.assertTrue(Comparing.equal((Object)sourcePosition2, (Object)sourcePosition));
        }
        return (PsiElement)ReadAction.compute(() -> {
            PsiElement psiElement = ContextUtil.getContextElement(sourcePosition);
            try {
                if (psiElement == null) {
                    return null;
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw ContextUtil.b(incorrectOperationException);
            }
            try {
                if (psiElement.getLanguage().getAssociatedFileType() != DefaultCodeFragmentFactory.getInstance().getFileType()) {
                    return psiElement;
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw ContextUtil.b(incorrectOperationException);
            }
            StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)stackFrameContext.getFrameProxy();
            try {
                if (stackFrameProxyImpl == null) {
                    return psiElement;
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw ContextUtil.b(incorrectOperationException);
            }
            try {
                PsiStatement[] psiStatementArray;
                LocalVariableProxyImpl localVariableProxyImpl2;
                List<LocalVariableProxyImpl> list = stackFrameProxyImpl.visibleVariables();
                PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getResolveHelper();
                StringBuilder stringBuilder = null;
                for (LocalVariableProxyImpl localVariableProxyImpl2 : list) {
                    block17: {
                        psiStatementArray = localVariableProxyImpl2.name();
                        try {
                            if (psiResolveHelper.resolveReferencedVariable((String)psiStatementArray, psiElement) != null) continue;
                            if (stringBuilder != null) break block17;
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw ContextUtil.b(incorrectOperationException);
                        }
                        stringBuilder = new StringBuilder("{");
                    }
                    stringBuilder.append(localVariableProxyImpl2.getVariable().typeName()).append(" ").append((String)psiStatementArray).append(";");
                }
                if (stringBuilder == null) {
                    return psiElement;
                }
                stringBuilder.append('}');
                PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory();
                localVariableProxyImpl2 = psiElementFactory.createCodeBlockFromText(stringBuilder.toString(), psiElement);
                for (PsiStatement psiStatement : psiStatementArray = localVariableProxyImpl2.getStatements()) {
                    PsiElement[] psiElementArray;
                    if (!(psiStatement instanceof PsiDeclarationStatement)) continue;
                    PsiDeclarationStatement psiDeclarationStatement = (PsiDeclarationStatement)psiStatement;
                    for (PsiElement psiElement2 : psiElementArray = psiDeclarationStatement.getDeclaredElements()) {
                        psiElement2.putUserData(IS_JSP_IMPLICIT, (Object)Boolean.TRUE);
                    }
                }
                return localVariableProxyImpl2;
            }
            catch (EvaluateException | IncorrectOperationException throwable) {
                return psiElement;
            }
        });
    }

    @Nullable
    public static PsiElement getContextElement(@Nullable SourcePosition sourcePosition) {
        PsiElement psiElement;
        try {
            psiElement = sourcePosition == null ? null : sourcePosition.getElementAt();
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw ContextUtil.b(incorrectOperationException);
        }
        return psiElement;
    }

    public static boolean isJspImplicit(PsiElement psiElement) {
        return Boolean.TRUE.equals(psiElement.getUserData(IS_JSP_IMPLICIT));
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }
}

