/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugProcessEvents
extends DebugProcessImpl {
    private static final Logger z = Logger.getInstance(DebugProcessEvents.class);
    private static final String A = "REQUEST_HANDLER";
    private DebuggerEventThread y;
    private AtomicBoolean B = new AtomicBoolean();

    public DebugProcessEvents(Project project2) {
        super(project2);
        DebuggerSettings.getInstance().addCapturePointsSettingsListener(this::g, this.myDisposable);
    }

    @Override
    protected void commitVM(VirtualMachine virtualMachine) {
        try {
            super.commitVM(virtualMachine);
            if (virtualMachine != null) {
                this.h();
                this.y = new DebuggerEventThread();
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.y);
            }
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
    }

    private static void a(DebugProcessEvents debugProcessEvents, Event event) {
        Requestor requestor = debugProcessEvents.getRequestsManager().findRequestor(event.request());
        Breakpoint breakpoint = null;
        if (requestor instanceof Breakpoint) {
            breakpoint = (Breakpoint)requestor;
        }
        String string = debugProcessEvents.getEventText((Pair<Breakpoint, Event>)Pair.create((Object)breakpoint, (Object)event));
        debugProcessEvents.showStatusText(string);
    }

    public String getEventText(Pair<Breakpoint, Event> pair2) {
        String string = "";
        Event event = (Event)pair2.getSecond();
        Breakpoint breakpoint = (Breakpoint)pair2.getFirst();
        if (event instanceof LocatableEvent) {
            try {
                String string2;
                try {
                    string2 = breakpoint != null ? breakpoint.getEventMessage((LocatableEvent)event) : DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
                }
                catch (InternalException internalException) {
                    throw DebugProcessEvents.b(internalException);
                }
                string = string2;
            }
            catch (InternalException internalException) {
                string = DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
        } else if (event instanceof VMStartEvent) {
            string = DebuggerBundle.message((String)"status.process.started", (Object[])new Object[0]);
        } else if (event instanceof VMDeathEvent) {
            string = DebuggerBundle.message((String)"status.process.terminated", (Object[])new Object[0]);
        } else if (event instanceof VMDisconnectEvent) {
            RemoteConnection remoteConnection = this.getConnection();
            String string3 = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
            String string4 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
            string = DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{string3, string4});
        }
        return string;
    }

    private static void a(SuspendContextImpl suspendContextImpl, ThreadReference threadReference) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        try {
            suspendContextImpl.setThread(threadReference);
            if (threadReferenceProxyImpl == null) {
                suspendContextImpl.getDebugProcess().beforeSuspend(suspendContextImpl);
            }
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
    }

    private static Consumer<Event> c(Event event) {
        Object object;
        EventRequest eventRequest = event.request();
        try {
            object = eventRequest != null ? eventRequest.getProperty(A) : null;
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
        Object object2 = object;
        try {
            if (object2 instanceof Consumer) {
                return (Consumer)object2;
            }
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
        return null;
    }

    private static void a(EventRequest eventRequest, Consumer<Event> consumer) {
        eventRequest.setSuspendPolicy(0);
        eventRequest.putProperty(A, consumer);
        eventRequest.enable();
    }

    private void a(SuspendContextImpl suspendContextImpl, VMStartEvent vMStartEvent) {
        DebugProcessEvents.a(suspendContextImpl, vMStartEvent.thread());
        z.debug("enter: processVMStartEvent()");
        DebugProcessEvents.a(this, vMStartEvent);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    private void h() {
        boolean bl2;
        Logger logger;
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            logger = z;
            bl2 = !this.isAttached();
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
        logger.assertTrue(bl2);
        if (this.myState.compareAndSet(DebugProcessImpl.State.INITIAL, DebugProcessImpl.State.ATTACHED)) {
            VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachineProxy();
            EventRequestManager eventRequestManager = virtualMachineProxyImpl.eventRequestManager();
            try {
                if (virtualMachineProxyImpl.canGetMethodReturnValues()) {
                    this.myReturnValueWatcher = new MethodReturnValueWatcher(eventRequestManager, this);
                }
            }
            catch (InternalException internalException) {
                throw DebugProcessEvents.b(internalException);
            }
            DebugProcessEvents.a(eventRequestManager.createThreadStartRequest(), (Consumer<Event>)((Consumer)event -> {
                ThreadReference threadReference = ((ThreadStartEvent)event).thread();
                this.getVirtualMachineProxy().threadStarted(threadReference);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStarted((DebugProcess)this, threadReference);
            }));
            DebugProcessEvents.a(eventRequestManager.createThreadDeathRequest(), (Consumer<Event>)((Consumer)event -> {
                ThreadReference threadReference = ((ThreadDeathEvent)event).thread();
                this.getVirtualMachineProxy().threadStopped(threadReference);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStopped((DebugProcess)this, threadReference);
            }));
            ((DebuggerManagerImpl)DebuggerManager.getInstance((Project)this.getProject())).getCustomPositionManagerFactories().map(function -> (PositionManager)function.fun((Object)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            Stream.of(Extensions.getExtensions((ExtensionPointName)PositionManagerFactory.EP_NAME, (AreaInstance)this.getProject())).map(positionManagerFactory -> positionManagerFactory.createPositionManager((DebugProcess)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processAttached((DebugProcess)this);
            this.g();
            ApplicationManager.getApplication().runReadAction(() -> {
                XDebugSession xDebugSession = this.getSession().getXDebugSession();
                try {
                    if (xDebugSession != null) {
                        xDebugSession.initBreakpoints();
                    }
                }
                catch (InternalException internalException) {
                    throw DebugProcessEvents.b(internalException);
                }
            });
            String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)this.getConnection());
            String string2 = DebuggerBundle.getTransportName((RemoteConnection)this.getConnection());
            this.showStatusText(DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{string, string2}));
            z.debug("leave: processVMStartEvent()");
        }
    }

    private void g() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void action() {
                StackCapturingLineBreakpoint.deleteAll(DebugProcessEvents.this);
                StackCapturingLineBreakpoint.createAll(DebugProcessEvents.this);
            }
        });
    }

    /*
     * Loose catch block
     */
    private void a(SuspendContextImpl suspendContextImpl, @Nullable Event event) {
        block12: {
            block14: {
                block13: {
                    if (!this.isAttached()) break block12;
                    try {
                        block15: {
                            if (event == null) break block13;
                            break block15;
                            catch (InternalException internalException) {
                                throw DebugProcessEvents.b(internalException);
                            }
                        }
                        if (this.getVirtualMachineProxy().getVirtualMachine() != event.virtualMachine()) break block12;
                    }
                    catch (InternalException internalException) {
                        throw DebugProcessEvents.b(internalException);
                    }
                }
                try {
                    DebugProcessEvents.a(suspendContextImpl, null);
                    this.cancelRunToCursorBreakpoint();
                    if (this.y == null) break block14;
                    this.y.stopListening();
                    this.y = null;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.y != null) {
                            this.y.stopListening();
                            this.y = null;
                        }
                    }
                    catch (InternalException internalException) {
                        throw DebugProcessEvents.b(internalException);
                    }
                    this.closeProcess(false);
                    throw throwable;
                }
            }
            this.closeProcess(false);
        }
        try {
            if (event != null) {
                DebugProcessEvents.a(this, event);
            }
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, ClassPrepareEvent classPrepareEvent) {
        try {
            DebugProcessEvents.a(suspendContextImpl, classPrepareEvent.thread());
            if (z.isDebugEnabled()) {
                z.debug("Class prepared: " + classPrepareEvent.referenceType().name());
            }
        }
        catch (InternalException internalException) {
            throw DebugProcessEvents.b(internalException);
        }
        suspendContextImpl.getDebugProcess().getRequestsManager().processClassPrepared(classPrepareEvent);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    private void a(SuspendContextImpl suspendContextImpl, StepEvent stepEvent) {
        block22: {
            Object object;
            Project project2;
            RequestHint requestHint;
            block21: {
                boolean bl2;
                block20: {
                    ThreadReference threadReference = stepEvent.thread();
                    DebugProcessEvents.a(suspendContextImpl, threadReference);
                    requestHint = (RequestHint)stepEvent.request().getProperty("hint");
                    this.deleteStepRequests(stepEvent.thread());
                    bl2 = false;
                    project2 = this.getProject();
                    if (requestHint != null) {
                        int n2 = requestHint.getNextStepDepth(suspendContextImpl);
                        if (n2 == -100) {
                            this.getSession().clearSteppingThrough();
                            bl2 = true;
                        } else if (n2 != 0) {
                            object = suspendContextImpl.getThread();
                            this.doStep(suspendContextImpl, (ThreadReferenceProxyImpl)object, requestHint.getSize(), n2, requestHint);
                            bl2 = true;
                        }
                        try {
                            try {
                                if (bl2 || !requestHint.isRestoreBreakpoints()) break block20;
                            }
                            catch (InternalException internalException) {
                                throw DebugProcessEvents.b(internalException);
                            }
                            DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().enableBreakpoints(this);
                        }
                        catch (InternalException internalException) {
                            throw DebugProcessEvents.b(internalException);
                        }
                    }
                }
                try {
                    if (!bl2) break block21;
                    this.getSuspendManager().voteResume(suspendContextImpl);
                    break block22;
                }
                catch (InternalException internalException) {
                    throw DebugProcessEvents.b(internalException);
                }
            }
            try {
                this.showStatusText("");
                if (this.myReturnValueWatcher != null) {
                    this.myReturnValueWatcher.disable();
                }
            }
            catch (InternalException internalException) {
                throw DebugProcessEvents.b(internalException);
            }
            this.getSuspendManager().voteSuspend(suspendContextImpl);
            if (requestHint != null) {
                block23: {
                    MethodFilter methodFilter = requestHint.getMethodFilter();
                    try {
                        if (!(methodFilter instanceof NamedMethodFilter) || requestHint.wasStepTargetMethodMatched()) break block23;
                    }
                    catch (InternalException internalException) {
                        throw DebugProcessEvents.b(internalException);
                    }
                    object = "Method <b>" + ((NamedMethodFilter)methodFilter).getMethodName() + "()</b> has not been called";
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification((String)object, MessageType.INFO).notify(project2);
                }
                try {
                    try {
                        if (!requestHint.wasStepTargetMethodMatched() || !requestHint.isResetIgnoreFilters()) break block22;
                    }
                    catch (InternalException internalException) {
                        throw DebugProcessEvents.b(internalException);
                    }
                    this.checkPositionNotFiltered(suspendContextImpl.getThread(), (Consumer<List<ClassFilter>>)((Consumer)list -> this.mySession.resetIgnoreStepFiltersFlag()));
                }
                catch (InternalException internalException) {
                    throw DebugProcessEvents.b(internalException);
                }
            }
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, final LocatableEvent locatableEvent) {
        ThreadReference threadReference = locatableEvent.thread();
        DebugProcessEvents.a(suspendContextImpl, threadReference);
        this.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void contextAction(@NotNull SuspendContextImpl var1_1) throws Exception {
                block75: {
                    block74: {
                        block73: {
                            block64: {
                                block66: {
                                    block65: {
                                        block80: {
                                            block63: {
                                                block62: {
                                                    block61: {
                                                        block60: {
                                                            block59: {
                                                                block58: {
                                                                    block57: {
                                                                        try {
                                                                            if (var1_1 == null) {
                                                                                2.b(0);
                                                                            }
                                                                        }
                                                                        catch (LocatableEventRequestor.EventProcessingException v0) {
                                                                            throw 2.c(v0);
                                                                        }
                                                                        var2_2 = DebugProcessEvents.this.getSuspendManager();
                                                                        var3_3 = SuspendManagerUtil.getEvaluatingContext(var2_2, var1_1.getThread());
                                                                        if (var3_3 == null) break block57;
                                                                        try {
                                                                            block76: {
                                                                                if (DebuggerSession.enableBreakpointsDuringEvaluation()) break block57;
                                                                                break block76;
                                                                                catch (LocatableEventRequestor.EventProcessingException v1) {
                                                                                    throw 2.c(v1);
                                                                                }
                                                                            }
                                                                            DebugProcessEvents.access$200(DebugProcessEvents.this, locatableEvent);
                                                                            var2_2.voteResume(var1_1);
                                                                            return;
                                                                        }
                                                                        catch (LocatableEventRequestor.EventProcessingException v2) {
                                                                            throw 2.c(v2);
                                                                        }
                                                                    }
                                                                    var4_4 = (LocatableEventRequestor)DebugProcessEvents.this.getRequestsManager().findRequestor(locatableEvent.request());
                                                                    if (var4_4 == null) break block58;
                                                                    try {
                                                                        block77: {
                                                                            if (!"SuspendNone".equals(var4_4.getSuspendPolicy())) break block58;
                                                                            break block77;
                                                                            catch (LocatableEventRequestor.EventProcessingException v3) {
                                                                                throw 2.c(v3);
                                                                            }
                                                                        }
                                                                        v4 = true;
                                                                        break block59;
                                                                    }
                                                                    catch (LocatableEventRequestor.EventProcessingException v5) {
                                                                        throw 2.c(v5);
                                                                    }
                                                                }
                                                                v4 = false;
                                                            }
                                                            var5_5 = v4;
                                                            var6_6 = false;
                                                            if (!(var4_4 instanceof OverheadProducer)) break block60;
                                                            try {
                                                                block78: {
                                                                    if (var4_4 instanceof RunToCursorBreakpoint) break block60;
                                                                    break block78;
                                                                    catch (LocatableEventRequestor.EventProcessingException v6) {
                                                                        throw 2.c(v6);
                                                                    }
                                                                }
                                                                v7 = System.currentTimeMillis();
                                                                break block61;
                                                            }
                                                            catch (LocatableEventRequestor.EventProcessingException v8) {
                                                                throw 2.c(v8);
                                                            }
                                                        }
                                                        v7 = 0L;
                                                    }
                                                    var7_7 = v7;
                                                    if (var4_4 == null) break block62;
                                                    try {
                                                        block79: {
                                                            if (!var4_4.processLocatableEvent(this, locatableEvent)) break block62;
                                                            break block79;
                                                            catch (LocatableEventRequestor.EventProcessingException v9) {
                                                                throw 2.c(v9);
                                                            }
                                                        }
                                                        v10 = true;
                                                        break block63;
                                                    }
                                                    catch (LocatableEventRequestor.EventProcessingException v11) {
                                                        throw 2.c(v11);
                                                    }
                                                }
                                                v10 = false;
                                            }
                                            var6_6 = v10;
                                            if (var7_7 <= 0L) break block64;
                                            v12 = (OverheadProducer)var4_4;
                                            if (var6_6) ** GOTO lbl88
                                            break block80;
                                            catch (LocatableEventRequestor.EventProcessingException v13) {
                                                throw 2.c(v13);
                                            }
                                        }
                                        try {
                                            block81: {
                                                if (!(var4_4 instanceof StackCapturingLineBreakpoint)) break block65;
                                                break block81;
                                                catch (LocatableEventRequestor.EventProcessingException v14) {
                                                    throw 2.c(v14);
                                                }
                                            }
                                            v15 = 1L;
                                            break block66;
                                        }
                                        catch (LocatableEventRequestor.EventProcessingException v16) {
                                            throw 2.c(v16);
                                        }
                                    }
                                    v15 = 0L;
                                }
                                OverheadTimings.add(DebugProcessEvents.this, v12, v15, System.currentTimeMillis() - var7_7);
                                break block64;
                                catch (LocatableEventRequestor.EventProcessingException var9_8) {
                                    block68: {
                                        block67: {
                                            block82: {
                                                try {
                                                    try {
                                                        if (DebugProcessEvents.access$900().isDebugEnabled()) {
                                                            DebugProcessEvents.access$900().debug(var9_8.getMessage());
                                                        }
                                                    }
                                                    catch (LocatableEventRequestor.EventProcessingException v17) {
                                                        throw 2.c(v17);
                                                    }
                                                    var10_9 = new boolean[]{true};
                                                    DebuggerInvocationUtil.invokeAndWait(DebugProcessEvents.this.getProject(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.engine.requests.LocatableEventRequestor com.intellij.debugger.engine.requests.LocatableEventRequestor$EventProcessingException boolean[] ), ()V)(this, (LocatableEventRequestor)var4_4, (LocatableEventRequestor.EventProcessingException)var9_8, (boolean[])var10_9), ModalityState.NON_MODAL);
                                                    var6_6 = var10_9[0];
                                                    try {
                                                        v18 = var6_6 == false;
                                                    }
                                                    catch (LocatableEventRequestor.EventProcessingException v19) {
                                                        throw 2.c(v19);
                                                    }
                                                    var5_5 = v18;
                                                }
                                                catch (Throwable var11_10) {
                                                    block69: {
                                                        block72: {
                                                            block71: {
                                                                try {
                                                                    block70: {
                                                                        try {
                                                                            try {
                                                                                if (var7_7 <= 0L) break block69;
                                                                                v20 = DebugProcessEvents.this;
                                                                                v21 = (OverheadProducer)var4_4;
                                                                                if (var6_6) break block70;
                                                                            }
                                                                            catch (LocatableEventRequestor.EventProcessingException v22) {
                                                                                throw 2.c(v22);
                                                                            }
                                                                            if (!(var4_4 instanceof StackCapturingLineBreakpoint)) break block71;
                                                                        }
                                                                        catch (LocatableEventRequestor.EventProcessingException v23) {
                                                                            throw 2.c(v23);
                                                                        }
                                                                    }
                                                                    v24 = 1L;
                                                                    break block72;
                                                                }
                                                                catch (LocatableEventRequestor.EventProcessingException v25) {
                                                                    throw 2.c(v25);
                                                                }
                                                            }
                                                            v24 = 0L;
                                                        }
                                                        OverheadTimings.add(v20, v21, v24, System.currentTimeMillis() - var7_7);
                                                    }
                                                    throw var11_10;
                                                }
                                                if (var7_7 <= 0L) break block64;
                                                v26 = (OverheadProducer)var4_4;
                                                if (var6_6) ** GOTO lbl154
                                                break block82;
                                                catch (LocatableEventRequestor.EventProcessingException v27) {
                                                    throw 2.c(v27);
                                                }
                                            }
                                            try {
                                                block83: {
                                                    if (!(var4_4 instanceof StackCapturingLineBreakpoint)) break block67;
                                                    break block83;
                                                    catch (LocatableEventRequestor.EventProcessingException v28) {
                                                        throw 2.c(v28);
                                                    }
                                                }
                                                v29 = 1L;
                                                break block68;
                                            }
                                            catch (LocatableEventRequestor.EventProcessingException v30) {
                                                throw 2.c(v30);
                                            }
                                        }
                                        v29 = 0L;
                                    }
                                    OverheadTimings.add(DebugProcessEvents.this, v26, v29, System.currentTimeMillis() - var7_7);
                                }
                            }
                            try {
                                try {
                                    if (!var6_6 || !(var4_4 instanceof Breakpoint)) break block73;
                                }
                                catch (LocatableEventRequestor.EventProcessingException v31) {
                                    throw 2.c(v31);
                                }
                                ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.engine.requests.LocatableEventRequestor ), ()V)(this, (LocatableEventRequestor)var4_4));
                            }
                            catch (LocatableEventRequestor.EventProcessingException v32) {
                                throw 2.c(v32);
                            }
                        }
                        try {
                            try {
                                if (var6_6 && !var5_5) break block74;
                            }
                            catch (LocatableEventRequestor.EventProcessingException v33) {
                                throw 2.c(v33);
                            }
                            var2_2.voteResume(var1_1);
                            break block75;
                        }
                        catch (LocatableEventRequestor.EventProcessingException v34) {
                            throw 2.c(v34);
                        }
                    }
                    try {
                        if (DebugProcessEvents.this.myReturnValueWatcher != null) {
                            DebugProcessEvents.this.myReturnValueWatcher.disable();
                        }
                    }
                    catch (LocatableEventRequestor.EventProcessingException v35) {
                        throw 2.c(v35);
                    }
                    var2_2.voteSuspend(var1_1);
                    DebugProcessEvents.access$1000(DebugProcessEvents.this, locatableEvent);
                }
            }

            private /* synthetic */ void a(LocatableEventRequestor locatableEventRequestor) {
                XDebugSession xDebugSession = DebugProcessEvents.this.getSession().getXDebugSession();
                if (xDebugSession != null) {
                    XBreakpoint xBreakpoint = ((Breakpoint)locatableEventRequestor).getXBreakpoint();
                    try {
                        if (xBreakpoint != null) {
                            ((XDebugSessionImpl)xDebugSession).processDependencies(xBreakpoint);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 2.c(illegalArgumentException);
                    }
                }
            }

            private /* synthetic */ void a(LocatableEventRequestor locatableEventRequestor, LocatableEventRequestor.EventProcessingException eventProcessingException, boolean[] blArray) {
                boolean bl2;
                String string;
                try {
                    string = locatableEventRequestor instanceof Breakpoint ? ((Breakpoint)locatableEventRequestor).getDisplayName() : locatableEventRequestor.getClass().getSimpleName();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.c(illegalArgumentException);
                }
                String string2 = string;
                String string3 = DebuggerBundle.message((String)"error.evaluating.breakpoint.condition.or.action", (Object[])new Object[]{string2, eventProcessingException.getMessage()});
                try {
                    boolean[] blArray2 = blArray;
                    int n2 = 0;
                    bl2 = Messages.showYesNoDialog((Project)DebugProcessEvents.this.getProject(), (String)string3, (String)eventProcessingException.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.c(illegalArgumentException);
                }
                blArray2[n2] = bl2;
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessEvents$2", "contextAction"));
            }

            private static Exception c(Exception exception) {
                return exception;
            }
        });
    }

    private void a(@Nullable LocatableEvent locatableEvent) {
        block4: {
            try {
                try {
                    if (locatableEvent == null || !this.B.compareAndSet(false, true)) break block4;
                }
                catch (InternalException internalException) {
                    throw DebugProcessEvents.b(internalException);
                }
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.B.set(false), 1L, TimeUnit.SECONDS);
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"message.breakpoint.skipped", (Object[])new Object[]{locatableEvent.location()}), MessageType.WARNING).notify(this.getProject());
            }
            catch (InternalException internalException) {
                throw DebugProcessEvents.b(internalException);
            }
        }
    }

    @Nullable
    private static LocatableEvent a(EventSet eventSet) {
        return StreamEx.of((Collection)eventSet).select(LocatableEvent.class).findFirst().orElse(null);
    }

    private void a(SuspendContextImpl suspendContextImpl) {
        DebugProcessEvents.a(suspendContextImpl, null);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    static /* synthetic */ Consumer access$000(Event event) {
        return DebugProcessEvents.c(event);
    }

    static /* synthetic */ LocatableEvent access$100(EventSet eventSet) {
        return DebugProcessEvents.a(eventSet);
    }

    static /* synthetic */ void access$200(DebugProcessEvents debugProcessEvents, LocatableEvent locatableEvent) {
        debugProcessEvents.a(locatableEvent);
    }

    static /* synthetic */ void access$300(DebugProcessEvents debugProcessEvents, SuspendContextImpl suspendContextImpl, VMStartEvent vMStartEvent) {
        debugProcessEvents.a(suspendContextImpl, vMStartEvent);
    }

    static /* synthetic */ void access$500(DebugProcessEvents debugProcessEvents, SuspendContextImpl suspendContextImpl, ClassPrepareEvent classPrepareEvent) {
        debugProcessEvents.a(suspendContextImpl, classPrepareEvent);
    }

    static /* synthetic */ void access$600(DebugProcessEvents debugProcessEvents, SuspendContextImpl suspendContextImpl, StepEvent stepEvent) {
        debugProcessEvents.a(suspendContextImpl, stepEvent);
    }

    static /* synthetic */ void access$700(DebugProcessEvents debugProcessEvents, SuspendContextImpl suspendContextImpl, LocatableEvent locatableEvent) {
        debugProcessEvents.a(suspendContextImpl, locatableEvent);
    }

    static /* synthetic */ void access$800(DebugProcessEvents debugProcessEvents, SuspendContextImpl suspendContextImpl) {
        debugProcessEvents.a(suspendContextImpl);
    }

    static /* synthetic */ void access$1000(DebugProcessEvents debugProcessEvents, Event event) {
        DebugProcessEvents.a(debugProcessEvents, event);
    }

    private static InternalException b(InternalException internalException) {
        return internalException;
    }

    private class DebuggerEventThread
    implements Runnable {
        private final VirtualMachineProxyImpl b;
        private boolean a = false;

        DebuggerEventThread() {
            this.b = DebugProcessEvents.this.getVirtualMachineProxy();
        }

        public synchronized void stopListening() {
            this.a = true;
        }

        private synchronized boolean a() {
            return this.a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            Thread.currentThread().setName("DebugProcessEvents");
            try {
                EventQueue eventQueue = this.b.eventQueue();
                while (!this.a()) {
                    try {
                        final EventSet eventSet = eventQueue.remove();
                        DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                            @Override
                            public PrioritizedTask.Priority getPriority() {
                                return PrioritizedTask.Priority.HIGH;
                            }

                            /*
                             * Could not resolve type clashes
                             * Unable to fully structure code
                             */
                            @Override
                            protected void action() throws Exception {
                                block57: {
                                    block61: {
                                        var1_1 = 0;
                                        for (Object var3_3 : eventSet) {
                                            block55: {
                                                block59: {
                                                    if (DebugProcessEvents.this.myReturnValueWatcher == null) break block55;
                                                    if (!DebugProcessEvents.this.myReturnValueWatcher.isTrackingEnabled()) break block55;
                                                    break block59;
                                                    catch (VMDisconnectedException v0) {
                                                        throw 1.b(v0);
                                                    }
                                                }
                                                try {
                                                    block60: {
                                                        if (!DebugProcessEvents.this.myReturnValueWatcher.processEvent((Event)var3_3 /* !! */ )) break block55;
                                                        break block60;
                                                        catch (VMDisconnectedException v1) {
                                                            throw 1.b(v1);
                                                        }
                                                    }
                                                    ++var1_1;
                                                    continue;
                                                }
                                                catch (VMDisconnectedException v2) {
                                                    throw 1.b(v2);
                                                }
                                            }
                                            var4_4 = DebugProcessEvents.access$000((Event)var3_3 /* !! */ );
                                            try {
                                                if (var4_4 == null) continue;
                                                var4_4.consume(var3_3 /* !! */ );
                                                ++var1_1;
                                            }
                                            catch (VMDisconnectedException v3) {
                                                throw 1.b(v3);
                                            }
                                        }
                                        try {
                                            if (var1_1 == eventSet.size()) {
                                                eventSet.resume();
                                                return;
                                            }
                                        }
                                        catch (VMDisconnectedException v4) {
                                            throw 1.b(v4);
                                        }
                                        var2_2 = DebugProcessEvents.access$100(eventSet);
                                        if (eventSet.suspendPolicy() != 2) break block61;
                                        for (Object var4_4 : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                            block56: {
                                                block63: {
                                                    block62: {
                                                        if (var4_4.getSuspendPolicy() != 2) continue;
                                                        if (!DebugProcessImpl.isResumeOnlyCurrentThread()) break block56;
                                                        break block62;
                                                        catch (VMDisconnectedException v5) {
                                                            throw 1.b(v5);
                                                        }
                                                    }
                                                    if (var2_2 == null) break block56;
                                                    break block63;
                                                    catch (VMDisconnectedException v6) {
                                                        throw 1.b(v6);
                                                    }
                                                }
                                                try {
                                                    block64: {
                                                        if (var4_4.isEvaluating()) break block56;
                                                        break block64;
                                                        catch (VMDisconnectedException v7) {
                                                            throw 1.b(v7);
                                                        }
                                                    }
                                                    DebugProcessEvents.this.getSuspendManager().resume((SuspendContextImpl)var4_4);
                                                    continue;
                                                }
                                                catch (VMDisconnectedException v8) {
                                                    throw 1.b(v8);
                                                }
                                            }
                                            try {
                                                if (DebuggerSession.enableBreakpointsDuringEvaluation()) continue;
                                                DebugProcessEvents.access$200(DebugProcessEvents.this, var2_2);
                                                eventSet.resume();
                                                return;
                                            }
                                            catch (VMDisconnectedException v9) {
                                                throw 1.b(v9);
                                            }
                                        }
                                    }
                                    var3_3 /* !! */  = null;
                                    try {
                                        if (!DebugProcessImpl.isResumeOnlyCurrentThread() || var2_2 == null) break block57;
                                    }
                                    catch (VMDisconnectedException v10) {
                                        throw 1.b(v10);
                                    }
                                    for (Object var5_5 : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        var6_6 = DebugProcessEvents.this.getVirtualMachineProxy().getThreadReferenceProxy(var2_2.thread());
                                        try {
                                            if (var5_5.getSuspendPolicy() != 2 || !var5_5.isExplicitlyResumed(var6_6)) continue;
                                        }
                                        catch (VMDisconnectedException v11) {
                                            throw 1.b(v11);
                                        }
                                        var5_5.myResumedThreads.remove(var6_6);
                                        var3_3 /* !! */  = var5_5;
                                        var3_3 /* !! */ .myVotesToVote = eventSet.size();
                                        break;
                                    }
                                }
                                if (var3_3 /* !! */  == null) {
                                    var3_3 /* !! */  = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(eventSet);
                                }
                                for (Object var5_5 : eventSet) {
                                    try {
                                        if (DebugProcessEvents.access$000((Event)var5_5) != null) {
                                            DebugProcessEvents.this.getSuspendManager().voteResume((SuspendContextImpl)var3_3 /* !! */ );
                                            continue;
                                        }
                                    }
                                    catch (VMDisconnectedException v12) {
                                        throw 1.b(v12);
                                    }
                                    try {
                                        block58: {
                                            try {
                                                if (var5_5 instanceof VMStartEvent) {
                                                    DebugProcessEvents.access$300(DebugProcessEvents.this, (SuspendContextImpl)var3_3 /* !! */ , (VMStartEvent)var5_5);
                                                    continue;
                                                }
                                            }
                                            catch (VMDisconnectedException v13) {
                                                throw 1.b(v13);
                                            }
                                            if (var5_5 instanceof VMDeathEvent) ** GOTO lbl117
                                            try {
                                                block65: {
                                                    if (!(var5_5 instanceof VMDisconnectEvent)) break block58;
                                                    break block65;
                                                    catch (VMDisconnectedException v14) {
                                                        throw 1.b(v14);
                                                    }
                                                }
                                                DebugProcessEvents.access$400(DebugProcessEvents.this, (SuspendContextImpl)var3_3 /* !! */ , (Event)var5_5);
                                                continue;
                                            }
                                            catch (VMDisconnectedException v15) {
                                                throw 1.b(v15);
                                            }
                                        }
                                        try {
                                            if (var5_5 instanceof ClassPrepareEvent) {
                                                DebugProcessEvents.access$500(DebugProcessEvents.this, (SuspendContextImpl)var3_3 /* !! */ , (ClassPrepareEvent)var5_5);
                                                continue;
                                            }
                                        }
                                        catch (VMDisconnectedException v16) {
                                            throw 1.b(v16);
                                        }
                                        try {
                                            if (var5_5 instanceof StepEvent) {
                                                DebugProcessEvents.access$600(DebugProcessEvents.this, (SuspendContextImpl)var3_3 /* !! */ , (StepEvent)var5_5);
                                                continue;
                                            }
                                        }
                                        catch (VMDisconnectedException v17) {
                                            throw 1.b(v17);
                                        }
                                        try {
                                            if (var5_5 instanceof LocatableEvent) {
                                                DebugProcessEvents.access$700(DebugProcessEvents.this, (SuspendContextImpl)var3_3 /* !! */ , (LocatableEvent)var5_5);
                                                continue;
                                            }
                                        }
                                        catch (VMDisconnectedException v18) {
                                            throw 1.b(v18);
                                        }
                                        try {
                                            if (!(var5_5 instanceof ClassUnloadEvent)) continue;
                                            DebugProcessEvents.access$800(DebugProcessEvents.this, (SuspendContextImpl)var3_3 /* !! */ );
                                        }
                                        catch (VMDisconnectedException v19) {
                                            throw 1.b(v19);
                                        }
                                    }
                                    catch (VMDisconnectedException var6_7) {
                                        DebugProcessEvents.access$900().debug((Throwable)var6_7);
                                    }
                                    catch (InternalException var6_8) {
                                        DebugProcessEvents.access$900().info((Throwable)var6_8);
                                    }
                                    catch (Throwable var6_9) {
                                        DebugProcessEvents.access$900().error(var6_9);
                                    }
                                }
                            }

                            private static VMDisconnectedException b(VMDisconnectedException vMDisconnectedException) {
                                return vMDisconnectedException;
                            }
                        });
                    }
                    catch (InternalException internalException) {
                        z.debug((Throwable)internalException);
                    }
                    catch (ProcessCanceledException | VMDisconnectedException | InterruptedException throwable) {
                        throw throwable;
                    }
                    catch (Throwable throwable) {
                        z.debug(throwable);
                    }
                }
            }
            catch (VMDisconnectedException | InterruptedException exception) {
                this.b();
            }
            finally {
                Thread.interrupted();
                Thread.currentThread().setName(string);
            }
        }

        private void b() {
            DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendContextImpl = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(0, 1);
                    DebugProcessEvents.this.a(suspendContextImpl, null);
                }
            });
        }
    }
}

