/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class JVMNameUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.JVMNameUtil");
    public static final String CONSTRUCTOR_NAME = "<init>";

    @Nullable
    public static String getPrimitiveSignature(String string) {
        try {
            if (PsiType.BOOLEAN.getCanonicalText().equals(string)) {
                return "Z";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.BYTE.getCanonicalText().equals(string)) {
                return "B";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.CHAR.getCanonicalText().equals(string)) {
                return "C";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.SHORT.getCanonicalText().equals(string)) {
                return "S";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.INT.getCanonicalText().equals(string)) {
                return "I";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.LONG.getCanonicalText().equals(string)) {
                return "J";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.FLOAT.getCanonicalText().equals(string)) {
                return "F";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.DOUBLE.getCanonicalText().equals(string)) {
                return "D";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiType.VOID.getCanonicalText().equals(string)) {
                return "V";
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return null;
    }

    private static void a(JVMNameBuffer jVMNameBuffer, PsiType psiType) {
        block10: {
            PsiType psiType2;
            block9: {
                try {
                    if (psiType == null) {
                        return;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
                psiType2 = TypeConversionUtil.erasure((PsiType)psiType);
                try {
                    if (!(psiType2 instanceof PsiArrayType)) break block9;
                    jVMNameBuffer.append(new JVMRawText("["));
                    JVMNameUtil.a(jVMNameBuffer, ((PsiArrayType)psiType2).getComponentType());
                    break block10;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            if (psiType2 instanceof PsiClassType) {
                JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiType2);
                JVMNameUtil.a(jVMNameBuffer, jVMName);
            } else {
                block11: {
                    try {
                        if (!(psiType2 instanceof PsiPrimitiveType)) break block11;
                        jVMNameBuffer.append(JVMNameUtil.getPrimitiveSignature(psiType2.getCanonicalText()));
                        break block10;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                }
                a.error("unknown type " + psiType.getCanonicalText());
            }
        }
    }

    private static void a(JVMNameBuffer jVMNameBuffer, final JVMName jVMName) {
        block3: {
            block2: {
                try {
                    jVMNameBuffer.append("L");
                    if (!(jVMName instanceof JVMRawText)) break block2;
                    jVMNameBuffer.append(((JVMRawText)jVMName).getName().replace('.', '/'));
                    break block3;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            jVMNameBuffer.append(new JVMName(){

                @Override
                public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
                    return jVMName.getName(debugProcessImpl).replace('.', '/');
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcessImpl) {
                    return jVMName.getDisplayName(debugProcessImpl);
                }
            });
        }
        jVMNameBuffer.append(";");
    }

    @NotNull
    public static JVMName getJVMRawText(String string) {
        JVMRawText jVMRawText;
        try {
            jVMRawText = new JVMRawText(string);
            if (jVMRawText == null) {
                JVMNameUtil.a(0);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return jVMRawText;
    }

    public static JVMName getJVMQualifiedName(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiArrayType.getComponentType());
            JVMNameBuffer jVMNameBuffer = new JVMNameBuffer();
            jVMNameBuffer.append(jVMName);
            jVMNameBuffer.append("[]");
            return jVMNameBuffer.toName();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        try {
            if (psiClass == null) {
                return JVMNameUtil.getJVMRawText(psiType.getCanonicalText());
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return JVMNameUtil.getJVMQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMQualifiedName(@NotNull PsiClass psiClass) {
        JVMClassAt jVMClassAt;
        block10: {
            JVMName jVMName;
            block11: {
                try {
                    if (psiClass == null) {
                        JVMNameUtil.a(1);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
                String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
                try {
                    try {
                        if (string == null) break block10;
                        jVMName = JVMNameUtil.getJVMRawText(string);
                        if (jVMName != null) break block11;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    JVMNameUtil.a(2);
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            return jVMName;
        }
        try {
            jVMClassAt = new JVMClassAt(SourcePosition.createFromElement((PsiElement)psiClass));
            if (jVMClassAt == null) {
                JVMNameUtil.a(3);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return jVMClassAt;
    }

    @Nullable
    public static JVMName getContextClassJVMQualifiedName(@Nullable SourcePosition sourcePosition) {
        PsiClass psiClass = JVMNameUtil.getClassAt(sourcePosition);
        try {
            if (psiClass == null) {
                return null;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        try {
            if (string != null) {
                return JVMNameUtil.getJVMRawText(string);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return new JVMClassAt(sourcePosition);
    }

    @Nullable
    public static String getNonAnonymousClassName(@NotNull PsiClass psiClass) {
        try {
            if (psiClass == null) {
                JVMNameUtil.a(4);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                return null;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        String string = psiClass.getName();
        try {
            if (string == null) {
                return null;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        if (psiClass2 != null) {
            String string2 = JVMNameUtil.getNonAnonymousClassName(psiClass2);
            try {
                if (string2 == null) {
                    return null;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw JVMNameUtil.b(processCanceledException);
            }
            return string2 + "$" + string;
        }
        return DebuggerManager.getInstance((Project)psiClass.getProject()).getVMClassQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMConstructorSignature(@Nullable PsiMethod psiMethod, @Nullable PsiClass psiClass) {
        JVMName jVMName;
        try {
            jVMName = JVMNameUtil.a(psiMethod, true, psiClass);
            if (jVMName == null) {
                JVMNameUtil.a(5);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return jVMName;
    }

    @NotNull
    public static JVMName getJVMSignature(@NotNull PsiMethod psiMethod) {
        JVMName jVMName;
        try {
            if (psiMethod == null) {
                JVMNameUtil.a(6);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            jVMName = JVMNameUtil.a(psiMethod, psiMethod.isConstructor(), psiMethod.getContainingClass());
            if (jVMName == null) {
                JVMNameUtil.a(7);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return jVMName;
    }

    @NotNull
    public static String getJVMMethodName(@NotNull PsiMethod psiMethod) {
        String string;
        String string2;
        try {
            if (psiMethod == null) {
                JVMNameUtil.a(8);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            string2 = psiMethod.isConstructor() ? "<init>" : psiMethod.getName();
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        try {
            string = string2;
            if (string2 == null) {
                JVMNameUtil.a(9);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return string;
    }

    @NotNull
    private static JVMName a(@Nullable PsiMethod psiMethod, boolean bl2, @Nullable PsiClass psiClass) {
        JVMName jVMName;
        JVMNameBuffer jVMNameBuffer;
        block17: {
            block16: {
                block15: {
                    jVMNameBuffer = new JVMNameBuffer();
                    try {
                        jVMNameBuffer.append("(");
                        if (!bl2 || psiClass == null) break block15;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    PsiParameter[] psiParameterArray = psiClass.getContainingClass();
                    try {
                        try {
                            if (psiParameterArray == null || psiClass.hasModifierProperty("static")) break block15;
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            throw JVMNameUtil.b(processCanceledException);
                        }
                        JVMNameUtil.a(jVMNameBuffer, JVMNameUtil.getJVMQualifiedName((PsiClass)psiParameterArray));
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                }
                if (psiMethod != null) {
                    for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                        JVMNameUtil.a(jVMNameBuffer, psiParameter.getType());
                    }
                }
                try {
                    try {
                        jVMNameBuffer.append(")");
                        if (bl2 || psiMethod == null) break block16;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    JVMNameUtil.a(jVMNameBuffer, psiMethod.getReturnType());
                    break block17;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            jVMNameBuffer.append(new JVMRawText("V"));
        }
        try {
            jVMName = jVMNameBuffer.toName();
            if (jVMName == null) {
                JVMNameUtil.a(10);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        return jVMName;
    }

    @Nullable
    public static PsiClass getClassAt(@Nullable SourcePosition sourcePosition) {
        PsiClass psiClass;
        block8: {
            block7: {
                try {
                    if (sourcePosition == null) {
                        return null;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
                PsiElement psiElement = sourcePosition.getElementAt();
                try {
                    try {
                        if (psiElement == null || !psiElement.isValid()) break block7;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
                    break block8;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            psiClass = null;
        }
        return psiClass;
    }

    @Nullable
    public static String getSourcePositionClassDisplayName(DebugProcessImpl debugProcessImpl, @Nullable SourcePosition sourcePosition) {
        PsiClass psiClass;
        block20: {
            PsiFile psiFile;
            block21: {
                block19: {
                    Object object;
                    try {
                        if (sourcePosition == null) {
                            return null;
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    psiFile = sourcePosition.getFile();
                    try {
                        if (psiFile instanceof JspFile) {
                            return psiFile.getName();
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    psiClass = JVMNameUtil.getClassAt(sourcePosition);
                    if (psiClass != null) {
                        object = psiClass.getQualifiedName();
                        try {
                            if (object != null) {
                                return object;
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            throw JVMNameUtil.b(processCanceledException);
                        }
                    }
                    try {
                        if (debugProcessImpl == null || !debugProcessImpl.isAttached()) break block19;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    object = debugProcessImpl.getPositionManager().getAllClasses(sourcePosition);
                    try {
                        if (!object.isEmpty()) {
                            return ((ReferenceType)object.get(0)).name();
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                }
                try {
                    try {
                        if (psiClass != null) break block20;
                        if (!(psiFile instanceof PsiClassOwner)) break block21;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw JVMNameUtil.b(processCanceledException);
                    }
                    return psiFile.getName();
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            return DebuggerBundle.message((String)"string.file.line.position", (Object[])new Object[]{psiFile.getName(), sourcePosition.getLine()});
        }
        return JVMNameUtil.calcClassDisplayName(psiClass);
    }

    static String calcClassDisplayName(final PsiClass psiClass) {
        String string = psiClass.getQualifiedName();
        try {
            if (string != null) {
                return string;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        try {
            if (psiClass2 == null) {
                return null;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        String string2 = psiClass.getName();
        try {
            if (string2 != null) {
                return JVMNameUtil.calcClassDisplayName(psiClass2) + "$" + string2;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw JVMNameUtil.b(processCanceledException);
        }
        final Ref ref = new Ref((Object)0);
        try {
            psiClass2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitAnonymousClass(PsiAnonymousClass psiAnonymousClass) {
                    try {
                        ref.set((Object)((Integer)ref.get() + 1));
                        if (psiClass.equals(psiAnonymousClass)) {
                            throw new ProcessCanceledException();
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw 2.b(processCanceledException);
                    }
                }

                private static ProcessCanceledException b(ProcessCanceledException processCanceledException) {
                    return processCanceledException;
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return JVMNameUtil.calcClassDisplayName(psiClass2) + "$" + ref.get();
    }

    @Nullable
    public static String getSourcePositionPackageDisplayName(DebugProcessImpl debugProcessImpl, @Nullable SourcePosition sourcePosition) {
        block19: {
            String string;
            Object object;
            try {
                if (sourcePosition == null) {
                    return null;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw JVMNameUtil.b(processCanceledException);
            }
            PsiFile psiFile = sourcePosition.getFile();
            if (psiFile instanceof JspFile) {
                String string2;
                PsiDirectory psiDirectory = psiFile.getContainingDirectory();
                try {
                    string2 = psiDirectory != null ? psiDirectory.getVirtualFile().getPresentableUrl() : null;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
                return string2;
            }
            PsiClass psiClass = JVMNameUtil.getClassAt(sourcePosition);
            if (psiClass != null && (object = PsiUtil.getTopLevelClass((PsiElement)psiClass)) != null && (string = object.getQualifiedName()) != null) {
                String string3;
                int n2 = string.lastIndexOf(46);
                try {
                    string3 = n2 > 0 ? string.substring(0, n2) : "";
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
                return string3;
            }
            if (psiFile instanceof PsiClassOwner) {
                object = ((PsiClassOwner)psiFile).getPackageName();
                try {
                    if (!StringUtil.isEmpty((String)object)) {
                        return object;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
            try {
                if (debugProcessImpl == null || !debugProcessImpl.isAttached()) break block19;
            }
            catch (ProcessCanceledException processCanceledException) {
                throw JVMNameUtil.b(processCanceledException);
            }
            object = debugProcessImpl.getPositionManager().getAllClasses(sourcePosition);
            if (!object.isEmpty()) {
                string = ((ReferenceType)object.get(0)).name();
                int n3 = string.lastIndexOf(46);
                try {
                    if (n3 >= 0) {
                        return string.substring(0, n3);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
            }
        }
        return "";
    }

    public static PsiClass getTopLevelParentClass(PsiClass psiClass) {
        return (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
    }

    @Nullable
    public static String getClassVMName(@Nullable PsiClass psiClass) {
        block8: {
            try {
                try {
                    if (psiClass != null && !PsiUtil.isLocalClass((PsiClass)psiClass)) break block8;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw JVMNameUtil.b(processCanceledException);
                }
                return null;
            }
            catch (ProcessCanceledException processCanceledException) {
                throw JVMNameUtil.b(processCanceledException);
            }
        }
        if (psiClass instanceof PsiAnonymousClass) {
            String string = JVMNameUtil.getClassVMName((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class));
            try {
                if (string == null) {
                    return null;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw JVMNameUtil.b(processCanceledException);
            }
            return string + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        return ClassUtil.getJVMClassName((PsiClass)psiClass);
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ProcessCanceledException b(ProcessCanceledException processCanceledException) {
        return processCanceledException;
    }

    private static class JVMClassAt
    implements JVMName {
        private final SourcePosition a;

        public JVMClassAt(SourcePosition sourcePosition) {
            this.a = sourcePosition;
        }

        @Override
        public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
            List<ReferenceType> list = debugProcessImpl.getPositionManager().getAllClasses(this.a);
            if (list.size() > 1) {
                String string = (String)ReadAction.compute(() -> JVMNameUtil.getClassVMName(JVMNameUtil.getClassAt(this.a)));
                for (ReferenceType referenceType : list) {
                    try {
                        if (!Comparing.equal((String)referenceType.name(), (String)string)) continue;
                        return string;
                    }
                    catch (EvaluateException evaluateException) {
                        throw JVMClassAt.b(evaluateException);
                    }
                }
            }
            try {
                if (!list.isEmpty()) {
                    return list.get(0).name();
                }
            }
            catch (EvaluateException evaluateException) {
                throw JVMClassAt.b(evaluateException);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{this.getDisplayName(debugProcessImpl)}));
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcessImpl) {
            return (String)ReadAction.compute(() -> JVMNameUtil.getSourcePositionClassDisplayName(debugProcessImpl, this.a));
        }

        private static EvaluateException b(EvaluateException evaluateException) {
            return evaluateException;
        }
    }

    private static class JVMRawText
    implements JVMName {
        private String a;

        public JVMRawText(String string) {
            this.a = string;
        }

        @Override
        public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
            return this.a;
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcessImpl) {
            return this.a;
        }

        public String getName() {
            return this.a;
        }

        public void setName(String string) {
            this.a = string;
        }

        public String toString() {
            return this.a;
        }
    }

    private static class JVMNameBuffer {
        private final List<JVMName> a = new ArrayList<JVMName>();

        private JVMNameBuffer() {
        }

        public void append(@NotNull JVMName jVMName) {
            try {
                if (jVMName == null) {
                    JVMNameBuffer.a(0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JVMNameBuffer.a(illegalArgumentException);
            }
            this.a.add(jVMName);
        }

        public void append(char c2) {
            this.append(Character.toString(c2));
        }

        public void append(String string) {
            this.a.add(JVMNameUtil.getJVMRawText(string));
        }

        public JVMName toName() {
            final ArrayList<JVMName> arrayList = new ArrayList<JVMName>();
            for (JVMName jVMName : this.a) {
                block11: {
                    try {
                        try {
                            if (!(jVMName instanceof JVMRawText) || arrayList.isEmpty()) break block11;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw JVMNameBuffer.a(illegalArgumentException);
                        }
                        if (!(arrayList.get(arrayList.size() - 1) instanceof JVMRawText)) break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw JVMNameBuffer.a(illegalArgumentException);
                    }
                    JVMRawText jVMRawText = (JVMRawText)arrayList.get(arrayList.size() - 1);
                    jVMRawText.setName(jVMRawText.getName() + ((JVMRawText)jVMName).getName());
                    continue;
                }
                arrayList.add(jVMName);
            }
            try {
                if (arrayList.size() == 1) {
                    return (JVMName)arrayList.get(0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JVMNameBuffer.a(illegalArgumentException);
            }
            try {
                if (arrayList.isEmpty()) {
                    return new JVMRawText("");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JVMNameBuffer.a(illegalArgumentException);
            }
            return new JVMName(){
                String myName = null;

                @Override
                public String getName(DebugProcessImpl debugProcessImpl) throws EvaluateException {
                    if (this.myName == null) {
                        String string = "";
                        for (JVMName jVMName : arrayList) {
                            string = string + jVMName.getName(debugProcessImpl);
                        }
                        this.myName = string;
                    }
                    return this.myName;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcessImpl) {
                    if (this.myName == null) {
                        String string = "";
                        for (JVMName jVMName : arrayList) {
                            string = string + jVMName.getDisplayName(debugProcessImpl);
                        }
                        return string;
                    }
                    return this.myName;
                }
            };
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/debugger/engine/JVMNameUtil$JVMNameBuffer", "append"));
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }
}

