/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FrameExtraVariablesProvider;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaFramesListRenderer;
import com.intellij.debugger.engine.JavaStaticGroup;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class JavaStackFrame
extends XStackFrame
implements JVMStackFrameInfoProvider {
    private static final Logger a = Logger.getInstance(JavaStackFrame.class);
    public static final DummyMessageValueNode LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE = new DummyMessageValueNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
    private final DebugProcessImpl h;
    @Nullable
    private final XSourcePosition c;
    private final NodeManagerImpl g;
    @NotNull
    private final StackFrameDescriptorImpl j;
    private static final JavaFramesListRenderer d = new JavaFramesListRenderer();
    private JavaDebuggerEvaluator i;
    private final String e;
    private CapturePoint f;
    private static final Pair<Set<String>, Set<TextWithImports>> b = Pair.create(Collections.emptySet(), Collections.emptySet());

    public JavaStackFrame(@NotNull StackFrameDescriptorImpl stackFrameDescriptorImpl, boolean bl2) {
        String string;
        if (stackFrameDescriptorImpl == null) {
            JavaStackFrame.a(0);
        }
        this.i = null;
        this.j = stackFrameDescriptorImpl;
        if (bl2) {
            this.j.setContext(null);
            this.j.updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
        }
        try {
            JavaStackFrame javaStackFrame = this;
            string = bl2 ? NodeManagerImpl.getContextKeyForFrame(this.j.getFrameProxy()) : null;
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        javaStackFrame.e = string;
        this.h = (DebugProcessImpl)stackFrameDescriptorImpl.getDebugProcess();
        this.g = this.h.getXdebugProcess().getNodeManager();
        this.c = DebuggerUtilsEx.toXSourcePosition(this.j.getSourcePosition());
    }

    @NotNull
    public StackFrameDescriptorImpl getDescriptor() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl;
        try {
            stackFrameDescriptorImpl = this.j;
            if (stackFrameDescriptorImpl == null) {
                JavaStackFrame.a(1);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        return stackFrameDescriptorImpl;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        try {
            if (this.i == null) {
                this.i = new JavaDebuggerEvaluator(this.h, this);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        return this.i;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.c;
    }

    public void customizePresentation(@NotNull ColoredTextContainer coloredTextContainer) {
        XStackFrame xStackFrame;
        XDebugSession xDebugSession;
        try {
            if (coloredTextContainer == null) {
                JavaStackFrame.a(2);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        StackFrameDescriptorImpl stackFrameDescriptorImpl = null;
        DebuggerSession debuggerSession = this.h.getSession();
        if (debuggerSession != null && (xDebugSession = debuggerSession.getXDebugSession()) != null && (xStackFrame = xDebugSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
            stackFrameDescriptorImpl = ((JavaStackFrame)xStackFrame).getDescriptor();
        }
        try {
            d.customizePresentation(this.j, coloredTextContainer, stackFrameDescriptorImpl);
            if (this.f != null) {
                coloredTextContainer.setIcon(XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
    }

    public void computeChildren(final @NotNull XCompositeNode xCompositeNode) {
        try {
            if (xCompositeNode == null) {
                JavaStackFrame.a(3);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        try {
            if (xCompositeNode.isObsolete()) {
                return;
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        this.h.getManagerThread().schedule(new DebuggerContextCommandImpl(this.h.getDebuggerContext(), this.j.getFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                try {
                    if (suspendContextImpl == null) {
                        1.c(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                try {
                    if (xCompositeNode.isObsolete()) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                try {
                    if (JavaStackFrame.this.f != null) {
                        xCompositeNode.setMessage("Async stacktrace from " + ((JavaStackFrame)JavaStackFrame.this).f.myClassName + "." + ((JavaStackFrame)JavaStackFrame.this).f.myMethodName + " could be available here, enable in", XDebuggerUIConstants.INFORMATION_MESSAGE_ICON, SimpleTextAttributes.REGULAR_ATTRIBUTES, StackFrameItem.CAPTURE_SETTINGS_OPENER);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                XValueChildrenList xValueChildrenList = new XValueChildrenList();
                JavaStackFrame.this.a(JavaStackFrame.this.getFrameDebuggerContext(this.getDebuggerContext()), xValueChildrenList, xCompositeNode);
                xCompositeNode.addChildren(xValueChildrenList, true);
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaStackFrame$1", "threadAction"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
    }

    DebuggerContextImpl getFrameDebuggerContext(@Nullable DebuggerContextImpl debuggerContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (debuggerContextImpl == null) {
            debuggerContextImpl = this.h.getDebuggerContext();
        }
        if (debuggerContextImpl.getFrameProxy() != this.getStackFrameProxy()) {
            SuspendContextImpl suspendContextImpl = SuspendManagerUtil.findContextByThread(this.h.getSuspendManager(), this.getStackFrameProxy().threadProxy());
            debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(this.h.mySession, suspendContextImpl, this.getStackFrameProxy().threadProxy(), this.getStackFrameProxy());
            debuggerContextImpl.setPositionCache(this.j.getSourcePosition());
            debuggerContextImpl.initCaches();
        }
        return debuggerContextImpl;
    }

    private void a(DebuggerContextImpl debuggerContextImpl, XValueChildrenList xValueChildrenList, XCompositeNode xCompositeNode) {
        try {
            Object object;
            Object object2;
            ObjectReference objectReference2;
            Location location;
            EvaluationContextImpl evaluationContextImpl;
            block23: {
                evaluationContextImpl = debuggerContextImpl.createEvaluationContext();
                if (evaluationContextImpl == null) {
                    return;
                }
                try {
                    if (!debuggerContextImpl.isEvaluationPossible()) {
                        xCompositeNode.setErrorMessage(MessageDescriptor.EVALUATION_NOT_POSSIBLE.getLabel());
                    }
                }
                catch (EvaluateException evaluateException) {
                    throw JavaStackFrame.b((Exception)((Object)evaluateException));
                }
                location = this.j.getLocation();
                objectReference2 = this.j.getThisObject();
                if (objectReference2 != null) {
                    object2 = this.g.getThisDescriptor(null, objectReference2);
                    xValueChildrenList.add((XNamedValue)JavaValue.create((ValueDescriptorImpl)object2, evaluationContextImpl, this.g));
                } else if (location != null) {
                    object2 = this.g.getStaticDescriptor(this.j, location.declaringType());
                    try {
                        if (((StaticDescriptorImpl)object2).isExpandable()) {
                            xValueChildrenList.addTopGroup((XValueGroup)new JavaStaticGroup((StaticDescriptorImpl)object2, evaluationContextImpl, this.g));
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw JavaStackFrame.b((Exception)((Object)evaluateException));
                    }
                }
                object2 = debuggerContextImpl.getDebugProcess();
                if (object2 == null) {
                    return;
                }
                Pair<Method, Value> pair2 = ((DebugProcessImpl)((Object)object2)).getLastExecutedMethod();
                try {
                    if (pair2 == null || this.j.getUiIndex() != 0) break block23;
                }
                catch (EvaluateException evaluateException) {
                    throw JavaStackFrame.b((Exception)((Object)evaluateException));
                }
                object = this.g.getMethodReturnValueDescriptor(this.j, (Method)pair2.getFirst(), (Value)pair2.getSecond());
                xValueChildrenList.add((XNamedValue)JavaValue.create((ValueDescriptorImpl)object, evaluationContextImpl, this.g));
            }
            object = new HashSet();
            for (Pair<Breakpoint, Event> pair3 : DebuggerUtilsEx.getEventDescriptors(debuggerContextImpl.getSuspendContext())) {
                Event event = (Event)pair3.getSecond();
                if (!(event instanceof ExceptionEvent)) continue;
                ObjectReference objectReference3 = ((ExceptionEvent)event).exception();
                try {
                    if (objectReference3 == null) continue;
                    object.add(objectReference3);
                }
                catch (EvaluateException evaluateException) {
                    throw JavaStackFrame.b((Exception)((Object)evaluateException));
                }
            }
            object.forEach(objectReference -> xValueChildrenList.add((XNamedValue)JavaValue.create(this.g.getThrownExceptionObjectDescriptor(this.j, (ObjectReference)objectReference), evaluationContextImpl, this.g)));
            try {
                this.a(debuggerContextImpl, evaluationContextImpl, (DebugProcessImpl)((Object)object2), xValueChildrenList, objectReference2, location);
            }
            catch (EvaluateException evaluateException) {
                xCompositeNode.setErrorMessage(evaluateException.getMessage());
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            a.info((Throwable)invalidStackFrameException);
        }
        catch (InternalException internalException) {
            block24: {
                try {
                    if (internalException.errorCode() != 35) break block24;
                    xCompositeNode.setErrorMessage(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{internalException.getMessage()}));
                }
                catch (EvaluateException evaluateException) {
                    throw JavaStackFrame.b((Exception)((Object)evaluateException));
                }
            }
            throw internalException;
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    private void a(DebuggerContextImpl debuggerContextImpl, EvaluationContextImpl evaluationContextImpl, @NotNull DebugProcessImpl debugProcessImpl, XValueChildrenList xValueChildrenList, ObjectReference objectReference, Location location) throws EvaluateException {
        block38: {
            Object object4;
            HashSet<String> hashSet;
            block36: {
                ReferenceType referenceType;
                block40: {
                    try {
                        if (debugProcessImpl == null) {
                            JavaStackFrame.a(4);
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw JavaStackFrame.b((Exception)((Object)evaluateException));
                    }
                    hashSet = new HashSet<String>();
                    if (!NodeRendererSettings.getInstance().getClassRenderer().SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES) break block36;
                    try {
                        block39: {
                            if (objectReference == null) break block36;
                            break block39;
                            catch (EvaluateException evaluateException) {
                                throw JavaStackFrame.b((Exception)((Object)evaluateException));
                            }
                        }
                        if (!debugProcessImpl.getVirtualMachineProxy().canGetSyntheticAttribute()) break block36;
                    }
                    catch (EvaluateException evaluateException) {
                        throw JavaStackFrame.b((Exception)((Object)evaluateException));
                    }
                    referenceType = objectReference.referenceType();
                    if (!(referenceType instanceof ClassType)) break block36;
                    if (location == null) break block36;
                    break block40;
                    catch (EvaluateException evaluateException) {
                        throw JavaStackFrame.b((Exception)((Object)evaluateException));
                    }
                }
                try {
                    block41: {
                        if (!referenceType.equals(location.declaringType())) break block36;
                        break block41;
                        catch (EvaluateException evaluateException) {
                            throw JavaStackFrame.b((Exception)((Object)evaluateException));
                        }
                    }
                    if (!referenceType.name().contains("$")) break block36;
                }
                catch (EvaluateException evaluateException) {
                    throw JavaStackFrame.b((Exception)((Object)evaluateException));
                }
                for (Object object2 : referenceType.fields()) {
                    try {
                        if (!DebuggerUtils.isSynthetic((TypeComponent)object2) || !StringUtil.startsWith((CharSequence)object2.name(), (CharSequence)"val$")) continue;
                    }
                    catch (EvaluateException evaluateException) {
                        throw JavaStackFrame.b((Exception)((Object)evaluateException));
                    }
                    object4 = this.g.getFieldDescriptor(this.j, objectReference, (Field)object2);
                    xValueChildrenList.add((XNamedValue)JavaValue.create((ValueDescriptorImpl)object4, evaluationContextImpl, this.g));
                    hashSet.add(((FieldDescriptorImpl)object4).calcValueName());
                }
            }
            boolean bl2 = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
            try {
                if (evaluationContextImpl == null) {
                    return;
                }
            }
            catch (EvaluateException evaluateException) {
                throw JavaStackFrame.b((Exception)((Object)evaluateException));
            }
            try {
                Object object2;
                block37: {
                    if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions()) break block37;
                    try {
                        block42: {
                            if (bl2) break block37;
                            break block42;
                            catch (EvaluateException evaluateException) {
                                throw JavaStackFrame.b((Exception)((Object)evaluateException));
                            }
                        }
                        this.superBuildVariables(evaluationContextImpl, xValueChildrenList);
                        break block38;
                    }
                    catch (EvaluateException evaluateException) {
                        throw JavaStackFrame.b((Exception)((Object)evaluateException));
                    }
                }
                SourcePosition sourcePosition = debuggerContextImpl.getSourcePosition();
                object2 = ContainerUtil.map2Map(this.getVisibleVariables(), localVariableProxyImpl -> Pair.create((Object)localVariableProxyImpl.name(), (Object)localVariableProxyImpl));
                object4 = b;
                if (sourcePosition != null) {
                    object4 = (Pair)ReadAction.compute(() -> JavaStackFrame.a((Map)object2, hashSet, sourcePosition));
                }
                if (bl2) {
                    for (Object object3 : (Set)((Pair)object4).first) {
                        LocalVariableProxyImpl localVariableProxyImpl2 = (LocalVariableProxyImpl)object2.get(object3);
                        try {
                            if (localVariableProxyImpl2 == null) continue;
                            xValueChildrenList.add((XNamedValue)JavaValue.create(this.g.getLocalVariableDescriptor(null, localVariableProxyImpl2), evaluationContextImpl, this.g));
                        }
                        catch (EvaluateException evaluateException) {
                            throw JavaStackFrame.b((Exception)((Object)evaluateException));
                        }
                    }
                } else {
                    this.superBuildVariables(evaluationContextImpl, xValueChildrenList);
                }
                EvaluationContextImpl evaluationContextImpl2 = evaluationContextImpl.withAutoLoadClasses(false);
                if (sourcePosition != null) {
                    Object object3;
                    object3 = JavaStackFrame.a((Pair<Set<String>, Set<TextWithImports>>)object4, sourcePosition, evaluationContextImpl);
                    this.a((Set<TextWithImports>)object3, xValueChildrenList, evaluationContextImpl);
                }
                this.a((Set)((Pair)object4).second, xValueChildrenList, evaluationContextImpl2);
            }
            catch (EvaluateException evaluateException) {
                if (evaluateException.getCause() instanceof AbsentInformationException) {
                    xValueChildrenList.add((XNamedValue)LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                    try {
                        for (Object object4 : LocalVariablesUtil.fetchValues(this.getStackFrameProxy(), debugProcessImpl, true).entrySet()) {
                            xValueChildrenList.add((XNamedValue)JavaValue.create(this.g.getArgumentValueDescriptor(null, (DecompiledLocalVariable)object4.getKey(), (Value)object4.getValue()), evaluationContextImpl, this.g));
                        }
                    }
                    catch (Exception exception) {
                        a.info((Throwable)exception);
                        break block38;
                    }
                }
                throw evaluateException;
            }
        }
    }

    private static Set<TextWithImports> a(Pair<Set<String>, Set<TextWithImports>> pair2, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evaluationContextImpl) {
        try {
            if (sourcePosition == null) {
                JavaStackFrame.a(5);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        try {
            if (evaluationContextImpl == null) {
                JavaStackFrame.a(6);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        HashSet<String> hashSet = new HashSet<String>((Collection)pair2.first);
        ((Set)pair2.second).stream().map(TextWithImports::getText).forEach(hashSet::add);
        HashSet<TextWithImports> hashSet2 = new HashSet<TextWithImports>();
        for (FrameExtraVariablesProvider frameExtraVariablesProvider : (FrameExtraVariablesProvider[])FrameExtraVariablesProvider.EP_NAME.getExtensions()) {
            try {
                if (!frameExtraVariablesProvider.isAvailable(sourcePosition, evaluationContextImpl)) continue;
                hashSet2.addAll(frameExtraVariablesProvider.collectVariables(sourcePosition, evaluationContextImpl, hashSet));
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw JavaStackFrame.b(invalidStackFrameException);
            }
        }
        return hashSet2;
    }

    private void a(Set<TextWithImports> set, XValueChildrenList xValueChildrenList, EvaluationContextImpl evaluationContextImpl) {
        for (TextWithImports textWithImports : set) {
            WatchItemDescriptor watchItemDescriptor = this.g.getWatchItemDescriptor(null, textWithImports, null);
            xValueChildrenList.add((XNamedValue)JavaValue.create(watchItemDescriptor, evaluationContextImpl, this.g));
        }
    }

    public static XNamedValue createMessageNode(String string, Icon icon) {
        return new DummyMessageValueNode(string, icon);
    }

    protected void superBuildVariables(EvaluationContextImpl evaluationContextImpl, XValueChildrenList xValueChildrenList) throws EvaluateException {
        for (LocalVariableProxyImpl localVariableProxyImpl : this.getVisibleVariables()) {
            xValueChildrenList.add((XNamedValue)JavaValue.create(this.g.getLocalVariableDescriptor(null, localVariableProxyImpl), evaluationContextImpl, this.g));
        }
    }

    @NotNull
    public StackFrameProxyImpl getStackFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl;
        try {
            stackFrameProxyImpl = this.j.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                JavaStackFrame.a(7);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        return stackFrameProxyImpl;
    }

    @Nullable
    public Object getEqualityObject() {
        return this.e;
    }

    public String toString() {
        try {
            if (this.c != null) {
                return "JavaFrame " + this.c.getFile().getName() + ":" + this.c.getLine();
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        return "JavaFrame position unknown";
    }

    protected List<LocalVariableProxyImpl> getVisibleVariables() throws EvaluateException {
        return this.getStackFrameProxy().visibleVariables();
    }

    /*
     * Loose catch block
     */
    private static boolean b(PsiFile psiFile, Document document, int n2) {
        int n3 = document.getLineStartOffset(n2);
        int n4 = document.getLineEndOffset(n2);
        int n5 = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)n3, (String)" \n\t");
        try {
            if (n5 >= n4) {
                return true;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw JavaStackFrame.b((Exception)((Object)indexNotReadyException));
        }
        TextRange textRange = null;
        PsiElement psiElement = psiFile.findElementAt(n5);
        while (true) {
            block19: {
                block20: {
                    if (psiElement == null) break;
                    if (psiElement.getTextOffset() > n4) break;
                    break block20;
                    catch (IndexNotReadyException indexNotReadyException) {
                        throw JavaStackFrame.b((Exception)((Object)indexNotReadyException));
                    }
                }
                try {
                    block21: {
                        if (textRange == null) break block19;
                        break block21;
                        catch (IndexNotReadyException indexNotReadyException) {
                            throw JavaStackFrame.b((Exception)((Object)indexNotReadyException));
                        }
                    }
                    if (textRange.contains(psiElement.getTextRange())) break;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw JavaStackFrame.b((Exception)((Object)indexNotReadyException));
                }
            }
            PsiElement psiElement2 = psiElement;
            while (psiElement2.getTextOffset() >= n5) {
                PsiElement psiElement3;
                textRange = psiElement2.getTextRange();
                if (psiElement2 instanceof PsiDeclarationStatement) {
                    for (PsiElement psiElement4 : psiElement3 = ((PsiDeclarationStatement)psiElement2).getDeclaredElements()) {
                        try {
                            if (!(psiElement4 instanceof PsiVariable)) continue;
                            return false;
                        }
                        catch (IndexNotReadyException indexNotReadyException) {
                            throw JavaStackFrame.b((Exception)((Object)indexNotReadyException));
                        }
                    }
                }
                if (psiElement2 instanceof PsiJavaCodeReferenceElement) {
                    try {
                        psiElement3 = ((PsiJavaCodeReferenceElement)psiElement2).resolve();
                        if (psiElement3 instanceof PsiVariable) {
                            return false;
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        return false;
                    }
                }
                psiElement2 = psiElement2.getParent();
            }
            psiElement = psiElement.getNextSibling();
        }
        return true;
    }

    private static Pair<Set<String>, Set<TextWithImports>> a(Set<String> set, @NotNull SourcePosition sourcePosition) {
        int n2;
        PsiElement psiElement;
        Document document;
        PsiFile psiFile;
        int n3;
        block39: {
            Document document2;
            block37: {
                try {
                    if (sourcePosition == null) {
                        JavaStackFrame.a(8);
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw JavaStackFrame.b(invalidStackFrameException);
                }
                n3 = sourcePosition.getLine();
                try {
                    if (n3 < 0) {
                        return Pair.create(Collections.emptySet(), Collections.emptySet());
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw JavaStackFrame.b(invalidStackFrameException);
                }
                psiFile = sourcePosition.getFile();
                try {
                    try {
                        if (psiFile.isValid() && psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) break block37;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw JavaStackFrame.b(invalidStackFrameException);
                    }
                    return Pair.create(set, Collections.emptySet());
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw JavaStackFrame.b(invalidStackFrameException);
                }
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            try {
                document2 = virtualFile != null ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw JavaStackFrame.b(invalidStackFrameException);
            }
            document = document2;
            try {
                block38: {
                    try {
                        try {
                            if (document == null || document.getLineCount() == 0) break block38;
                        }
                        catch (InvalidStackFrameException invalidStackFrameException) {
                            throw JavaStackFrame.b(invalidStackFrameException);
                        }
                        if (n3 <= document.getLineCount() - 1) break block39;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw JavaStackFrame.b(invalidStackFrameException);
                    }
                }
                return Pair.create(Collections.emptySet(), Collections.emptySet());
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw JavaStackFrame.b(invalidStackFrameException);
            }
        }
        TextRange textRange = JavaStackFrame.a(psiFile, document, n3);
        int n4 = Math.max(textRange.getStartOffset(), n3 - 1);
        n4 = Math.min(n4, textRange.getEndOffset());
        try {
            while (true) {
                try {
                    if (n4 <= textRange.getStartOffset() || !JavaStackFrame.b(psiFile, document, n4)) break;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw JavaStackFrame.b(invalidStackFrameException);
                }
                --n4;
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        int n5 = document.getLineStartOffset(n4);
        int n6 = Math.min(n3 + 2, textRange.getEndOffset());
        try {
            while (true) {
                try {
                    if (n6 >= textRange.getEndOffset() || !JavaStackFrame.b(psiFile, document, n6)) break;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw JavaStackFrame.b(invalidStackFrameException);
                }
                ++n6;
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        int n7 = document.getLineEndOffset(n6);
        TextRange textRange2 = new TextRange(n5, n7);
        if (!textRange2.isEmpty() && (psiElement = psiFile.findElementAt(n2 = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(n3), (String)" \t"))) != null) {
            Object object;
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiMethod.class});
            if (psiMethod != null) {
                psiElement = psiMethod;
            } else {
                object = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiField.class});
                if (object != null) {
                    psiElement = object;
                } else {
                    PsiClassInitializer psiClassInitializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClassInitializer.class});
                    if (psiClassInitializer != null) {
                        psiElement = psiClassInitializer;
                    }
                }
            }
            try {
                if (psiElement instanceof PsiCompiledElement) {
                    return Pair.create(set, Collections.emptySet());
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw JavaStackFrame.b(invalidStackFrameException);
            }
            object = new VariablesCollector(set, JavaStackFrame.a(psiElement, textRange2));
            psiElement.accept((PsiElementVisitor)object);
            return Pair.create(((VariablesCollector)((Object)object)).getVars(), ((VariablesCollector)((Object)object)).getExpressions());
        }
        return Pair.create(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange a(PsiFile psiFile, Document document, int n2) {
        PsiMethod psiMethod;
        int n3 = document.getLineStartOffset(n2);
        if (n3 > 0 && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(n3), PsiMethod.class, (boolean)false)) != null) {
            TextRange textRange = psiMethod.getTextRange();
            return new TextRange(document.getLineNumber(textRange.getStartOffset()), document.getLineNumber(textRange.getEndOffset()));
        }
        return new TextRange(0, document.getLineCount() - 1);
    }

    private static TextRange a(PsiElement psiElement, final TextRange textRange) {
        final Ref ref = new Ref((Object)textRange);
        psiElement.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(PsiExpressionStatement psiExpressionStatement) {
                TextRange textRange3 = psiExpressionStatement.getTextRange();
                if (textRange.intersects(textRange3)) {
                    TextRange textRange2 = (TextRange)ref.get();
                    int n2 = Math.min(textRange2.getStartOffset(), textRange3.getStartOffset());
                    int n3 = Math.max(textRange2.getEndOffset(), textRange3.getEndOffset());
                    ref.set((Object)new TextRange(n2, n3));
                }
            }
        });
        return (TextRange)ref.get();
    }

    public void setInsertCapturePoint(CapturePoint capturePoint) {
        this.f = capturePoint;
    }

    @Override
    public boolean isSynthetic() {
        return this.j.isSynthetic();
    }

    @Override
    public boolean isInLibraryContent() {
        return this.j.isInLibraryContent();
    }

    public boolean equals(Object object) {
        block10: {
            try {
                if (this == object) {
                    return true;
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw JavaStackFrame.b(invalidStackFrameException);
            }
            try {
                try {
                    if (object != null && this.getClass() == object.getClass()) break block10;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw JavaStackFrame.b(invalidStackFrameException);
                }
                return false;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw JavaStackFrame.b(invalidStackFrameException);
            }
        }
        JavaStackFrame javaStackFrame = (JavaStackFrame)object;
        try {
            if (!this.j.getFrameProxy().equals(javaStackFrame.j.getFrameProxy())) {
                return false;
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw JavaStackFrame.b(invalidStackFrameException);
        }
        return true;
    }

    public int hashCode() {
        return this.j.getFrameProxy().hashCode();
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> a;
        private final TextRange c;
        private final Set<TextWithImports> d = new HashSet<TextWithImports>();
        private final Set<String> b = new HashSet<String>();
        private final boolean e = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();

        public VariablesCollector(Set<String> set, TextRange textRange) {
            this.a = set;
            this.c = textRange;
        }

        public Set<String> getVars() {
            return this.b;
        }

        public Set<TextWithImports> getExpressions() {
            return this.d;
        }

        public void visitElement(PsiElement psiElement) {
            if (this.c.intersects(psiElement.getTextRange())) {
                super.visitElement(psiElement);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression psiMethodCallExpression) {
            PsiMethod psiMethod;
            if (this.e && (psiMethod = psiMethodCallExpression.resolveMethod()) != null && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)psiMethodCallExpression, this.a)) {
                this.d.add(new TextWithImportsImpl((PsiElement)psiMethodCallExpression));
            }
            super.visitMethodCallExpression(psiMethodCallExpression);
        }

        public void visitReferenceExpression(PsiReferenceExpression psiReferenceExpression) {
            PsiElement psiElement;
            if (this.c.intersects(psiReferenceExpression.getTextRange()) && (psiElement = psiReferenceExpression.resolve()) instanceof PsiVariable) {
                PsiVariable psiVariable = (PsiVariable)psiElement;
                if (psiVariable instanceof PsiField) {
                    if (this.e && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)psiReferenceExpression, this.a)) {
                        boolean bl2;
                        PsiModifierList psiModifierList = psiVariable.getModifierList();
                        boolean bl3 = bl2 = psiVariable instanceof PsiEnumConstant || psiModifierList != null && psiModifierList.hasModifierProperty("static") && psiModifierList.hasModifierProperty("final");
                        if (!bl2) {
                            this.d.add(new TextWithImportsImpl((PsiElement)psiReferenceExpression));
                        }
                    }
                } else if (this.a.contains(psiVariable.getName())) {
                    this.b.add(psiVariable.getName());
                } else if (!Comparing.equal((Object)PsiTreeUtil.getParentOfType((PsiElement)psiReferenceExpression, PsiClass.class), (Object)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiClass.class))) {
                    this.d.add(new TextWithImportsImpl((PsiElement)psiReferenceExpression));
                }
            }
            super.visitReferenceExpression(psiReferenceExpression);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression psiArrayAccessExpression) {
            if (this.e && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)psiArrayAccessExpression, this.a)) {
                this.d.add(new TextWithImportsImpl((PsiElement)psiArrayAccessExpression));
            }
            super.visitArrayAccessExpression(psiArrayAccessExpression);
        }

        public void visitParameter(PsiParameter psiParameter) {
            this.a((PsiVariable)psiParameter);
            super.visitParameter(psiParameter);
        }

        public void visitLocalVariable(PsiLocalVariable psiLocalVariable) {
            this.a((PsiVariable)psiLocalVariable);
            super.visitLocalVariable(psiLocalVariable);
        }

        private void a(PsiVariable psiVariable) {
            if (this.c.intersects(psiVariable.getTextRange()) && this.a.contains(psiVariable.getName())) {
                this.b.add(psiVariable.getName());
            }
        }

        public void visitClass(PsiClass psiClass) {
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    static class DummyMessageValueNode
    extends XNamedValue {
        private final String b;
        private final Icon a;

        public DummyMessageValueNode(String string, Icon icon) {
            super("");
            this.b = string;
            this.a = icon;
        }

        public void computePresentation(@NotNull XValueNode xValueNode, @NotNull XValuePlace xValuePlace) {
            try {
                if (xValueNode == null) {
                    DummyMessageValueNode.a(0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DummyMessageValueNode.a(illegalArgumentException);
            }
            try {
                if (xValuePlace == null) {
                    DummyMessageValueNode.a(1);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DummyMessageValueNode.a(illegalArgumentException);
            }
            xValueNode.setPresentation(this.a, new XValuePresentation(){

                @NotNull
                public String getSeparator() {
                    String string;
                    try {
                        string = "";
                        if ("" == null) {
                            1.a(0);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw 1.b(illegalStateException);
                    }
                    return string;
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer xValueTextRenderer) {
                    try {
                        if (xValueTextRenderer == null) {
                            1.a(1);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw 1.b(illegalStateException);
                    }
                    xValueTextRenderer.renderValue(DummyMessageValueNode.access$200(this));
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void a(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                private static IllegalStateException b(IllegalStateException illegalStateException) {
                    return illegalStateException;
                }
            }, false);
        }

        public String toString() {
            return this.b;
        }

        static /* synthetic */ String access$200(DummyMessageValueNode dummyMessageValueNode) {
            return dummyMessageValueNode.b;
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void a(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }
}

