/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.RemappedSourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class PositionManagerImpl
implements PositionManager,
MultiRequestPositionManager {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl b;

    public PositionManagerImpl(DebugProcessImpl debugProcessImpl) {
        this.b = debugProcessImpl;
    }

    public DebugProcess getDebugProcess() {
        return this.b;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType referenceType, @NotNull SourcePosition sourcePosition) throws NoDataException {
        List<Location> list;
        try {
            if (referenceType == null) {
                PositionManagerImpl.a(0);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            throw PositionManagerImpl.b(absentInformationException);
        }
        try {
            if (sourcePosition == null) {
                PositionManagerImpl.a(1);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            throw PositionManagerImpl.b(absentInformationException);
        }
        try {
            int n2 = sourcePosition.getLine() + 1;
            list = referenceType.locationsOfLine("Java", null, n2);
        }
        catch (AbsentInformationException absentInformationException) {
            List<Location> list2;
            try {
                list2 = Collections.emptyList();
                if (list2 == null) {
                    PositionManagerImpl.a(3);
                }
            }
            catch (AbsentInformationException absentInformationException2) {
                throw PositionManagerImpl.b(absentInformationException2);
            }
            return list2;
        }
        if (list == null) {
            PositionManagerImpl.a(2);
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition) throws NoDataException {
        try {
            if (classPrepareRequestor == null) {
                PositionManagerImpl.a(4);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        try {
            if (sourcePosition == null) {
                PositionManagerImpl.a(5);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        throw new IllegalStateException("This class implements MultiRequestPositionManager, corresponding createPrepareRequests version should be used");
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(final @NotNull ClassPrepareRequestor classPrepareRequestor, final @NotNull SourcePosition sourcePosition) throws NoDataException {
        List list;
        try {
            if (classPrepareRequestor == null) {
                PositionManagerImpl.a(6);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        try {
            if (sourcePosition == null) {
                PositionManagerImpl.a(7);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        try {
            list = (List)ReadAction.compute(() -> {
                try {
                    if (sourcePosition == null) {
                        PositionManagerImpl.a(15);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw PositionManagerImpl.b(runtimeException);
                }
                try {
                    if (classPrepareRequestor == null) {
                        PositionManagerImpl.a(16);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw PositionManagerImpl.b(runtimeException);
                }
                ArrayList<PsiClass> arrayList = new ArrayList<PsiClass>();
                for (PsiClass psiClass : PositionManagerImpl.c(sourcePosition.getFile(), sourcePosition.getLine())) {
                    Object object;
                    ClassPrepareRequestor classPrepareRequestor2 = classPrepareRequestor;
                    String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
                    if (string == null) {
                        object = JVMNameUtil.getTopLevelParentClass(psiClass);
                        try {
                            if (object == null) {
                                continue;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw PositionManagerImpl.b(runtimeException);
                        }
                        String string2 = JVMNameUtil.getNonAnonymousClassName(object);
                        try {
                            if (string2 == null) {
                                continue;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw PositionManagerImpl.b(runtimeException);
                        }
                        string = string2 + "*";
                        classPrepareRequestor2 = new ClassPrepareRequestor(){

                            public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
                                if (((DebugProcessImpl)debugProcess).getPositionManager().getAllClasses(sourcePosition).contains(referenceType)) {
                                    classPrepareRequestor.processClassPrepare(debugProcess, referenceType);
                                }
                            }
                        };
                    }
                    object = this.b.getRequestsManager().createClassPrepareRequest(classPrepareRequestor2, string);
                    try {
                        if (object == null) continue;
                        arrayList.add((PsiClass)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw PositionManagerImpl.b(runtimeException);
                    }
                }
                return arrayList;
            });
            if (list == null) {
                PositionManagerImpl.a(8);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        return list;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location2) throws NoDataException {
        Set set;
        Method method;
        Object object;
        int n2;
        Object object2;
        block26: {
            block28: {
                Object object3;
                PositionManagerImpl positionManagerImpl;
                boolean bl2;
                Logger logger;
                try {
                    DebuggerManagerThreadImpl.assertIsManagerThread();
                    if (location2 == null) {
                        return null;
                    }
                }
                catch (NoDataException noDataException) {
                    throw PositionManagerImpl.b((Exception)((Object)noDataException));
                }
                Project project2 = this.getDebugProcess().getProject();
                object2 = this.getPsiFileByLocation(project2, location2);
                try {
                    if (object2 == null) {
                        return null;
                    }
                }
                catch (NoDataException noDataException) {
                    throw PositionManagerImpl.b((Exception)((Object)noDataException));
                }
                try {
                    logger = a;
                    bl2 = this.b != null;
                }
                catch (NoDataException noDataException) {
                    throw PositionManagerImpl.b((Exception)((Object)noDataException));
                }
                logger.assertTrue(bl2);
                n2 = DebuggerUtilsEx.getLineNumber(location2, true);
                String string = location2.declaringType().name();
                String string2 = DebuggerUtilsEx.getAlternativeSourceUrl(string, project2);
                if (string2 != null && (object = VirtualFileManager.getInstance().findFileByUrl(string2)) != null && (method = object2.getManager().findFile(object)) != null) {
                    object2 = method;
                }
                object = null;
                if (n2 > -1) {
                    object = PositionManagerImpl.b(object2, n2);
                }
                method = DebuggerUtilsEx.getMethod(location2);
                try {
                    try {
                        try {
                            block27: {
                                try {
                                    try {
                                        if (object != null) break block26;
                                        if (object2 instanceof PsiCompiledElement) break block27;
                                    }
                                    catch (NoDataException noDataException) {
                                        throw PositionManagerImpl.b((Exception)((Object)noDataException));
                                    }
                                    if (n2 >= 0) break block26;
                                }
                                catch (NoDataException noDataException) {
                                    throw PositionManagerImpl.b((Exception)((Object)noDataException));
                                }
                            }
                            if (method == null) break block28;
                        }
                        catch (NoDataException noDataException) {
                            throw PositionManagerImpl.b((Exception)((Object)noDataException));
                        }
                        if (method.name() == null) break block28;
                    }
                    catch (NoDataException noDataException) {
                        throw PositionManagerImpl.b((Exception)((Object)noDataException));
                    }
                    if (method.signature() == null) break block28;
                }
                catch (NoDataException noDataException) {
                    throw PositionManagerImpl.b((Exception)((Object)noDataException));
                }
                PsiClass psiClass = this.a(string, null);
                try {
                    positionManagerImpl = this;
                    object3 = psiClass != null ? psiClass : object2;
                }
                catch (NoDataException noDataException) {
                    throw PositionManagerImpl.b((Exception)((Object)noDataException));
                }
                set = positionManagerImpl.findMethod((PsiElement)object3, string, method.name(), method.signature());
                if (set != null) {
                    object = SourcePosition.createFromElement((PsiElement)set);
                    if (n2 >= 0) {
                        object = new ClsSourcePosition((SourcePosition)object, n2);
                    }
                }
                break block26;
            }
            return SourcePosition.createFromLine((PsiFile)object2, (int)-1);
        }
        if (object == null) {
            object = SourcePosition.createFromLine((PsiFile)object2, (int)n2);
        }
        int n3 = -1;
        if (DebuggerUtilsEx.isLambda(method) && (set = ContainerUtil.map2SetNotNull(this.locationsOfLine(location2.declaringType(), (SourcePosition)object), location -> {
            Method method = location.method();
            try {
                if (DebuggerUtilsEx.isLambda(method)) {
                    return method;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
            return null;
        })).size() > 1) {
            ArrayList<Method> arrayList = new ArrayList<Method>(set);
            arrayList.sort(DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
            n3 = arrayList.indexOf(method);
        }
        return new JavaSourcePosition((SourcePosition)object, location2.declaringType(), method, n3);
    }

    private static Iterable<PsiElement> a(final PsiFile psiFile, int n2) {
        Document document;
        block7: {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            try {
                block6: {
                    try {
                        try {
                            if (document == null || n2 < 0) break block6;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw PositionManagerImpl.b(illegalStateException);
                        }
                        if (n2 < document.getLineCount()) break block7;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw PositionManagerImpl.b(illegalStateException);
                    }
                }
                return EmptyIterable.getInstance();
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
        }
        final TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement myElement;
                    {
                        this.myElement = DebuggerUtilsEx.findElementAt(psiFile, textRange.getStartOffset());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myElement != null;
                    }

                    @Override
                    public PsiElement next() {
                        PsiElement psiElement = this.myElement;
                        do {
                            this.myElement = PsiTreeUtil.nextLeaf((PsiElement)this.myElement);
                            if (this.myElement != null && this.myElement.getTextOffset() <= textRange.getEndOffset()) continue;
                            this.myElement = null;
                            break;
                        } while (this.myElement.getTextLength() == 0);
                        return psiElement;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    private static Set<PsiClass> c(PsiFile psiFile, int n2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet<PsiClass> hashSet = new HashSet<PsiClass>();
        for (PsiElement psiElement : PositionManagerImpl.a(psiFile, n2)) {
            PsiClass psiClass = PositionManagerImpl.a(psiElement);
            try {
                if (psiClass == null) continue;
                hashSet.add(psiClass);
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
        }
        return hashSet;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project2, Location location) {
        try {
            if (location == null) {
                return null;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            throw PositionManagerImpl.b(absentInformationException);
        }
        ReferenceType referenceType = location.declaringType();
        try {
            if (referenceType == null) {
                return null;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            throw PositionManagerImpl.b(absentInformationException);
        }
        String string = referenceType.name();
        Ref ref = new Ref();
        PsiClass psiClass = this.a(string, (ClsClassImpl clsClassImpl) -> ref.set((Object)this.a((ClsClassImpl)clsClassImpl)));
        try {
            if (!ref.isNull()) {
                return (PsiFile)ref.get();
            }
        }
        catch (AbsentInformationException absentInformationException) {
            throw PositionManagerImpl.b(absentInformationException);
        }
        if (psiClass != null) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiClass.getNavigationElement();
            if (psiElement2 instanceof PsiCompiledElement && !((psiElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement)) {
                psiElement2 = psiElement;
            }
            return psiElement2.getContainingFile();
        }
        try {
            PsiFile[] psiFileArray;
            for (PsiFile psiFile : psiFileArray = FilenameIndex.getFilesByName((Project)project2, (String)referenceType.sourceName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2))) {
                if (!(psiFile instanceof PsiJavaFile)) continue;
                for (PsiClass psiClass2 : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!StringUtil.equals((CharSequence)string, (CharSequence)psiClass2.getQualifiedName())) continue;
                    return psiFile;
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private PsiClass a(String string, @Nullable Consumer<ClsClassImpl> consumer) {
        PsiClass psiClass;
        block6: {
            psiClass = null;
            Sdk sdk = this.b.getSession().getAlternativeJre();
            if (sdk != null) {
                psiClass = PositionManagerImpl.findClass(this.b.getProject(), string, AlternativeJreClassFinder.getSearchScope(sdk));
                try {
                    try {
                        if (!(psiClass instanceof ClsClassImpl) || consumer == null) break block6;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw PositionManagerImpl.b(illegalStateException);
                    }
                    consumer.accept((ClsClassImpl)psiClass);
                }
                catch (IllegalStateException illegalStateException) {
                    throw PositionManagerImpl.b(illegalStateException);
                }
            }
        }
        if (psiClass == null) {
            psiClass = PositionManagerImpl.findClass(this.b.getProject(), string, this.b.getSearchScope());
        }
        return psiClass;
    }

    @Nullable
    public static PsiClass findClass(Project project2, String string, GlobalSearchScope globalSearchScope) {
        int n2;
        PsiClass psiClass = DebuggerUtils.findClass((String)string, (Project)project2, (GlobalSearchScope)globalSearchScope);
        if (psiClass == null && (n2 = string.indexOf(36)) > 0) {
            psiClass = DebuggerUtils.findClass((String)string.substring(0, n2), (Project)project2, (GlobalSearchScope)globalSearchScope);
        }
        return psiClass;
    }

    @Nullable
    private PsiFile a(ClsClassImpl clsClassImpl) {
        String string;
        String string2 = clsClassImpl.getSourceFileName();
        String string3 = ((PsiClassOwner)clsClassImpl.getContainingFile()).getPackageName();
        try {
            string = string3.isEmpty() ? string2 : string3.replace('.', '/') + '/' + string2;
        }
        catch (IllegalStateException illegalStateException) {
            throw PositionManagerImpl.b(illegalStateException);
        }
        String string4 = string;
        Sdk sdk = this.b.getSession().getAlternativeJre();
        if (sdk != null) {
            for (VirtualFile virtualFile : AlternativeJreClassFinder.getSourceRoots(sdk)) {
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string4);
                try {
                    if (virtualFile2 == null || !virtualFile2.isValid()) continue;
                }
                catch (IllegalStateException illegalStateException) {
                    throw PositionManagerImpl.b(illegalStateException);
                }
                PsiFile psiFile = clsClassImpl.getManager().findFile(virtualFile2);
                try {
                    if (!(psiFile instanceof PsiClassOwner)) continue;
                    return psiFile;
                }
                catch (IllegalStateException illegalStateException) {
                    throw PositionManagerImpl.b(illegalStateException);
                }
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition) throws NoDataException {
        List list;
        try {
            if (sourcePosition == null) {
                PositionManagerImpl.a(9);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        try {
            list = (List)ReadAction.compute(() -> {
                try {
                    if (sourcePosition == null) {
                        PositionManagerImpl.a(13);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw PositionManagerImpl.b(runtimeException);
                }
                return StreamEx.of(PositionManagerImpl.c(sourcePosition.getFile(), sourcePosition.getLine())).flatMap(psiClass -> {
                    try {
                        if (sourcePosition == null) {
                            PositionManagerImpl.a(14);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw PositionManagerImpl.b(illegalStateException);
                    }
                    return this.a((PsiClass)psiClass, sourcePosition);
                }).toList();
            });
            if (list == null) {
                PositionManagerImpl.a(10);
            }
        }
        catch (NoDataException noDataException) {
            throw PositionManagerImpl.b((Exception)((Object)noDataException));
        }
        return list;
    }

    private StreamEx<ReferenceType> a(@NotNull PsiClass psiClass, SourcePosition sourcePosition) {
        try {
            if (psiClass == null) {
                PositionManagerImpl.a(11);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PositionManagerImpl.b(illegalStateException);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl2 = false;
        int n2 = 0;
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (string == null) {
            bl2 = true;
            Pair<PsiClass, Integer> pair2 = PositionManagerImpl.a(psiClass);
            PsiClass psiClass2 = (PsiClass)pair2.first;
            if (psiClass2 != null) {
                String string2 = JVMNameUtil.getNonAnonymousClassName(psiClass2);
                if (string2 != null) {
                    n2 = (Integer)pair2.second;
                    string = string2;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                PsiTreeUtil.treeWalkUp((PsiElement)psiClass, null, (psiElement, psiElement2) -> {
                    stringBuilder.append('\n').append(psiElement);
                    return true;
                });
                a.info("Local or anonymous class " + psiClass + " has no non-local parent, parents:" + stringBuilder);
            }
        }
        try {
            if (string == null) {
                return StreamEx.empty();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PositionManagerImpl.b(illegalStateException);
        }
        try {
            if (!bl2) {
                return StreamEx.of(this.b.getVirtualMachineProxy().classesByName(string));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PositionManagerImpl.b(illegalStateException);
        }
        int n3 = n2;
        return StreamEx.of(this.b.getVirtualMachineProxy().classesByName(string)).map(referenceType -> {
            try {
                if (psiClass == null) {
                    PositionManagerImpl.a(12);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
            return this.a((ReferenceType)referenceType, 0, psiClass, n3, sourcePosition);
        }).nonNull();
    }

    private static Pair<PsiClass, Integer> a(PsiClass psiClass) {
        int n2 = 0;
        PsiClass psiClass2 = PositionManagerImpl.a((PsiElement)psiClass);
        while (true) {
            try {
                try {
                    if (psiClass2 == null) break;
                    ++n2;
                    if (psiClass2.hasModifierProperty("static")) {
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw PositionManagerImpl.b(illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
            PsiClass psiClass3 = PositionManagerImpl.a((PsiElement)psiClass2);
            try {
                if (psiClass3 == null) {
                    break;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
            psiClass2 = psiClass3;
        }
        return Pair.create((Object)psiClass2, (Object)n2);
    }

    @Nullable
    private static PsiClass a(@Nullable PsiElement psiElement) {
        try {
            if (psiElement == null) {
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PositionManagerImpl.b(illegalStateException);
        }
        psiElement = psiElement.getParent();
        PsiElement psiElement2 = null;
        while (true) {
            block13: {
                try {
                    try {
                        try {
                            if (psiElement == null) break;
                            if (!PsiClass.class.isInstance(psiElement)) break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw PositionManagerImpl.b(illegalStateException);
                        }
                        if (psiElement2 instanceof PsiExpressionList) break block13;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw PositionManagerImpl.b(illegalStateException);
                    }
                    return (PsiClass)psiElement;
                }
                catch (IllegalStateException illegalStateException) {
                    throw PositionManagerImpl.b(illegalStateException);
                }
            }
            try {
                if (psiElement instanceof PsiFile) {
                    return null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw PositionManagerImpl.b(illegalStateException);
            }
            psiElement2 = psiElement;
            psiElement = psiElement.getParent();
        }
        return null;
    }

    @Nullable
    private ReferenceType a(ReferenceType referenceType, int n2, PsiClass psiClass, int n3, SourcePosition sourcePosition) {
        block32: {
            block35: {
                int n4;
                block34: {
                    block33: {
                        ApplicationManager.getApplication().assertReadAccessAllowed();
                        VirtualMachineProxyImpl virtualMachineProxyImpl = this.b.getVirtualMachineProxy();
                        try {
                            if (!referenceType.isPrepared()) break block32;
                            if (n2 >= n3) break block33;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw PositionManagerImpl.b(illegalStateException);
                        }
                        List<ReferenceType> list = virtualMachineProxyImpl.nestedTypes(referenceType);
                        for (ReferenceType referenceType2 : list) {
                            ReferenceType referenceType3 = this.a(referenceType2, n2 + 1, psiClass, n3, sourcePosition);
                            try {
                                if (referenceType3 == null) continue;
                                return referenceType3;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw PositionManagerImpl.b(illegalStateException);
                            }
                        }
                        return null;
                    }
                    int n5 = Integer.MAX_VALUE;
                    n4 = Integer.MIN_VALUE;
                    List<Location> list = DebuggerUtilsEx.allLineLocations(referenceType);
                    if (list != null) {
                        for (Location set2 : list) {
                            int n6 = DebuggerUtilsEx.getLineNumber(set2, false);
                            try {
                                if (n6 <= 1) {
                                    continue;
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw PositionManagerImpl.b(illegalStateException);
                            }
                            Method method = DebuggerUtilsEx.getMethod(set2);
                            if (method == null || DebuggerUtils.isSynthetic((TypeComponent)method)) continue;
                            try {
                                if (method.isBridge()) {
                                    continue;
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw PositionManagerImpl.b(illegalStateException);
                            }
                            int n7 = n6 - 1;
                            PsiFile psiFile = sourcePosition.getFile().getOriginalFile();
                            if (psiFile instanceof PsiCompiledFile) {
                                n7 = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, n7);
                                try {
                                    if (n7 < 0) {
                                        continue;
                                    }
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw PositionManagerImpl.b(illegalStateException);
                                }
                            }
                            n5 = Math.min(n5, n7);
                            n4 = Math.max(n4, n7);
                        }
                    }
                    int n8 = sourcePosition.getLine();
                    try {
                        try {
                            try {
                                if (n8 < n5 || n8 > n4) break block32;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw PositionManagerImpl.b(illegalStateException);
                            }
                            if (psiClass.isValid()) break block34;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw PositionManagerImpl.b(illegalStateException);
                        }
                        return null;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw PositionManagerImpl.b(illegalStateException);
                    }
                }
                Set<PsiClass> set = PositionManagerImpl.c(sourcePosition.getFile(), n4);
                if (set.size() > 1) {
                    for (PsiClass psiClass2 : set) {
                        try {
                            if (!psiClass.equals(psiClass2)) continue;
                            return referenceType;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw PositionManagerImpl.b(illegalStateException);
                        }
                    }
                } else {
                    ReferenceType referenceType2;
                    block37: {
                        block36: {
                            try {
                                try {
                                    if (set.isEmpty()) break block35;
                                    if (!psiClass.equals(set.iterator().next())) break block36;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw PositionManagerImpl.b(illegalStateException);
                                }
                                referenceType2 = referenceType;
                                break block37;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw PositionManagerImpl.b(illegalStateException);
                            }
                        }
                        referenceType2 = null;
                    }
                    return referenceType2;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    public PsiMethod findMethod(PsiElement psiElement, String string, String string2, String string3) {
        MethodFinder methodFinder = new MethodFinder(string, string2, string3);
        psiElement.accept((PsiElementVisitor)methodFinder);
        return methodFinder.getCompiledMethod();
    }

    @Nullable
    private static SourcePosition b(PsiFile psiFile, int n2) {
        int n3 = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, n2);
        try {
            if (n3 > -1) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)n3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PositionManagerImpl.b(illegalStateException);
        }
        return null;
    }

    static /* synthetic */ PsiClass access$000(PsiElement psiElement) {
        return PositionManagerImpl.a(psiElement);
    }

    static /* synthetic */ Iterable access$100(PsiFile psiFile, int n2) {
        return PositionManagerImpl.a(psiFile, n2);
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    public static class ClsSourcePosition
    extends RemappedSourcePosition {
        private final int c;

        public ClsSourcePosition(SourcePosition sourcePosition, int n2) {
            super(sourcePosition);
            this.c = n2;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition sourcePosition) {
            PsiFile psiFile = this.getFile();
            if (this.c < 0 || !psiFile.isValid()) {
                return sourcePosition;
            }
            PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            SourcePosition sourcePosition2 = PositionManagerImpl.b(psiFile, this.c);
            return sourcePosition2 != null ? sourcePosition2 : sourcePosition;
        }
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String a;
        private PsiClass b;
        private final String e;
        private final String c;
        private PsiMethod d;

        public MethodFinder(String string, String string2, String string3) {
            this.a = string;
            this.e = string2;
            this.c = string3;
        }

        public void visitClass(PsiClass psiClass) {
            if (this.d == null) {
                if (PositionManagerImpl.this.a(psiClass, SourcePosition.createFromElement((PsiElement)psiClass)).anyMatch(referenceType -> referenceType.name().equals(this.a))) {
                    this.b = psiClass;
                }
                psiClass.acceptChildren((PsiElementVisitor)this);
            }
        }

        /*
         * Loose catch block
         */
        public void visitMethod(PsiMethod psiMethod) {
            block10: {
                if (this.d != null) break block10;
                try {
                    block12: {
                        String string;
                        block11: {
                            string = JVMNameUtil.getJVMMethodName(psiMethod);
                            PsiClass psiClass = psiMethod.getContainingClass();
                            if (psiClass == null) break block10;
                            if (!psiClass.equals(this.b)) break block10;
                            break block11;
                            catch (EvaluateException evaluateException) {
                                throw MethodFinder.a(evaluateException);
                            }
                        }
                        if (!string.equals(this.e)) break block10;
                        break block12;
                        catch (EvaluateException evaluateException) {
                            throw MethodFinder.a(evaluateException);
                        }
                    }
                    try {
                        block13: {
                            if (!JVMNameUtil.getJVMSignature(psiMethod).getName(PositionManagerImpl.this.b).equals(this.c)) break block10;
                            break block13;
                            catch (EvaluateException evaluateException) {
                                throw MethodFinder.a(evaluateException);
                            }
                        }
                        this.d = psiMethod;
                    }
                    catch (EvaluateException evaluateException) {
                        throw MethodFinder.a(evaluateException);
                    }
                }
                catch (EvaluateException evaluateException) {
                    a.debug((Throwable)evaluateException);
                }
            }
        }

        public void visitElement(PsiElement psiElement) {
            if (this.d == null) {
                super.visitElement(psiElement);
            }
        }

        @Nullable
        public PsiMethod getCompiledMethod() {
            return this.d;
        }

        private static EvaluateException a(EvaluateException evaluateException) {
            return evaluateException;
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public static class JavaSourcePosition
    extends RemappedSourcePosition {
        private final String c;
        private final String e;
        private final int d;
        static final /* synthetic */ boolean $assertionsDisabled;

        public JavaSourcePosition(@NotNull SourcePosition sourcePosition, ReferenceType referenceType, Method method, int n2) {
            String string;
            if (sourcePosition == null) {
                JavaSourcePosition.b(0);
            }
            super(sourcePosition);
            try {
                this.c = referenceType != null ? referenceType.name() : null;
                JavaSourcePosition javaSourcePosition = this;
                string = method != null ? method.name() : null;
            }
            catch (RuntimeException runtimeException) {
                throw JavaSourcePosition.b(runtimeException);
            }
            javaSourcePosition.e = string;
            this.d = n2;
        }

        public JavaSourcePosition(@NotNull SourcePosition sourcePosition, int n2) {
            if (sourcePosition == null) {
                JavaSourcePosition.b(1);
            }
            super(sourcePosition);
            if (!$assertionsDisabled) {
                try {
                    if (n2 <= -1) {
                        throw new AssertionError();
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw JavaSourcePosition.b(runtimeException);
                }
            }
            this.c = null;
            this.e = "lambda$";
            this.d = n2;
        }

        private PsiElement a(PsiElement psiElement) {
            block19: {
                PsiElement psiElement2;
                block20: {
                    block18: {
                        String string = JVMNameUtil.getClassVMName(PositionManagerImpl.access$000(psiElement));
                        try {
                            try {
                                if (string == null || string.equals(this.c)) break block18;
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                            return null;
                        }
                        catch (RuntimeException runtimeException) {
                            throw JavaSourcePosition.b(runtimeException);
                        }
                    }
                    psiElement2 = DebuggerUtilsEx.getContainingMethod(psiElement);
                    try {
                        try {
                            if (StringUtil.isEmpty((String)this.e)) break block19;
                            if (psiElement2 != null) break block20;
                        }
                        catch (RuntimeException runtimeException) {
                            throw JavaSourcePosition.b(runtimeException);
                        }
                        return null;
                    }
                    catch (RuntimeException runtimeException) {
                        throw JavaSourcePosition.b(runtimeException);
                    }
                }
                try {
                    try {
                        block21: {
                            try {
                                try {
                                    try {
                                        if (psiElement2 instanceof PsiMethod && this.e.equals(((PsiMethod)psiElement2).getName())) break block21;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        throw JavaSourcePosition.b(runtimeException);
                                    }
                                    if (!(psiElement2 instanceof PsiLambdaExpression)) break block19;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw JavaSourcePosition.b(runtimeException);
                                }
                                if (!DebuggerUtilsEx.isLambdaName(this.e)) break block19;
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                        }
                        if (!JavaSourcePosition.a(psiElement, DebuggerUtilsEx.getBody(psiElement2))) break block19;
                    }
                    catch (RuntimeException runtimeException) {
                        throw JavaSourcePosition.b(runtimeException);
                    }
                    return psiElement;
                }
                catch (RuntimeException runtimeException) {
                    throw JavaSourcePosition.b(runtimeException);
                }
            }
            return null;
        }

        private static boolean a(@NotNull PsiElement psiElement, @Nullable PsiElement psiElement2) {
            block12: {
                boolean bl2;
                block14: {
                    block13: {
                        try {
                            if (psiElement == null) {
                                JavaSourcePosition.b(2);
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw JavaSourcePosition.b(runtimeException);
                        }
                        try {
                            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement2, (PsiElement)psiElement, (boolean)false)) {
                                return false;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw JavaSourcePosition.b(runtimeException);
                        }
                        try {
                            try {
                                try {
                                    if (!(psiElement2 instanceof PsiCodeBlock)) break block12;
                                    if (psiElement.equals(((PsiCodeBlock)psiElement2).getRBrace())) break block13;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw JavaSourcePosition.b(runtimeException);
                                }
                                if (psiElement.equals(((PsiCodeBlock)psiElement2).getLBrace())) break block13;
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                            bl2 = true;
                            break block14;
                        }
                        catch (RuntimeException runtimeException) {
                            throw JavaSourcePosition.b(runtimeException);
                        }
                    }
                    bl2 = false;
                }
                return bl2;
            }
            return true;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition sourcePosition) {
            return (SourcePosition)ReadAction.compute(() -> {
                block18: {
                    int n2;
                    PsiFile psiFile;
                    block16: {
                        Document document;
                        List<PsiLambdaExpression> list;
                        block17: {
                            psiFile = sourcePosition.getFile();
                            n2 = sourcePosition.getLine();
                            try {
                                if (!DebuggerUtilsEx.isLambdaName(this.e) || this.d <= -1) break block16;
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                            list = DebuggerUtilsEx.collectLambdas(sourcePosition, true);
                            document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
                            try {
                                try {
                                    if (document != null && n2 < document.getLineCount()) break block17;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw JavaSourcePosition.b(runtimeException);
                                }
                                return sourcePosition;
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                        }
                        if (this.d < list.size()) {
                            PsiElement psiElement = DebuggerUtilsEx.getFirstElementOnTheLine(list.get(this.d), document, n2);
                            try {
                                if (psiElement != null) {
                                    return SourcePosition.createFromElement((PsiElement)psiElement);
                                }
                                break block18;
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                        }
                        break block18;
                    }
                    for (PsiElement psiElement : PositionManagerImpl.access$100(psiFile, n2)) {
                        PsiElement psiElement2 = this.a(psiElement);
                        try {
                            try {
                                if (psiElement2 == null) continue;
                                if (psiElement2.getTextOffset() <= sourcePosition.getOffset()) {
                                    break;
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                throw JavaSourcePosition.b(runtimeException);
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw JavaSourcePosition.b(runtimeException);
                        }
                        return SourcePosition.createFromElement((PsiElement)psiElement2);
                    }
                }
                return sourcePosition;
            });
        }

        static {
            boolean bl2;
            try {
                bl2 = !PositionManagerImpl.class.desiredAssertionStatus();
            }
            catch (RuntimeException runtimeException) {
                throw JavaSourcePosition.b(runtimeException);
            }
            $assertionsDisabled = bl2;
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void b(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static RuntimeException b(RuntimeException runtimeException) {
            return runtimeException;
        }
    }
}

