/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldEvaluator
implements Evaluator {
    private final Evaluator a;
    private final TargetClassFilter c;
    private final String e;
    private Object b;
    private Field d;

    public FieldEvaluator(Evaluator evaluator, TargetClassFilter targetClassFilter, @NonNls String string) {
        this.a = evaluator;
        this.e = string;
        this.c = targetClassFilter;
    }

    @NotNull
    public static TargetClassFilter createClassFilter(@Nullable PsiType psiType) {
        FQNameClassFilter fQNameClassFilter;
        block15: {
            TargetClassFilter targetClassFilter;
            block16: {
                block13: {
                    TargetClassFilter targetClassFilter2;
                    block14: {
                        try {
                            try {
                                try {
                                    if (psiType != null && !(psiType instanceof PsiArrayType)) break block13;
                                }
                                catch (NullPointerException nullPointerException) {
                                    throw FieldEvaluator.b(nullPointerException);
                                }
                                targetClassFilter2 = TargetClassFilter.ALL;
                                if (targetClassFilter2 != null) break block14;
                            }
                            catch (NullPointerException nullPointerException) {
                                throw FieldEvaluator.b(nullPointerException);
                            }
                            FieldEvaluator.a(0);
                        }
                        catch (NullPointerException nullPointerException) {
                            throw FieldEvaluator.b(nullPointerException);
                        }
                    }
                    return targetClassFilter2;
                }
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
                try {
                    try {
                        if (psiClass == null) break block15;
                        targetClassFilter = FieldEvaluator.createClassFilter(psiClass);
                        if (targetClassFilter != null) break block16;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw FieldEvaluator.b(nullPointerException);
                    }
                    FieldEvaluator.a(1);
                }
                catch (NullPointerException nullPointerException) {
                    throw FieldEvaluator.b(nullPointerException);
                }
            }
            return targetClassFilter;
        }
        try {
            fQNameClassFilter = new FQNameClassFilter(psiType.getCanonicalText());
            if (fQNameClassFilter == null) {
                FieldEvaluator.a(2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw FieldEvaluator.b(nullPointerException);
        }
        return fQNameClassFilter;
    }

    public static TargetClassFilter createClassFilter(PsiClass psiClass) {
        TargetClassFilter targetClassFilter;
        try {
            if (psiClass instanceof PsiAnonymousClass) {
                return TargetClassFilter.ALL;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw FieldEvaluator.b(nullPointerException);
        }
        try {
            if (PsiUtil.isLocalClass((PsiClass)psiClass)) {
                return new LocalClassFilter(psiClass.getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw FieldEvaluator.b(nullPointerException);
        }
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        try {
            targetClassFilter = string != null ? new FQNameClassFilter(string) : TargetClassFilter.ALL;
        }
        catch (NullPointerException nullPointerException) {
            throw FieldEvaluator.b(nullPointerException);
        }
        return targetClassFilter;
    }

    @Nullable
    private Field a(@Nullable Type type) {
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            try {
                if (this.c.acceptClass(classType)) {
                    return classType.fieldByName(this.e);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw FieldEvaluator.b(nullPointerException);
            }
            for (InterfaceType interfaceType : classType.interfaces()) {
                Field field = this.a(interfaceType);
                try {
                    if (field == null) continue;
                    return field;
                }
                catch (NullPointerException nullPointerException) {
                    throw FieldEvaluator.b(nullPointerException);
                }
            }
            return this.a(classType.superclass());
        }
        if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            try {
                if (this.c.acceptClass(interfaceType)) {
                    return interfaceType.fieldByName(this.e);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw FieldEvaluator.b(nullPointerException);
            }
            for (InterfaceType interfaceType2 : interfaceType.superinterfaces()) {
                Field field = this.a(interfaceType2);
                try {
                    if (field == null) continue;
                    return field;
                }
                catch (NullPointerException nullPointerException) {
                    throw FieldEvaluator.b(nullPointerException);
                }
            }
        }
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        this.d = null;
        this.b = null;
        Object object = this.a.evaluate(evaluationContextImpl);
        return this.a(object, evaluationContextImpl);
    }

    private Object a(Object object, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        if (object instanceof ReferenceType) {
            Field field;
            ReferenceType referenceType;
            block28: {
                block27: {
                    referenceType = (ReferenceType)object;
                    field = this.a(referenceType);
                    try {
                        if (field != null && field.isStatic()) break block27;
                    }
                    catch (EvaluateException evaluateException) {
                        throw FieldEvaluator.b((Exception)((Object)evaluateException));
                    }
                    field = referenceType.fieldByName(this.e);
                }
                try {
                    try {
                        if (field != null && field.isStatic()) break block28;
                    }
                    catch (EvaluateException evaluateException) {
                        throw FieldEvaluator.b((Exception)((Object)evaluateException));
                    }
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.field", (Object[])new Object[]{this.e}));
                }
                catch (EvaluateException evaluateException) {
                    throw FieldEvaluator.b((Exception)((Object)evaluateException));
                }
            }
            this.d = field;
            this.b = referenceType;
            return referenceType.getValue(field);
        }
        if (object instanceof ObjectReference) {
            Value value;
            Mirror mirror;
            ReferenceType referenceType;
            ObjectReference objectReference;
            block30: {
                block29: {
                    objectReference = (ObjectReference)object;
                    referenceType = objectReference.referenceType();
                    try {
                        try {
                            if (referenceType instanceof ClassType || referenceType instanceof ArrayType) break block29;
                        }
                        catch (EvaluateException evaluateException) {
                            throw FieldEvaluator.b((Exception)((Object)evaluateException));
                        }
                        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.class.or.array.expected", (Object[])new Object[]{this.e}));
                    }
                    catch (EvaluateException evaluateException) {
                        throw FieldEvaluator.b((Exception)((Object)evaluateException));
                    }
                }
                try {
                    try {
                        if (!(objectReference instanceof ArrayReference) || !"length".equals(this.e)) break block30;
                    }
                    catch (EvaluateException evaluateException) {
                        throw FieldEvaluator.b((Exception)((Object)evaluateException));
                    }
                    return DebuggerUtilsEx.createValue(evaluationContextImpl.getDebugProcess().getVirtualMachineProxy(), "int", ((ArrayReference)objectReference).length());
                }
                catch (EvaluateException evaluateException) {
                    throw FieldEvaluator.b((Exception)((Object)evaluateException));
                }
            }
            Field field = this.a(referenceType);
            if (field == null) {
                field = referenceType.fieldByName(this.e);
            }
            try {
                if (field == null) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.field", (Object[])new Object[]{this.e}));
                }
            }
            catch (EvaluateException evaluateException) {
                throw FieldEvaluator.b((Exception)((Object)evaluateException));
            }
            try {
                FieldEvaluator fieldEvaluator = this;
                mirror = field.isStatic() ? referenceType : objectReference;
            }
            catch (EvaluateException evaluateException) {
                throw FieldEvaluator.b((Exception)((Object)evaluateException));
            }
            try {
                fieldEvaluator.b = mirror;
                this.d = field;
                value = field.isStatic() ? referenceType.getValue(field) : objectReference.getValue(field);
            }
            catch (EvaluateException evaluateException) {
                throw FieldEvaluator.b((Exception)((Object)evaluateException));
            }
            return value;
        }
        try {
            if (object == null) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
            }
        }
        catch (EvaluateException evaluateException) {
            throw FieldEvaluator.b((Exception)((Object)evaluateException));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.field", (Object[])new Object[]{this.e}));
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier;
        block4: {
            block5: {
                modifier = null;
                try {
                    try {
                        if (this.d == null) break block4;
                        if (this.b instanceof ClassType) break block5;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw FieldEvaluator.b(nullPointerException);
                    }
                    if (!(this.b instanceof ObjectReference)) break block4;
                }
                catch (NullPointerException nullPointerException) {
                    throw FieldEvaluator.b(nullPointerException);
                }
            }
            modifier = new Modifier(){

                public boolean canInspect() {
                    return FieldEvaluator.this.b instanceof ObjectReference;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    if (FieldEvaluator.this.b instanceof ReferenceType) {
                        ClassType classType = (ClassType)FieldEvaluator.this.b;
                        classType.setValue(FieldEvaluator.this.d, value);
                    } else {
                        ObjectReference objectReference = (ObjectReference)FieldEvaluator.this.b;
                        objectReference.setValue(FieldEvaluator.this.d, value);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    return FieldEvaluator.this.d.type();
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    if (FieldEvaluator.this.b instanceof ObjectReference) {
                        return new FieldDescriptorImpl(project2, (ObjectReference)FieldEvaluator.this.b, FieldEvaluator.this.d);
                    }
                    return null;
                }
            };
        }
        return modifier;
    }

    public String toString() {
        return "field " + this.e;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/expression/FieldEvaluator", "createClassFilter"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static final class LocalClassFilter
    implements TargetClassFilter {
        private final String a;

        private LocalClassFilter(String string) {
            this.a = string;
        }

        @Override
        public boolean acceptClass(ReferenceType referenceType) {
            String string = referenceType.name();
            int n2 = string.lastIndexOf(this.a);
            if (n2 < 0) {
                return false;
            }
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                char c2 = string.charAt(i2);
                if (c2 == '$') {
                    return i2 < n2 - 1;
                }
                if (Character.isDigit(c2)) continue;
                return false;
            }
            return false;
        }
    }

    private static final class FQNameClassFilter
    implements TargetClassFilter {
        private final String a;

        private FQNameClassFilter(String string) {
            this.a = string;
        }

        @Override
        public boolean acceptClass(ReferenceType referenceType) {
            return referenceType.name().equals(this.a);
        }
    }

    public static interface TargetClassFilter {
        public static final TargetClassFilter ALL = referenceType -> true;

        public boolean acceptClass(ReferenceType var1);
    }
}

