/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;

class InstanceofEvaluator
implements Evaluator {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator");
    private final Evaluator c;
    private final TypeEvaluator a;

    public InstanceofEvaluator(Evaluator evaluator, TypeEvaluator typeEvaluator) {
        this.c = evaluator;
        this.a = typeEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Value value = (Value)this.c.evaluate(evaluationContextImpl);
        try {
            if (value == null) {
                return DebuggerUtilsEx.createValue(evaluationContextImpl.getDebugProcess().getVirtualMachineProxy(), PsiType.BOOLEAN.getPresentableText(), false);
            }
        }
        catch (Exception exception) {
            throw InstanceofEvaluator.b(exception);
        }
        try {
            if (!(value instanceof ObjectReference)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.object.reference.expected", (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            throw InstanceofEvaluator.b(exception);
        }
        try {
            ReferenceType referenceType = (ReferenceType)this.a.evaluate(evaluationContextImpl);
            ClassObjectReference classObjectReference = referenceType.classObject();
            ClassType classType = (ClassType)classObjectReference.referenceType();
            Method method = classType.concreteMethodByName("isAssignableFrom", "(Ljava/lang/Class;)Z");
            return evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, classObjectReference, method, Collections.singletonList(((ObjectReference)value).referenceType().classObject()));
        }
        catch (Exception exception) {
            b.debug((Throwable)exception);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    public String toString() {
        return this.c + " instanceof " + this.a;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

