/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.StringReference;
import java.util.Collections;

class LiteralEvaluator
implements Evaluator {
    private final Object a;
    private final String b;

    public LiteralEvaluator(Object object, String string) {
        this.a = object;
        this.b = string;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        try {
            if (this.a == null) {
                return null;
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        try {
            if (this.a instanceof Boolean) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, (Boolean)this.a);
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        try {
            if (this.a instanceof Character) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Character)this.a).charValue());
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        try {
            if (this.a instanceof Double) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Number)this.a).doubleValue());
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        try {
            if (this.a instanceof Float) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Number)this.a).floatValue());
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        try {
            if (this.a instanceof Number) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Number)this.a).longValue());
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        try {
            if (this.a instanceof String) {
                return virtualMachineProxyImpl.mirrorOfStringLiteral((String)this.a, (ThrowableComputable<StringReference, EvaluateException>)((ThrowableComputable)() -> {
                    StringReference stringReference;
                    block5: {
                        stringReference = virtualMachineProxyImpl.mirrorOf((String)this.a);
                        try {
                            if (!Registry.is((String)"debugger.intern.string.literals") || !virtualMachineProxyImpl.versionHigher("1.7")) break block5;
                        }
                        catch (EvaluateException evaluateException) {
                            throw LiteralEvaluator.a(evaluateException);
                        }
                        Method method = ((ClassType)stringReference.referenceType()).concreteMethodByName("intern", "()Ljava/lang/String;");
                        try {
                            if (method != null) {
                                return (StringReference)evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, stringReference, method, Collections.emptyList());
                            }
                        }
                        catch (EvaluateException evaluateException) {
                            throw LiteralEvaluator.a(evaluateException);
                        }
                    }
                    return stringReference;
                }));
            }
        }
        catch (EvaluateException evaluateException) {
            throw LiteralEvaluator.a(evaluateException);
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{this.b}));
    }

    public String toString() {
        return this.a != null ? this.a.toString() : "null";
    }

    private static EvaluateException a(EvaluateException evaluateException) {
        return evaluateException;
    }
}

